/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.smoketests.traits;

import java.util.List;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.smoketests.traits.SmokeTestCase;
import software.amazon.smithy.utils.ListUtils;

public final class SmokeTestsTrait
extends AbstractTrait {
    public static final ShapeId ID = ShapeId.from((String)"smithy.test#smokeTests");
    private final List<SmokeTestCase> testCases;

    public SmokeTestsTrait(List<SmokeTestCase> testCases) {
        this(SourceLocation.NONE, testCases);
    }

    public SmokeTestsTrait(SourceLocation sourceLocation, List<SmokeTestCase> testCases) {
        super(ID, (FromSourceLocation)sourceLocation);
        this.testCases = ListUtils.copyOf(testCases);
    }

    public List<SmokeTestCase> getTestCases() {
        return this.testCases;
    }

    protected Node createNode() {
        return (Node)this.getTestCases().stream().collect(ArrayNode.collect((SourceLocation)this.getSourceLocation()));
    }

    public static final class Provider
    extends AbstractTrait.Provider {
        public Provider() {
            super(ID);
        }

        public Trait createTrait(ShapeId target, Node value) {
            ArrayNode values = value.expectArrayNode();
            List testCases = values.getElementsAs(SmokeTestCase::fromNode);
            SmokeTestsTrait result = new SmokeTestsTrait(value.getSourceLocation(), testCases);
            result.setNodeCache(value);
            return result;
        }
    }
}

