/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.smoketests.traits;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationUtils;
import software.amazon.smithy.smoketests.traits.SmokeTestCase;
import software.amazon.smithy.smoketests.traits.SmokeTestsTrait;
import software.amazon.smithy.utils.ListUtils;

public class UniqueSmokeTestCaseIdValidator
extends AbstractValidator {
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        Set serviceShapes = model.getServiceShapes();
        HashSet serviceBoundOperationIds = new HashSet();
        for (ServiceShape service : serviceShapes) {
            Set operationIds = service.getAllOperations();
            serviceBoundOperationIds.addAll(operationIds);
            List shapes = operationIds.stream().map(arg_0 -> ((Model)model).getShape(arg_0)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            this.addValidationEventsForShapes(shapes, events);
        }
        List shapes = model.getOperationShapesWithTrait(SmokeTestsTrait.class).stream().filter(shape -> !serviceBoundOperationIds.contains(shape.getId())).collect(Collectors.toList());
        for (OperationShape shape2 : shapes) {
            this.addValidationEventsForShapes(ListUtils.of((Object)shape2), events);
        }
        return events;
    }

    private void addValidationEventsForShapes(List<? extends Shape> shapes, List<ValidationEvent> events) {
        HashMap<String, List> testCaseIdsToOperations = new HashMap<String, List>();
        for (Shape shape : shapes) {
            if (!shape.isOperationShape() || !shape.hasTrait(SmokeTestsTrait.class)) continue;
            SmokeTestsTrait trait = (SmokeTestsTrait)shape.expectTrait(SmokeTestsTrait.class);
            for (SmokeTestCase testCase : trait.getTestCases()) {
                testCaseIdsToOperations.computeIfAbsent(testCase.getId(), id -> new ArrayList()).add(shape);
            }
        }
        for (Map.Entry entry : testCaseIdsToOperations.entrySet()) {
            if (((List)entry.getValue()).size() <= 1) continue;
            for (Shape shape : (List)entry.getValue()) {
                events.add(this.error(shape, String.format("Conflicting `%s` test case IDs found for ID `%s`: %s", SmokeTestsTrait.ID, entry.getKey(), ValidationUtils.tickedList(((List)entry.getValue()).stream().map(Shape::getId)))));
            }
        }
    }
}

