/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.waiters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.SmithyInternalApi;
import software.amazon.smithy.waiters.Acceptor;
import software.amazon.smithy.waiters.AcceptorState;
import software.amazon.smithy.waiters.WaitableTrait;
import software.amazon.smithy.waiters.Waiter;
import software.amazon.smithy.waiters.WaiterMatcherValidator;

@SmithyInternalApi
public final class WaitableTraitValidator
extends AbstractValidator {
    public List<ValidationEvent> validate(Model model) {
        return model.shapes(OperationShape.class).filter(operation -> operation.hasTrait(WaitableTrait.ID)).flatMap(operation -> this.validateOperation(model, (OperationShape)operation).stream()).collect(Collectors.toList());
    }

    private List<ValidationEvent> validateOperation(Model model, OperationShape operation) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        WaitableTrait trait = (WaitableTrait)operation.expectTrait(WaitableTrait.class);
        for (Map.Entry<String, Waiter> entry : trait.getWaiters().entrySet()) {
            String waiterName = entry.getKey();
            Waiter waiter = entry.getValue();
            if (waiter.getMinDelay() > waiter.getMaxDelay()) {
                events.add(this.error((Shape)operation, (FromSourceLocation)trait, String.format("`%s` trait waiter named `%s` has a `minDelay` value of %d that is greater than its `maxDelay` value of %d", WaitableTrait.ID, waiterName, waiter.getMinDelay(), waiter.getMaxDelay())));
            }
            boolean foundSuccess = false;
            for (int i = 0; i < waiter.getAcceptors().size(); ++i) {
                Acceptor acceptor = waiter.getAcceptors().get(i);
                WaiterMatcherValidator visitor = new WaiterMatcherValidator(model, operation, waiterName, i);
                events.addAll((Collection<ValidationEvent>)acceptor.getMatcher().accept(visitor));
                if (acceptor.getState() != AcceptorState.SUCCESS) continue;
                foundSuccess = true;
            }
            if (foundSuccess) continue;
            events.add(this.error((Shape)operation, (FromSourceLocation)trait, String.format("No success state matcher found for `%s` trait waiter named `%s`", WaitableTrait.ID, waiterName)));
        }
        return events;
    }
}

