/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.waiters;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import software.amazon.smithy.jmespath.ExpressionProblem;
import software.amazon.smithy.jmespath.JmespathException;
import software.amazon.smithy.jmespath.JmespathExpression;
import software.amazon.smithy.jmespath.LinterResult;
import software.amazon.smithy.jmespath.RuntimeType;
import software.amazon.smithy.jmespath.ast.LiteralExpression;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.OperationIndex;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.waiters.Matcher;
import software.amazon.smithy.waiters.ModelRuntimeTypeGenerator;
import software.amazon.smithy.waiters.PathComparator;
import software.amazon.smithy.waiters.PathMatcher;
import software.amazon.smithy.waiters.WaitableTrait;

final class WaiterMatcherValidator
implements Matcher.Visitor<List<ValidationEvent>> {
    private static final String NON_SUPPRESSABLE_ERROR = "WaitableTrait";
    private static final String JMESPATH_PROBLEM = "WaitableTraitJmespathProblem";
    private static final String INVALID_ERROR_TYPE = "WaitableTraitInvalidErrorType";
    private final Model model;
    private final OperationShape operation;
    private final String waiterName;
    private final WaitableTrait waitable;
    private final List<ValidationEvent> events = new ArrayList<ValidationEvent>();
    private final int acceptorIndex;

    WaiterMatcherValidator(Model model, OperationShape operation, String waiterName, int acceptorIndex) {
        this.model = Objects.requireNonNull(model);
        this.operation = Objects.requireNonNull(operation);
        this.waitable = (WaitableTrait)operation.expectTrait(WaitableTrait.class);
        this.waiterName = Objects.requireNonNull(waiterName);
        this.acceptorIndex = acceptorIndex;
    }

    @Override
    public List<ValidationEvent> visitOutput(Matcher.OutputMember outputPath) {
        StructureShape struct = OperationIndex.of((Model)this.model).getOutput((ToShapeId)this.operation).orElse(null);
        if (struct == null) {
            this.addEvent(Severity.ERROR, NON_SUPPRESSABLE_ERROR, "output path used on operation with no output");
        } else {
            this.validatePathMatcher(this.createCurrentNodeFromShape((Shape)struct), outputPath.getValue());
        }
        return this.events;
    }

    @Override
    public List<ValidationEvent> visitInputOutput(Matcher.InputOutputMember inputOutputMember) {
        StructureShape output;
        OperationIndex index = OperationIndex.of((Model)this.model);
        StructureShape input = index.getInput((ToShapeId)this.operation).orElse(null);
        if (input == null) {
            this.addEvent(Severity.ERROR, NON_SUPPRESSABLE_ERROR, "inputOutput path used on operation with no input");
        }
        if ((output = (StructureShape)index.getOutput((ToShapeId)this.operation).orElse(null)) == null) {
            this.addEvent(Severity.ERROR, NON_SUPPRESSABLE_ERROR, "inputOutput path used on operation with no output");
        }
        if (input != null && output != null) {
            LinkedHashMap<String, Map> composedMap = new LinkedHashMap<String, Map>();
            composedMap.put("input", this.createCurrentNodeFromShape((Shape)input).expectObjectValue());
            composedMap.put("output", this.createCurrentNodeFromShape((Shape)output).expectObjectValue());
            LiteralExpression composedData = new LiteralExpression(composedMap);
            this.validatePathMatcher(composedData, inputOutputMember.getValue());
        }
        return this.events;
    }

    @Override
    public List<ValidationEvent> visitSuccess(Matcher.SuccessMember success) {
        return this.events;
    }

    @Override
    public List<ValidationEvent> visitErrorType(Matcher.ErrorTypeMember errorType) {
        String error = errorType.getValue();
        for (ShapeId errorId : this.operation.getErrors()) {
            if (!error.equals(errorId.toString()) && !error.equals(errorId.getName())) continue;
            return this.events;
        }
        this.addEvent(Severity.WARNING, INVALID_ERROR_TYPE, String.format("errorType '%s' not found on operation. This operation defines the following errors: %s", error, this.operation.getErrors()));
        return this.events;
    }

    @Override
    public List<ValidationEvent> visitUnknown(Matcher.UnknownMember unknown) {
        return this.events;
    }

    private void validatePathMatcher(LiteralExpression input, PathMatcher pathMatcher) {
        RuntimeType returnType = this.validatePath(input, pathMatcher.getPath());
        switch (pathMatcher.getComparator()) {
            case BOOLEAN_EQUALS: {
                if (!pathMatcher.getExpected().equals("true") && !pathMatcher.getExpected().equals("false")) {
                    this.addEvent(Severity.ERROR, NON_SUPPRESSABLE_ERROR, String.format("Waiter acceptors with a %s comparator must set their `expected` value to 'true' or 'false', but found '%s'.", new Object[]{PathComparator.BOOLEAN_EQUALS, pathMatcher.getExpected()}));
                }
                this.validateReturnType(pathMatcher.getComparator(), RuntimeType.BOOLEAN, returnType);
                break;
            }
            case STRING_EQUALS: {
                this.validateReturnType(pathMatcher.getComparator(), RuntimeType.STRING, returnType);
                break;
            }
            default: {
                this.validateReturnType(pathMatcher.getComparator(), RuntimeType.ARRAY, returnType);
            }
        }
    }

    private RuntimeType validatePath(LiteralExpression input, String path) {
        try {
            JmespathExpression expression = JmespathExpression.parse((String)path);
            LinterResult result = expression.lint(input);
            for (ExpressionProblem problem : result.getProblems()) {
                this.addJmespathEvent(path, problem);
            }
            return result.getReturnType();
        }
        catch (JmespathException e) {
            this.addEvent(Severity.ERROR, NON_SUPPRESSABLE_ERROR, String.format("Invalid JMESPath expression (%s): %s", path, e.getMessage()));
            return RuntimeType.ANY;
        }
    }

    private void validateReturnType(PathComparator comparator, RuntimeType expected, RuntimeType actual) {
        if (actual != RuntimeType.ANY && actual != expected) {
            this.addEvent(Severity.DANGER, JMESPATH_PROBLEM, String.format("Waiter acceptors with a %s comparator must return a `%s` type, but this acceptor was statically determined to return a `%s` type.", new Object[]{comparator, expected, actual}));
        }
    }

    private LiteralExpression createCurrentNodeFromShape(Shape shape) {
        return shape == null ? LiteralExpression.ANY : new LiteralExpression(shape.accept((ShapeVisitor)new ModelRuntimeTypeGenerator(this.model)));
    }

    private void addJmespathEvent(String path, ExpressionProblem problem) {
        Severity severity;
        switch (problem.severity) {
            case ERROR: {
                severity = Severity.ERROR;
                break;
            }
            case DANGER: {
                severity = Severity.DANGER;
                break;
            }
            default: {
                severity = Severity.WARNING;
            }
        }
        String problemMessage = problem.message + " (" + problem.line + ":" + problem.column + ")";
        this.addEvent(severity, severity == Severity.ERROR ? NON_SUPPRESSABLE_ERROR : JMESPATH_PROBLEM, String.format("Problem found in JMESPath expression (%s): %s", path, problemMessage));
    }

    private void addEvent(Severity severity, String id, String message) {
        this.events.add(ValidationEvent.builder().id(id).shape((Shape)this.operation).sourceLocation((FromSourceLocation)this.waitable).severity(severity).message(String.format("Waiter `%s`, acceptor %d: %s", this.waiterName, this.acceptorIndex, message)).build());
    }
}

