/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.sns;

import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.sns.SnsAsyncClient;
import software.amazon.awssdk.services.sns.model.MessageAttributeValue;
import software.amazon.awssdk.services.sns.model.PublishRequest;
import software.amazon.awssdk.services.sns.model.PublishResponse;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.payloadoffloading.PayloadStoreAsync;
import software.amazon.payloadoffloading.S3AsyncDao;
import software.amazon.payloadoffloading.S3BackedPayloadStoreAsync;
import software.amazon.payloadoffloading.Util;
import software.amazon.sns.AmazonSNSExtendedAsyncClientBase;
import software.amazon.sns.AmazonSNSExtendedClientUtil;
import software.amazon.sns.SNSExtendedAsyncClientConfiguration;

public class AmazonSNSExtendedAsyncClient
extends AmazonSNSExtendedAsyncClientBase
implements SnsAsyncClient {
    static final String USER_AGENT_HEADER = Util.getUserAgentHeader((String)AmazonSNSExtendedAsyncClient.class.getSimpleName());
    private static final Log LOGGER = LogFactory.getLog(AmazonSNSExtendedAsyncClient.class);
    private SNSExtendedAsyncClientConfiguration snsExtendedClientConfiguration;
    private PayloadStoreAsync payloadStore;

    public AmazonSNSExtendedAsyncClient(SnsAsyncClient snsClient) {
        this(snsClient, new SNSExtendedAsyncClientConfiguration());
    }

    public AmazonSNSExtendedAsyncClient(SnsAsyncClient snsClient, SNSExtendedAsyncClientConfiguration clientConfig) {
        super(snsClient);
        this.snsExtendedClientConfiguration = new SNSExtendedAsyncClientConfiguration(clientConfig);
        S3AsyncDao s3Dao = new S3AsyncDao(this.snsExtendedClientConfiguration.getS3AsyncClient());
        this.payloadStore = new S3BackedPayloadStoreAsync(s3Dao, this.snsExtendedClientConfiguration.getS3BucketName());
    }

    public AmazonSNSExtendedAsyncClient(SnsAsyncClient snsClient, SNSExtendedAsyncClientConfiguration clientConfig, PayloadStoreAsync payloadStore) {
        super(snsClient);
        this.snsExtendedClientConfiguration = clientConfig;
        this.payloadStore = payloadStore;
    }

    @Override
    public CompletableFuture<PublishResponse> publish(PublishRequest publishRequest) throws S3Exception {
        if (publishRequest == null || StringUtils.isEmpty((CharSequence)publishRequest.message())) {
            return super.publish(publishRequest);
        }
        if (!StringUtils.isEmpty((CharSequence)publishRequest.messageStructure()) && publishRequest.messageStructure().equals("json")) {
            String errorMessage = "SNS extended client does not support sending JSON messages.";
            LOGGER.error((Object)errorMessage);
            throw SdkClientException.create((String)errorMessage);
        }
        PublishRequest.Builder publishRequestBuilder = publishRequest.toBuilder();
        publishRequestBuilder.overrideConfiguration(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().putHeader("User-Agent", USER_AGENT_HEADER)).build());
        publishRequest = (PublishRequest)publishRequestBuilder.build();
        long messageAttributesSize = AmazonSNSExtendedClientUtil.getMsgAttributesSize(publishRequest.messageAttributes());
        long messageBodySize = Util.getStringSizeInBytes((String)publishRequest.message());
        if (!this.shouldExtendedStoreBeUsed(messageAttributesSize + messageBodySize)) {
            return super.publish(publishRequest);
        }
        AmazonSNSExtendedClientUtil.checkMessageAttributes(publishRequest.messageAttributes());
        AmazonSNSExtendedClientUtil.checkSizeOfMessageAttributes(this.snsExtendedClientConfiguration.getPayloadSizeThreshold(), messageAttributesSize);
        PublishRequest clonedPublishRequest = this.copyPublishRequest(publishRequest);
        return this.storeMessageInExtendedStore(clonedPublishRequest, messageAttributesSize).thenCompose(x$0 -> super.publish((PublishRequest)x$0));
    }

    private CompletableFuture<PublishRequest> storeMessageInExtendedStore(PublishRequest publishRequest, long messageAttributeSize) throws S3Exception {
        String messageContentStr = publishRequest.message();
        long messageContentSize = Util.getStringSizeInBytes((String)messageContentStr);
        String s3Key = AmazonSNSExtendedClientUtil.getS3keyAttribute(publishRequest.messageAttributes());
        PublishRequest.Builder publishRequestBuilder = publishRequest.toBuilder();
        MessageAttributeValue.Builder messageAttributeValueBuilder = MessageAttributeValue.builder();
        messageAttributeValueBuilder.dataType("Number");
        messageAttributeValueBuilder.stringValue(String.valueOf(messageContentSize));
        MessageAttributeValue messageAttributeValue = (MessageAttributeValue)messageAttributeValueBuilder.build();
        HashMap<String, MessageAttributeValue> attributes = new HashMap<String, MessageAttributeValue>(publishRequest.messageAttributes());
        attributes.put("ExtendedPayloadSize", messageAttributeValue);
        publishRequestBuilder.messageAttributes(attributes);
        AmazonSNSExtendedClientUtil.checkSizeOfMessageAttributes(this.snsExtendedClientConfiguration.getPayloadSizeThreshold(), messageAttributeSize += AmazonSNSExtendedClientUtil.getMessageAttributeSize("ExtendedPayloadSize", messageAttributeValue));
        CompletableFuture largeMessagePointerFuture = s3Key != null ? this.payloadStore.storeOriginalPayload(messageContentStr, s3Key) : this.payloadStore.storeOriginalPayload(messageContentStr);
        return largeMessagePointerFuture.thenApply(largeMessagePointer -> {
            publishRequestBuilder.message(largeMessagePointer);
            return (PublishRequest)publishRequestBuilder.build();
        });
    }

    private PublishRequest copyPublishRequest(PublishRequest publishRequest) {
        PublishRequest.Builder publishRequestBuilder = publishRequest.toBuilder();
        HashMap attributes = new HashMap(publishRequest.messageAttributes());
        publishRequestBuilder.messageAttributes(attributes);
        return (PublishRequest)publishRequestBuilder.build();
    }

    private boolean shouldExtendedStoreBeUsed(long totalMessageSize) {
        return this.snsExtendedClientConfiguration.isAlwaysThroughS3() || this.snsExtendedClientConfiguration.isPayloadSupportEnabled() && AmazonSNSExtendedClientUtil.isTotalMessageSizeLargerThanThreshold(this.snsExtendedClientConfiguration.getPayloadSizeThreshold(), totalMessageSize);
    }
}

