/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.sns;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.sns.model.MessageAttributeValue;
import software.amazon.payloadoffloading.Util;

public class AmazonSNSExtendedClientUtil {
    private static final Log LOGGER = LogFactory.getLog(AmazonSNSExtendedClientUtil.class);
    private static final String S3_KEY = "S3Key";

    public static void checkMessageAttributes(Map<String, MessageAttributeValue> messageAttributes) {
        int messageAttributesNum = messageAttributes.size();
        if (messageAttributesNum > 9) {
            String errorMessage = "Number of message attributes [" + messageAttributesNum + "] exceeds the maximum allowed for large-payload messages [" + 9 + "].";
            LOGGER.error((Object)errorMessage);
            throw SdkClientException.create((String)errorMessage);
        }
        MessageAttributeValue largePayloadAttributeName = messageAttributes.get("ExtendedPayloadSize");
        if (largePayloadAttributeName != null) {
            String errorMessage = "Message attribute name ExtendedPayloadSize is reserved for use by SNS extended client.";
            LOGGER.error((Object)errorMessage);
            throw SdkClientException.create((String)errorMessage);
        }
    }

    public static void checkSizeOfMessageAttributes(int payloadSizeThreshold, long messageAttributeSize) {
        if (messageAttributeSize > (long)payloadSizeThreshold) {
            String errorMessage = "Total size of Message attributes is " + messageAttributeSize + " bytes which is larger than the threshold of " + payloadSizeThreshold + " Bytes. Consider including the payload in the message body instead of message attributes.";
            LOGGER.error((Object)errorMessage);
            throw SdkClientException.create((String)errorMessage);
        }
    }

    public static boolean isTotalMessageSizeLargerThanThreshold(int payloadSizeThreshold, long totalMessageSize) {
        return totalMessageSize > (long)payloadSizeThreshold;
    }

    public static int getMsgAttributesSize(Map<String, MessageAttributeValue> msgAttributes) {
        int totalMsgAttributesSize = 0;
        for (Map.Entry<String, MessageAttributeValue> entry : msgAttributes.entrySet()) {
            totalMsgAttributesSize += (int)AmazonSNSExtendedClientUtil.getMessageAttributeSize(entry.getKey(), entry.getValue());
        }
        return totalMsgAttributesSize;
    }

    public static long getMessageAttributeSize(String MessageAttributeKey, MessageAttributeValue value) {
        SdkBytes binaryVal;
        String stringVal;
        long messageAttributeSize = Util.getStringSizeInBytes((String)MessageAttributeKey);
        if (value.dataType() != null) {
            messageAttributeSize += Util.getStringSizeInBytes((String)value.dataType());
        }
        if ((stringVal = value.stringValue()) != null) {
            messageAttributeSize += Util.getStringSizeInBytes((String)stringVal);
        }
        if ((binaryVal = value.binaryValue()) != null) {
            messageAttributeSize += (long)binaryVal.asByteArray().length;
        }
        return messageAttributeSize;
    }

    public static String getS3keyAttribute(Map<String, MessageAttributeValue> messageAttributes) {
        if (messageAttributes != null && messageAttributes.containsKey(S3_KEY)) {
            MessageAttributeValue attributeS3KeyValue = messageAttributes.get(S3_KEY);
            return attributeS3KeyValue == null ? null : attributeS3KeyValue.stringValue();
        }
        return null;
    }
}

