/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.timestream.jdbc;

import java.sql.ClientInfoStatus;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Map;
import java.util.ResourceBundle;
import org.slf4j.Logger;

enum Error {
    AAD_ACCESS_TOKEN_ERROR,
    ASYNC_RETRIEVAL_ERROR,
    AAD_ACCESS_TOKEN_REQUEST_FAILED,
    CANNOT_UNWRAP,
    CANNOT_CONVERT_STRING_TO_RESULT_SET,
    CANNOT_SLICE_A_STRING,
    CONN_CLOSED,
    CONN_FAILED,
    FAILED_TO_BUFFER_RESULT_SET,
    FAILED_TO_NOTIFY_CONSUMER_THREAD,
    FAILED_TO_PROPAGATE_ERROR,
    FAILED_TO_SHUTDOWN_RETRIEVAL_EXECUTOR_SERVICE,
    INCORRECT_SOURCE_TYPE_AT_CELL,
    INVALID_AAD_ACCESS_TOKEN_RESPONSE,
    INVALID_COLUMN_LABEL,
    INVALID_CONNECTION_PROPERTIES,
    INVALID_CREDENTIALS_FILE_PATH,
    INVALID_DATA_AT_ARRAY,
    INVALID_DATA_AT_ROW,
    INVALID_ENDPOINT,
    INVALID_FETCH_SIZE,
    INVALID_LARGE_MAX_ROWS_SIZE,
    INVALID_MAX_CONNECTIONS,
    INVALID_MAX_FIELD_SIZE,
    INVALID_MAX_RETRY_COUNT,
    INVALID_NUMERIC_CONNECTION_VALUE,
    INVALID_ROW_VALUE,
    INVALID_INDEX,
    INVALID_TIMEOUT,
    INVALID_TYPE,
    INVALID_QUERY,
    INVALID_SAML_RESPONSE,
    INVALID_SESSION_TOKEN_RESPONSE,
    MISSING_REQUIRED_IDP_PARAMETER,
    MISSING_SERVICE_REGION,
    OKTA_SAML_ASSERTION_ERROR,
    OKTA_SAML_ASSERTION_REQUEST_FAILED,
    OKTA_SESSION_TOKEN_REQUEST_FAILED,
    OKTA_SESSION_TOKEN_ERROR,
    PARAMETERS_NOT_SUPPORTED,
    POOLING_NOT_SUPPORTED,
    QUERY_CANCELED,
    QUERY_TIMED_OUT,
    READ_ONLY,
    RESULT_FORWARD_ONLY,
    RESULT_SET_CLOSED,
    STMT_CLOSED,
    STMT_CLOSED_DURING_EXECUTE,
    TRANSACTIONS_NOT_SUPPORTED,
    UNSUPPORTED_AWS_CREDENTIALS_PROVIDER,
    UNSUPPORTED_BINARY_STREAM,
    UNSUPPORTED_CLASS,
    UNSUPPORTED_COLUMN_PRIVILEGES,
    UNSUPPORTED_CONVERSION,
    UNSUPPORTED_CROSS_REFERENCE,
    UNSUPPORTED_EXPORTED_KEYS,
    UNSUPPORTED_FETCH_DIRECTION,
    UNSUPPORTED_FUNCTIONS,
    UNSUPPORTED_FUNCTION_COLUMNS,
    UNSUPPORTED_GENERATED_KEYS,
    UNSUPPORTED_PREPARE_CALL,
    UNSUPPORTED_PROCEDURE_COLUMNS,
    UNSUPPORTED_PROPERTY,
    UNSUPPORTED_PSEUDO_COLUMNS,
    UNSUPPORTED_REFRESH_ROW,
    UNSUPPORTED_TABLE_PRIVILEGES,
    UNSUPPORTED_TYPE,
    UNSUPPORTED_SAML_CREDENTIALS_PROVIDER,
    UNSUPPORTED_SCHEMA,
    UNSUPPORTED_SUPER_TABLES,
    UNSUPPORTED_SUPER_TYPES,
    UNSUPPORTED_USER_DEFINED_TYPES,
    UNSUPPORTED_VERSION_COLUMNS,
    VALUE_OUT_OF_RANGE;

    private static final ResourceBundle RESOURCE;

    static String lookup(Error key, Object ... formatArgs) {
        return String.format(RESOURCE.getString(key.name()), formatArgs);
    }

    static String getErrorMessage(Logger logger, Error key, Object ... formatArgs) {
        String error = Error.lookup(key, formatArgs);
        logger.error(error);
        return error;
    }

    static SQLException createSQLException(Logger logger, Error key, Object ... formatArgs) {
        return Error.createSQLException(logger, null, key, formatArgs);
    }

    static SQLException createSQLException(java.util.logging.Logger logger, Error key, Object ... formatArgs) {
        String error = Error.lookup(key, formatArgs);
        logger.severe(error);
        return new SQLException(error);
    }

    static SQLException createSQLException(Logger logger, Exception exception, Error key, Object ... formatArgs) {
        String error = Error.lookup(key, formatArgs);
        logger.error(error);
        if (exception != null) {
            return new SQLException(error, exception);
        }
        return new SQLException(error);
    }

    static SQLException createSQLException(Logger logger, String sqlState, Exception exception, Error key, Object ... formatArgs) {
        String error = Error.lookup(key, formatArgs);
        logger.error(error);
        return new SQLException(error, sqlState, exception);
    }

    static SQLFeatureNotSupportedException createSQLFeatureNotSupportedException(Logger logger, Error key, Object ... formatArgs) {
        String error = Error.lookup(key, formatArgs);
        logger.trace(error);
        return new SQLFeatureNotSupportedException(error);
    }

    static SQLClientInfoException createSQLClientInfoException(Logger logger, Error key, Map<String, ClientInfoStatus> map, Object ... formatArgs) {
        String error = Error.lookup(key, formatArgs);
        logger.error(error);
        return new SQLClientInfoException(error, map);
    }

    static {
        RESOURCE = ResourceBundle.getBundle("jdbc");
    }
}

