/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.timestream.jdbc;

import com.amazonaws.services.timestreamquery.model.Datum;
import com.amazonaws.services.timestreamquery.model.Row;
import com.amazonaws.services.timestreamquery.model.TimeSeriesDataPoint;
import com.amazonaws.services.timestreamquery.model.Type;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.timestream.jdbc.Conversions;
import software.amazon.timestream.jdbc.Error;
import software.amazon.timestream.jdbc.JdbcType;
import software.amazon.timestream.jdbc.TimestreamArrayResultSet;
import software.amazon.timestream.jdbc.TimestreamBaseResultSet;
import software.amazon.timestream.jdbc.TimestreamDataType;
import software.amazon.timestream.jdbc.TimestreamStruct;

public class TimestreamArray
implements java.sql.Array {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimestreamArray.class);
    private final TimestreamBaseResultSet parentResultSet;
    private final List<Object> timestreamArray;
    private final Map<String, Class<?>> conversionMap;
    private final Type timestreamBaseType;
    private final TimestreamDataType baseType;
    private List<Object> array;

    TimestreamArray(List<Object> timestreamArray, Type baseType, TimestreamBaseResultSet parentResultSet) {
        this(timestreamArray, baseType, parentResultSet, new HashMap());
    }

    TimestreamArray(List<Object> timestreamArray, Type baseType, TimestreamBaseResultSet parentResultSet, Map<String, Class<?>> conversionMap) {
        this.parentResultSet = parentResultSet;
        this.timestreamBaseType = baseType;
        this.baseType = TimestreamDataType.fromType(baseType);
        this.timestreamArray = timestreamArray;
        this.conversionMap = conversionMap;
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        this.verifyOpen();
        return this.baseType.getJdbcType().name();
    }

    @Override
    public int getBaseType() throws SQLException {
        this.verifyOpen();
        return this.baseType.getJdbcType().jdbcCode;
    }

    @Override
    public Object getArray() throws SQLException {
        List<Object> list = this.getArrayList();
        return this.convertToArray(list);
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        this.verifyIndex(index);
        return Arrays.copyOfRange((Object[])this.getArray(), (int)index - 1, (int)index + count);
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        this.verifyIndex(index);
        Object objectArray = this.getArray(map);
        return Arrays.copyOfRange((Object[])objectArray, (int)index - 1, (int)index + count);
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        List<Object> convertedArray = this.getArrayList(map);
        return this.convertToArray(convertedArray);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return new TimestreamArrayResultSet(this.getArrayList(), this.timestreamBaseType);
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        return new TimestreamArrayResultSet(this.getArrayList(map), TimestreamDataType.createTypeWithMap(new Type(), this.timestreamBaseType, map));
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SQLException {
        return new TimestreamArrayResultSet(this.getArrayList(index, count), this.timestreamBaseType);
    }

    @Override
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
        return new TimestreamArrayResultSet(this.getArrayList(index, count, map), TimestreamDataType.createTypeWithMap(new Type(), this.timestreamBaseType, map));
    }

    @Override
    public void free() throws SQLException {
        this.verifyOpen();
    }

    public String toString() {
        String str;
        try {
            str = (String)Conversions.convert(TimestreamDataType.ARRAY, JdbcType.VARCHAR, new Datum().withArrayValue(this.timestreamArray), this.parentResultSet::addWarning);
        }
        catch (SQLException sqlException) {
            LOGGER.warn("Unable to convert array to a string, {}", (Object)sqlException.getMessage());
            str = this.timestreamArray.toString();
        }
        return str;
    }

    protected void verifyOpen() throws SQLException {
        if (this.parentResultSet.isClosed()) {
            throw new SQLException(Error.lookup(Error.RESULT_SET_CLOSED, new Object[0]));
        }
    }

    List<Object> getArrayList() throws SQLException {
        this.verifyOpen();
        if (this.array == null) {
            this.array = this.parseArray(this.timestreamArray);
        }
        return this.array;
    }

    List<Object> getArrayList(long index, int count) throws SQLException {
        this.verifyIndex(index);
        return this.getArrayList().subList((int)index - 1, (int)index + count);
    }

    private List<Object> getArrayList(long index, int count, Map<String, Class<?>> map) throws SQLException {
        this.verifyIndex(index);
        List<Object> arrayList = this.getArrayList(map);
        return arrayList.subList((int)index - 1, (int)index + count);
    }

    private List<Object> getArrayList(Map<String, Class<?>> map) throws SQLException {
        this.verifyOpen();
        return this.parseArray(this.timestreamArray, this.baseType, map);
    }

    private List<Object> parseArray(List<?> array) throws SQLException {
        return this.parseArray(array, this.baseType, this.conversionMap);
    }

    private List<Object> parseArray(List<?> array, TimestreamDataType sourceType, Map<String, Class<?>> conversionMap) throws SQLException {
        ArrayList<Object> arrayList;
        block17: {
            block16: {
                arrayList = new ArrayList<Object>();
                if (array.isEmpty()) {
                    return arrayList;
                }
                JdbcType targetType = TimestreamDataType.retrieveTargetType(sourceType, conversionMap).getJdbcType();
                if (array.get(0) instanceof TimeSeriesDataPoint) {
                    if (sourceType != TimestreamDataType.TIMESERIES) {
                        throw new RuntimeException(Error.getErrorMessage(LOGGER, Error.INVALID_DATA_AT_ARRAY, array));
                    }
                    if (targetType == TimestreamDataType.TIMESERIES.getJdbcType()) {
                        return ImmutableList.of(array);
                    }
                    arrayList.add(Conversions.convert(sourceType, targetType, new Datum().withTimeSeriesValue(array), this.parentResultSet::addWarning));
                    return arrayList;
                }
                if (!(array.get(0) instanceof Datum)) break block16;
                switch (sourceType) {
                    case ARRAY: {
                        for (Object o : array) {
                            List arrayValue = ((Datum)o).getArrayValue();
                            if (arrayValue == null) {
                                throw new RuntimeException(Error.getErrorMessage(LOGGER, Error.INVALID_DATA_AT_ARRAY, array));
                            }
                            TimestreamArray result = new TimestreamArray(arrayValue, this.timestreamBaseType.getArrayColumnInfo().getType(), this.parentResultSet, conversionMap);
                            if (targetType == JdbcType.VARCHAR) {
                                arrayList.add(String.valueOf(result.getArrayList()));
                                continue;
                            }
                            List<Object> resultList = TimestreamArray.populateArrayListToDatum(result.getArrayList(), result);
                            TimestreamArray timestreamArray = new TimestreamArray(resultList, TimestreamDataType.createTypeWithMap(new Type(), this.timestreamBaseType.getArrayColumnInfo().getType(), conversionMap), this.parentResultSet, conversionMap);
                            arrayList.add(timestreamArray);
                        }
                        break block17;
                    }
                    case ROW: {
                        for (Object o : array) {
                            Row rowValue = ((Datum)o).getRowValue();
                            if (rowValue == null || rowValue.getData() == null) {
                                throw new RuntimeException(Error.getErrorMessage(LOGGER, Error.INVALID_DATA_AT_ROW, array));
                            }
                            TimestreamStruct struct = new TimestreamStruct(rowValue.getData(), this.timestreamBaseType.getRowColumnInfo(), this.parentResultSet, conversionMap);
                            if (targetType == JdbcType.VARCHAR) {
                                ArrayList<Datum> data = new ArrayList<Datum>();
                                for (Object attribute : struct.getAttributes()) {
                                    data.add(new Datum().withScalarValue(attribute.toString()));
                                }
                                Object object = Conversions.convert(this.baseType, targetType, new Datum().withRowValue(new Row().withData(data)), this.parentResultSet::addWarning);
                                arrayList.add(object);
                                continue;
                            }
                            List<Datum> convertedDatumList = TimestreamStruct.populateObjectToDatum(struct.getAttributes());
                            TimestreamStruct timestreamStruct = new TimestreamStruct(convertedDatumList, this.timestreamBaseType.getRowColumnInfo(), this.parentResultSet, conversionMap);
                            arrayList.add(timestreamStruct);
                        }
                        break block17;
                    }
                    default: {
                        for (Object object : array) {
                            arrayList.add(Conversions.convert(sourceType, targetType, (Datum)object, this.parentResultSet::addWarning));
                        }
                        break block17;
                    }
                }
            }
            throw new RuntimeException(Error.getErrorMessage(LOGGER, Error.INVALID_DATA_AT_ARRAY, array));
        }
        return arrayList;
    }

    static List<Object> populateArrayListToDatum(List<Object> arrayList, TimestreamArray result) throws SQLException {
        ArrayList<Object> resultList = new ArrayList<Object>();
        for (Object arrayObject : arrayList) {
            if (arrayObject instanceof TimestreamArray) {
                if (JdbcType.JAVA_OBJECT.name().equals(((TimestreamArray)arrayObject).getBaseTypeName())) {
                    resultList.add(result.timestreamArray.get(0));
                    continue;
                }
                List<Object> nestedArray = TimestreamArray.populateArrayListToDatum(((TimestreamArray)arrayObject).getArrayList(), result);
                resultList.add(new Datum().withArrayValue(nestedArray));
                continue;
            }
            if (arrayObject instanceof TimestreamStruct) {
                List<Datum> nestedRow = ((TimestreamStruct)arrayObject).getStruct();
                resultList.add(new Datum().withRowValue(new Row().withData(nestedRow)));
                continue;
            }
            if (arrayObject instanceof ArrayList) {
                resultList.add(new Datum().withTimeSeriesValue((Collection)((List)arrayObject)));
                continue;
            }
            resultList.add(new Datum().withScalarValue(arrayObject.toString()));
        }
        return resultList;
    }

    private void verifyIndex(long arrayIndex) throws SQLException {
        if (1L > arrayIndex || arrayIndex > (long)this.timestreamArray.size()) {
            throw Error.createSQLException(LOGGER, Error.INVALID_INDEX, arrayIndex, this.timestreamArray.size());
        }
    }

    private Object convertToArray(List<Object> list) {
        if (!list.isEmpty() && list.get(0) instanceof TimestreamArray) {
            return this.convertToArray(list, list.get(0).getClass());
        }
        return list.toArray();
    }

    private <T> Object convertToArray(List<Object> arrayList, Class<T> valueClass) {
        return arrayList.toArray((Object[])Array.newInstance(valueClass, arrayList.size()));
    }

    List<Object> getTimestreamArray() {
        return this.timestreamArray;
    }
}

