/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.timestream.jdbc;

import com.amazonaws.ClientConfiguration;
import com.google.common.annotations.VisibleForTesting;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import org.slf4j.bridge.SLF4JBridgeHandler;
import software.amazon.timestream.jdbc.Error;
import software.amazon.timestream.jdbc.TimestreamConnection;
import software.amazon.timestream.jdbc.TimestreamConnectionProperty;
import software.amazon.timestream.jdbc.TimestreamDriver;
import software.amazon.timestream.jdbc.TimestreamPooledConnection;

public class TimestreamDataSource
implements DataSource,
ConnectionPoolDataSource,
ConnectionEventListener {
    private static final Logger LOGGER = Logger.getLogger("TimestreamDataSource");
    @VisibleForTesting
    final ClientConfiguration clientConfiguration = new ClientConfiguration().withUserAgentSuffix("ts-jdbc." + TimestreamDriver.DRIVER_VERSION + TimestreamDriver.APP_NAME_SUFFIX);
    @VisibleForTesting
    final Map<Properties, LinkedList<TimestreamConnection>> availablePools = new HashMap<Properties, LinkedList<TimestreamConnection>>();
    private final Properties samlAuthenticationProperties = new Properties();
    private final Properties sdkProperties = new Properties();
    private String accessKeyId;
    private String secretAccessKey;
    private String sessionToken;
    private String region;
    private String credentialsProviderClass;
    private String credentialsFilePath;
    private String endpoint;
    private boolean isEnableMetaDataPreparedStatement = Boolean.parseBoolean(TimestreamConnectionProperty.ENABLE_METADATA_PREPARED_STATEMENT.getDefaultValue());

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.accessKeyId, this.secretAccessKey);
    }

    @Override
    public Connection getConnection(String accessKey, String secretKey) throws SQLException {
        LOGGER.fine("Instantiating a TimestreamConnection from TimestreamDataSource.");
        return this.createTimestreamConnection(this.getProperties(accessKey, secretKey));
    }

    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        return this.getPooledConnection(this.accessKeyId, this.secretAccessKey);
    }

    @Override
    public PooledConnection getPooledConnection(String accessKey, String secretKey) throws SQLException {
        Properties properties = this.getProperties(accessKey, secretKey);
        List poolForCredentials = this.availablePools.computeIfAbsent(properties, k -> new LinkedList());
        TimestreamPooledConnection timestreamPooledConnection = null;
        while (!poolForCredentials.isEmpty() && timestreamPooledConnection == null) {
            TimestreamConnection connection = (TimestreamConnection)poolForCredentials.remove(0);
            if (connection.isClosed()) continue;
            LOGGER.info("Returning an open connection from the connection pool.");
            timestreamPooledConnection = this.createTimestreamPooledConnection(connection);
        }
        if (timestreamPooledConnection == null) {
            LOGGER.info("Could not find a connection in the pool, creating a connection.");
            timestreamPooledConnection = this.createTimestreamPooledConnection(this.createTimestreamConnection(this.getProperties(accessKey, secretKey)));
        }
        timestreamPooledConnection.addConnectionEventListener(this);
        return timestreamPooledConnection;
    }

    @Override
    public PrintWriter getLogWriter() {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter out) {
    }

    @Override
    public int getLoginTimeout() {
        return this.clientConfiguration.getConnectionTimeout() / 1000;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        if (seconds < 0) {
            throw Error.createSQLException(LOGGER, Error.INVALID_TIMEOUT, seconds);
        }
        this.clientConfiguration.setConnectionTimeout(seconds * 1000);
    }

    @Override
    public Logger getParentLogger() {
        return LOGGER;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return null != iface && iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw Error.createSQLException(LOGGER, Error.CANNOT_UNWRAP, iface.toString());
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public String getSecretAccessKey() {
        return this.secretAccessKey;
    }

    public void setSecretAccessKey(String secretAccessKey) {
        this.secretAccessKey = secretAccessKey;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public void setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public boolean isEnableMetaDataPreparedStatement() {
        return this.isEnableMetaDataPreparedStatement;
    }

    public void setEnableMetaDataPreparedStatement(boolean enableMetaDataPreparedStatement) {
        this.isEnableMetaDataPreparedStatement = enableMetaDataPreparedStatement;
    }

    public String getCredentialsProviderClass() {
        return this.credentialsProviderClass;
    }

    public void setCredentialsProviderClass(String credentialsProviderClass) {
        this.credentialsProviderClass = credentialsProviderClass;
    }

    public String getCredentialsFilePath() {
        return this.credentialsFilePath;
    }

    public void setCredentialsFilePath(String credentialsFilePath) {
        this.credentialsFilePath = credentialsFilePath;
    }

    public String getIdpName() {
        return this.samlAuthenticationProperties.getOrDefault((Object)TimestreamConnectionProperty.IDP_NAME.getConnectionProperty(), TimestreamConnectionProperty.IDP_NAME.getDefaultValue()).toString();
    }

    public void setIdpName(String idpName) {
        this.samlAuthenticationProperties.put(TimestreamConnectionProperty.IDP_NAME.getConnectionProperty(), idpName);
    }

    public String getIdpHost() {
        return this.samlAuthenticationProperties.getOrDefault((Object)TimestreamConnectionProperty.IDP_HOST.getConnectionProperty(), TimestreamConnectionProperty.IDP_HOST.getDefaultValue()).toString();
    }

    public void setIdpHost(String idpHost) {
        this.samlAuthenticationProperties.put(TimestreamConnectionProperty.IDP_HOST.getConnectionProperty(), idpHost);
    }

    public String getIdpUserName() {
        return this.samlAuthenticationProperties.getOrDefault((Object)TimestreamConnectionProperty.IDP_USERNAME.getConnectionProperty(), TimestreamConnectionProperty.IDP_USERNAME.getDefaultValue()).toString();
    }

    public void setIdpUserName(String idpUserName) {
        this.samlAuthenticationProperties.put(TimestreamConnectionProperty.IDP_USERNAME.getConnectionProperty(), idpUserName);
    }

    public String getIdpPassword() {
        return this.samlAuthenticationProperties.getOrDefault((Object)TimestreamConnectionProperty.IDP_PASSWORD.getConnectionProperty(), TimestreamConnectionProperty.IDP_PASSWORD.getDefaultValue()).toString();
    }

    public void setIdpPassword(String idpPassword) {
        this.samlAuthenticationProperties.put(TimestreamConnectionProperty.IDP_PASSWORD.getConnectionProperty(), idpPassword);
    }

    public String getOktaAppId() {
        return this.samlAuthenticationProperties.getOrDefault((Object)TimestreamConnectionProperty.OKTA_APP_ID.getConnectionProperty(), TimestreamConnectionProperty.OKTA_APP_ID.getDefaultValue()).toString();
    }

    public void setOktaAppId(String oktaAppId) {
        this.samlAuthenticationProperties.put(TimestreamConnectionProperty.OKTA_APP_ID.getConnectionProperty(), oktaAppId);
    }

    public String getAwsRoleArn() {
        return this.samlAuthenticationProperties.getOrDefault((Object)TimestreamConnectionProperty.AWS_ROLE_ARN.getConnectionProperty(), TimestreamConnectionProperty.AWS_ROLE_ARN.getDefaultValue()).toString();
    }

    public void setAwsRoleArn(String awsRoleArn) {
        this.samlAuthenticationProperties.put(TimestreamConnectionProperty.AWS_ROLE_ARN.getConnectionProperty(), awsRoleArn);
    }

    public String getIdpArn() {
        return this.samlAuthenticationProperties.getOrDefault((Object)TimestreamConnectionProperty.IDP_ARN.getConnectionProperty(), TimestreamConnectionProperty.IDP_ARN.getDefaultValue()).toString();
    }

    public void setIdpArn(String idpArn) {
        this.samlAuthenticationProperties.put(TimestreamConnectionProperty.IDP_ARN.getConnectionProperty(), idpArn);
    }

    public String getAadAppId() {
        return this.samlAuthenticationProperties.getOrDefault((Object)TimestreamConnectionProperty.AAD_APP_ID.getConnectionProperty(), TimestreamConnectionProperty.AAD_APP_ID.getDefaultValue()).toString();
    }

    public void setAadAppId(String aadAppId) {
        this.samlAuthenticationProperties.put(TimestreamConnectionProperty.AAD_APP_ID.getConnectionProperty(), aadAppId);
    }

    public String getAadClientSecret() {
        return this.samlAuthenticationProperties.getOrDefault((Object)TimestreamConnectionProperty.AAD_CLIENT_SECRET.getConnectionProperty(), TimestreamConnectionProperty.AAD_CLIENT_SECRET.getDefaultValue()).toString();
    }

    public void setAadClientSecret(String aadClientSecret) {
        this.samlAuthenticationProperties.put(TimestreamConnectionProperty.AAD_CLIENT_SECRET.getConnectionProperty(), aadClientSecret);
    }

    public String getAadTenantId() {
        return this.samlAuthenticationProperties.getOrDefault((Object)TimestreamConnectionProperty.AAD_TENANT_ID.getConnectionProperty(), TimestreamConnectionProperty.AAD_TENANT_ID.getDefaultValue()).toString();
    }

    public void setAadTenantId(String aadTenantId) {
        this.samlAuthenticationProperties.put(TimestreamConnectionProperty.AAD_TENANT_ID.getConnectionProperty(), aadTenantId);
    }

    public int getRequestTimeout() {
        return Integer.parseInt(this.sdkProperties.getOrDefault((Object)TimestreamConnectionProperty.REQUEST_TIMEOUT.getConnectionProperty(), TimestreamConnectionProperty.REQUEST_TIMEOUT.getDefaultValue()).toString());
    }

    public void setRequestTimeout(int requestTimeout) {
        this.sdkProperties.setProperty(TimestreamConnectionProperty.REQUEST_TIMEOUT.getConnectionProperty(), String.valueOf(requestTimeout));
    }

    public int getSocketTimeout() {
        return Integer.parseInt(this.sdkProperties.getOrDefault((Object)TimestreamConnectionProperty.SOCKET_TIMEOUT.getConnectionProperty(), TimestreamConnectionProperty.SOCKET_TIMEOUT.getDefaultValue()).toString());
    }

    public void setSocketTimeout(int socketTimeout) throws SQLException {
        if (socketTimeout < 0) {
            throw Error.createSQLException(LOGGER, Error.INVALID_TIMEOUT, socketTimeout);
        }
        this.sdkProperties.setProperty(TimestreamConnectionProperty.SOCKET_TIMEOUT.getConnectionProperty(), String.valueOf(socketTimeout));
    }

    public int getMaxConnections() {
        return Integer.parseInt(this.sdkProperties.getOrDefault((Object)TimestreamConnectionProperty.MAX_CONNECTIONS.getConnectionProperty(), TimestreamConnectionProperty.MAX_CONNECTIONS.getDefaultValue()).toString());
    }

    public void setMaxConnections(int maxConnections) throws SQLException {
        if (maxConnections < 0) {
            throw Error.createSQLException(LOGGER, Error.INVALID_MAX_CONNECTIONS, maxConnections);
        }
        this.sdkProperties.setProperty(TimestreamConnectionProperty.MAX_CONNECTIONS.getConnectionProperty(), String.valueOf(maxConnections));
    }

    public int getMaxRetryCount() {
        String maxRetry = this.sdkProperties.getProperty(TimestreamConnectionProperty.MAX_RETRY_COUNT.getConnectionProperty());
        return maxRetry == null ? -1 : Integer.parseInt(maxRetry);
    }

    public void setMaxRetryCount(int maxRetryCountClient) throws SQLException {
        if (maxRetryCountClient < 0) {
            throw Error.createSQLException(LOGGER, Error.INVALID_MAX_RETRY_COUNT, maxRetryCountClient);
        }
        this.sdkProperties.setProperty(TimestreamConnectionProperty.MAX_RETRY_COUNT.getConnectionProperty(), String.valueOf(maxRetryCountClient));
    }

    @Override
    public void connectionClosed(ConnectionEvent event) {
        TimestreamPooledConnection eventSource = (TimestreamPooledConnection)event.getSource();
        eventSource.removeConnectionEventListener(this);
        TimestreamConnection connection = (TimestreamConnection)eventSource.getConnection();
        if (connection.isClosed()) {
            LOGGER.info("Connection is closed, not recycling connection back into the connection pool.");
        } else {
            LOGGER.info("Connection is still open, recycling the connection back into the connection pool.");
            this.availablePools.get(connection.getConnectionProperties()).add(connection);
        }
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent event) {
    }

    private Properties getProperties(String accessKey, String secretKey) throws SQLException {
        Properties properties = new Properties();
        if (accessKey != null && secretKey != null) {
            properties.put(TimestreamConnectionProperty.ACCESS_KEY_ID.getConnectionProperty(), accessKey);
            properties.put(TimestreamConnectionProperty.SECRET_ACCESS_KEY.getConnectionProperty(), secretKey);
        }
        if (this.getSessionToken() != null) {
            properties.put(TimestreamConnectionProperty.SESSION_TOKEN.getConnectionProperty(), this.getSessionToken());
        }
        if (this.endpoint != null) {
            if (this.endpoint.isEmpty()) {
                String error = Error.lookup(Error.INVALID_ENDPOINT, new Object[0]);
                LOGGER.severe(error);
                throw new SQLException(error);
            }
            if (this.region == null) {
                String error = Error.lookup(Error.MISSING_SERVICE_REGION, new Object[0]);
                LOGGER.severe(error);
                throw new SQLException(error);
            }
            properties.put(TimestreamConnectionProperty.ENDPOINT.getConnectionProperty(), this.endpoint);
            properties.put(TimestreamConnectionProperty.REGION.getConnectionProperty(), this.region);
        }
        if (this.samlAuthenticationProperties.get(TimestreamConnectionProperty.IDP_NAME.getConnectionProperty()) != null) {
            properties.putAll((Map<?, ?>)this.samlAuthenticationProperties);
        }
        if (this.credentialsProviderClass != null) {
            properties.put(TimestreamConnectionProperty.AWS_CREDENTIALS_PROVIDER_CLASS.getConnectionProperty(), this.credentialsProviderClass);
            if (this.credentialsFilePath != null) {
                properties.put(TimestreamConnectionProperty.CUSTOM_CREDENTIALS_FILE_PATH.getConnectionProperty(), this.credentialsFilePath);
            }
        }
        properties.putAll((Map<?, ?>)this.sdkProperties);
        return properties;
    }

    private TimestreamPooledConnection createTimestreamPooledConnection(TimestreamConnection timestreamConnection) {
        return new TimestreamPooledConnection(timestreamConnection);
    }

    protected TimestreamConnection createTimestreamConnection(Properties info) throws SQLException {
        return new TimestreamConnection(info, this.clientConfiguration);
    }

    static {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        LOGGER.setLevel(Level.FINEST);
    }
}

