/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.timestream.jdbc;

import com.google.common.base.Strings;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.StringJoiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.timestream.jdbc.Error;
import software.amazon.timestream.jdbc.TimestreamAttributesResultSet;
import software.amazon.timestream.jdbc.TimestreamBestRowIdentifierResultSet;
import software.amazon.timestream.jdbc.TimestreamColumnsResultSet;
import software.amazon.timestream.jdbc.TimestreamConnection;
import software.amazon.timestream.jdbc.TimestreamConnectionProperty;
import software.amazon.timestream.jdbc.TimestreamDatabasesResultSet;
import software.amazon.timestream.jdbc.TimestreamDriver;
import software.amazon.timestream.jdbc.TimestreamImportedKeysResultSet;
import software.amazon.timestream.jdbc.TimestreamIndexResultSet;
import software.amazon.timestream.jdbc.TimestreamPrimaryKeysResultSet;
import software.amazon.timestream.jdbc.TimestreamProceduresResultSet;
import software.amazon.timestream.jdbc.TimestreamPropertiesResultSet;
import software.amazon.timestream.jdbc.TimestreamSchemasResultSet;
import software.amazon.timestream.jdbc.TimestreamTableTypesResultSet;
import software.amazon.timestream.jdbc.TimestreamTablesResultSet;
import software.amazon.timestream.jdbc.TimestreamTypeInfoResultSet;

public class TimestreamDatabaseMetaData
implements DatabaseMetaData {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimestreamDatabaseMetaData.class);
    private static final int MAX_CATALOG_NAME_LENGTH = 60;
    private static final int MAX_TABLE_NAME_LENGTH = 60;
    private static final int MAX_STATEMENT_LENGTH = 65536;
    private static final String NUMERIC_FUNCTIONS = String.join((CharSequence)",", "ABS", "ACOS", "ASIN", "ATAN", "ATAN2", "CBRT", "CEIL", "CEILING", "COS", "COSH", "DEGREES", "E", "EXP", "FLOOR", "LN", "LOG2", "LOG10", "MOD", "PI", "POW", "POWER", "RADIANS", "RAND", "RANDOM", "ROUND", "SIGN", "SIN", "SQRT", "TAN", "TANH", "TRUNCATE");
    private static final String STRING_FUNCTIONS = String.join((CharSequence)",", "CHR", "CODEPOINT", "CONCAT", "LENGTH", "LOWER", "LPAD", "LTRIM", "REPLACE", "REVERSE", "RPAD", "RTRIM", "SPLIT", "STRPOS", "STRRPOS", "POSITION", "SUBSTR", "TRIM", "UPPER");
    private static final String SYSTEM_FUNCTIONS = String.join((CharSequence)",", new String[0]);
    private static final String TIMEDATE_FUNCTIONS = String.join((CharSequence)",", "CURRENT_DATE", "CURRENT_TIMESTAMP", "DATE_TRUNC", "NOW");
    private final TimestreamConnection connection;

    public TimestreamDatabaseMetaData(TimestreamConnection connection) {
        this.connection = connection;
    }

    @Override
    public boolean allProceduresAreCallable() {
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() {
        return true;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) {
        return false;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() {
        return true;
    }

    @Override
    public boolean generatedKeyAlwaysReturned() {
        return false;
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) {
        return new TimestreamAttributesResultSet();
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) {
        return new TimestreamBestRowIdentifierResultSet();
    }

    @Override
    public String getCatalogSeparator() {
        return ".";
    }

    @Override
    public String getCatalogTerm() {
        return "database";
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        return new TimestreamDatabasesResultSet(this.connection);
    }

    @Override
    public ResultSet getClientInfoProperties() {
        return new TimestreamPropertiesResultSet();
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.UNSUPPORTED_COLUMN_PRIVILEGES, new Object[0]);
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaNamePattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return new TimestreamColumnsResultSet(this.connection, catalog, tableNamePattern, TimestreamDatabaseMetaData.convertPattern(columnNamePattern));
    }

    @Override
    public TimestreamConnection getConnection() {
        return this.connection;
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.UNSUPPORTED_CROSS_REFERENCE, new Object[0]);
    }

    @Override
    public int getDatabaseMajorVersion() {
        return 1;
    }

    @Override
    public int getDatabaseMinorVersion() {
        return 0;
    }

    @Override
    public String getDatabaseProductName() {
        return "Amazon Timestream";
    }

    @Override
    public String getDatabaseProductVersion() {
        return "1.0";
    }

    @Override
    public int getDefaultTransactionIsolation() {
        return 0;
    }

    @Override
    public int getDriverMajorVersion() {
        return TimestreamDriver.DRIVER_MAJOR_VERSION;
    }

    @Override
    public int getDriverMinorVersion() {
        return TimestreamDriver.DRIVER_MINOR_VERSION;
    }

    @Override
    public String getDriverName() {
        return "Amazon Timestream JDBC";
    }

    @Override
    public String getDriverVersion() {
        return TimestreamDriver.DRIVER_VERSION;
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.UNSUPPORTED_EXPORTED_KEYS, new Object[0]);
    }

    @Override
    public String getExtraNameCharacters() {
        return "@";
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaNamePattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.UNSUPPORTED_FUNCTION_COLUMNS, new Object[0]);
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.UNSUPPORTED_FUNCTIONS, new Object[0]);
    }

    @Override
    public String getIdentifierQuoteString() {
        return "\"";
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) {
        return new TimestreamImportedKeysResultSet();
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) {
        return new TimestreamIndexResultSet();
    }

    @Override
    public int getJDBCMajorVersion() {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() {
        return 2;
    }

    @Override
    public int getMaxBinaryLiteralLength() {
        LOGGER.debug("Binary is not a supported data type.");
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() {
        return 60;
    }

    @Override
    public int getMaxCharLiteralLength() {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() {
        return 0;
    }

    @Override
    public int getMaxColumnsInGroupBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() {
        return 0;
    }

    @Override
    public int getMaxConnections() {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() {
        return 0;
    }

    @Override
    public int getMaxIndexLength() {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() {
        return 0;
    }

    @Override
    public int getMaxRowSize() {
        return 0x100000;
    }

    @Override
    public int getMaxSchemaNameLength() {
        return 0;
    }

    @Override
    public int getMaxStatementLength() {
        return 65536;
    }

    @Override
    public int getMaxStatements() {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() {
        return 60;
    }

    @Override
    public int getMaxTablesInSelect() {
        return 1;
    }

    @Override
    public int getMaxUserNameLength() {
        return 0;
    }

    @Override
    public String getNumericFunctions() {
        return NUMERIC_FUNCTIONS;
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) {
        return new TimestreamPrimaryKeysResultSet();
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.UNSUPPORTED_PROCEDURE_COLUMNS, new Object[0]);
    }

    @Override
    public String getProcedureTerm() {
        LOGGER.debug("Procedures are not supported. Returning null.");
        return null;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) {
        LOGGER.debug("Procedures are not supported. Returning an empty result set.");
        return new TimestreamProceduresResultSet();
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.UNSUPPORTED_PSEUDO_COLUMNS, new Object[0]);
    }

    @Override
    public int getResultSetHoldability() {
        return 2;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public String getSQLKeywords() {
        return "DATABASE,TIMESERIES,MEASURES";
    }

    @Override
    public int getSQLStateType() {
        return 2;
    }

    @Override
    public String getSchemaTerm() {
        LOGGER.debug("Schemas are not supported. Returning an empty string.");
        return "";
    }

    @Override
    public ResultSet getSchemas() {
        LOGGER.debug("Schemas are not supported. Returning an empty result set.");
        return new TimestreamSchemasResultSet();
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) {
        LOGGER.debug("Schemas are not supported. Returning an empty result set.");
        return new TimestreamSchemasResultSet();
    }

    @Override
    public String getSearchStringEscape() {
        return "%";
    }

    @Override
    public String getStringFunctions() {
        return STRING_FUNCTIONS;
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.UNSUPPORTED_SUPER_TABLES, new Object[0]);
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.UNSUPPORTED_SUPER_TYPES, new Object[0]);
    }

    @Override
    public String getSystemFunctions() {
        return SYSTEM_FUNCTIONS;
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.UNSUPPORTED_TABLE_PRIVILEGES, new Object[0]);
    }

    @Override
    public ResultSet getTableTypes() {
        return new TimestreamTableTypesResultSet();
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        return new TimestreamTablesResultSet(this.connection, catalog, tableNamePattern, types);
    }

    @Override
    public String getTimeDateFunctions() {
        return TIMEDATE_FUNCTIONS;
    }

    @Override
    public ResultSet getTypeInfo() {
        return new TimestreamTypeInfoResultSet();
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.UNSUPPORTED_USER_DEFINED_TYPES, new Object[0]);
    }

    @Override
    public String getURL() {
        StringJoiner joiner = new StringJoiner(";");
        for (TimestreamConnectionProperty value : TimestreamConnectionProperty.values()) {
            Object property = this.getConnection().getConnectionProperties().get(value.getConnectionProperty());
            String propertyStringPrefix = value.getConnectionProperty() + "=";
            if (property != null) {
                if (TimestreamConnectionProperty.SENSITIVE_PROPERTIES.contains((Object)value)) {
                    joiner.add(propertyStringPrefix + "***Sensitive Data Redacted***");
                    continue;
                }
                joiner.add(propertyStringPrefix + property);
                continue;
            }
            if (value != TimestreamConnectionProperty.REGION) continue;
            joiner.add(propertyStringPrefix + value.getDefaultValue());
        }
        LOGGER.debug("Sensitive data in the URL should be redacted.");
        return "jdbc:timestream://" + joiner.toString();
    }

    @Override
    public String getUserName() {
        LOGGER.debug("User name is not supported. Returning null.");
        return null;
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.UNSUPPORTED_VERSION_COLUMNS, new Object[0]);
    }

    @Override
    public boolean insertsAreDetected(int type) {
        return false;
    }

    @Override
    public boolean isCatalogAtStart() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return null != iface && iface.isAssignableFrom(this.getClass());
    }

    @Override
    public boolean locatorsUpdateCopy() {
        return false;
    }

    @Override
    public boolean nullPlusNonNullIsNull() {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtEnd() {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtStart() {
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) {
        return false;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() {
        return true;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() {
        return true;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() {
        return true;
    }

    @Override
    public boolean supportsANSI92FullSQL() {
        return false;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() {
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() {
        return true;
    }

    @Override
    public boolean supportsConvert() {
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) {
        return false;
    }

    @Override
    public boolean supportsCoreSQLGrammar() {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() {
        return true;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() {
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() {
        return false;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() {
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        return false;
    }

    @Override
    public boolean supportsGroupBy() {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() {
        return false;
    }

    @Override
    public boolean supportsLikeEscapeClause() {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() {
        return true;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() {
        return true;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() {
        return true;
    }

    @Override
    public boolean supportsMultipleOpenResults() {
        return false;
    }

    @Override
    public boolean supportsMultipleResultSets() {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() {
        return false;
    }

    @Override
    public boolean supportsNamedParameters() {
        return false;
    }

    @Override
    public boolean supportsNonNullableColumns() {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() {
        return false;
    }

    @Override
    public boolean supportsOrderByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsPositionedDelete() {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() {
        return false;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) {
        return type == 1003 && concurrency == 1007;
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) {
        return false;
    }

    @Override
    public boolean supportsResultSetType(int type) {
        return 1003 == type;
    }

    @Override
    public boolean supportsSavepoints() {
        return false;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() {
        return false;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() {
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() {
        return false;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() {
        return true;
    }

    @Override
    public boolean supportsTableCorrelationNames() {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) {
        return false;
    }

    @Override
    public boolean supportsTransactions() {
        return false;
    }

    @Override
    public boolean supportsUnion() {
        return true;
    }

    @Override
    public boolean supportsUnionAll() {
        return true;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw Error.createSQLException(LOGGER, Error.CANNOT_UNWRAP, iface.toString());
    }

    @Override
    public boolean updatesAreDetected(int type) {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() {
        return false;
    }

    @Override
    public boolean usesLocalFiles() {
        return false;
    }

    private static String convertPattern(String pattern) {
        if (Strings.isNullOrEmpty((String)pattern)) {
            return pattern;
        }
        return "^" + pattern.replaceAll("\\[", "\\[").replaceAll("]", "\\]").replaceAll("\\.", "\\.").replaceAll("\\*", "\\*").replaceAll("(?<!\\\\)_", ".").replaceAll("\\\\_", "_").replaceAll("(?<!\\\\)%", ".*").replaceAll("\\\\%", "%") + "$";
    }
}

