/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.timestream.jdbc;

import com.amazonaws.services.timestreamquery.model.ColumnInfo;
import com.amazonaws.services.timestreamquery.model.Datum;
import com.amazonaws.services.timestreamquery.model.Row;
import com.google.common.collect.ImmutableList;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import software.amazon.timestream.jdbc.TimestreamBaseResultSet;
import software.amazon.timestream.jdbc.TimestreamConnectionProperty;
import software.amazon.timestream.jdbc.TimestreamDataType;

public class TimestreamPropertiesResultSet
extends TimestreamBaseResultSet {
    private static final List<ColumnInfo> COLUMNS = ImmutableList.of((Object)TimestreamDataType.createColumnInfo(TimestreamDataType.VARCHAR, "NAME"), (Object)TimestreamDataType.createColumnInfo(TimestreamDataType.INTEGER, "MAX_LEN"), (Object)TimestreamDataType.createColumnInfo(TimestreamDataType.VARCHAR, "DEFAULT_VALUE"), (Object)TimestreamDataType.createColumnInfo(TimestreamDataType.VARCHAR, "DESCRIPTION"));
    private final List<Row> columns = new ArrayList<Row>();

    public TimestreamPropertiesResultSet() {
        super(null, 1000);
        this.rsMeta = this.createColumnMetadata(COLUMNS);
        this.populateCurrentRows();
    }

    @Override
    protected void doClose() {
    }

    @Override
    protected boolean doNextPage() {
        return false;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.verifyOpen();
        return this.getRow() > this.columns.size();
    }

    @Override
    public boolean isLast() throws SQLException {
        this.verifyOpen();
        return !this.rowItr.hasNext();
    }

    private void populateCurrentRows() {
        for (TimestreamConnectionProperty property : TimestreamConnectionProperty.values()) {
            this.columns.add(new Row().withData(new Datum[]{TimestreamPropertiesResultSet.createDatum(property.getConnectionProperty()), TimestreamPropertiesResultSet.createDatum(0), TimestreamPropertiesResultSet.createDatum(property.getDefaultValue()), TimestreamPropertiesResultSet.createDatum(property.getDescription())}));
        }
        this.rowItr = this.columns.iterator();
    }
}

