/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.timestream.jdbc;

import com.amazonaws.services.timestreamquery.model.Type;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.timestream.jdbc.Error;
import software.amazon.timestream.jdbc.TimestreamDataType;

public class TimestreamResultSetMetaData
implements ResultSetMetaData {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimestreamResultSetMetaData.class);
    private final List<ColInfo> columnInfo;

    TimestreamResultSetMetaData(List<ColInfo> columnInfo) {
        this.columnInfo = columnInfo;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        this.verifyIndex(column);
        LOGGER.debug("Return null for catalog name since there are no default catalogs.");
        return null;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        this.verifyIndex(column);
        ColInfo col = this.columnInfo.get(column - 1);
        return TimestreamDataType.getJavaClassName(col.type);
    }

    @Override
    public int getColumnCount() {
        return this.columnInfo.size();
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        this.verifyIndex(column);
        switch (this.getColumnType(column)) {
            case 16: {
                return 5;
            }
            case 4: {
                return 11;
            }
            case -5: {
                return 20;
            }
            case 8: {
                return 15;
            }
            case 91: {
                return 10;
            }
            case 92: {
                return 18;
            }
            case 93: {
                return 29;
            }
            case 12: 
            case 2000: 
            case 2002: 
            case 2003: {
                return Integer.MAX_VALUE;
            }
        }
        throw new SQLFeatureNotSupportedException(Error.lookup(Error.UNSUPPORTED_TYPE, this.getColumnClassName(column)));
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.getColumnName(column);
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        this.verifyIndex(column);
        return this.columnInfo.get(column - 1).name;
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        this.verifyIndex(column);
        ColInfo col = this.columnInfo.get(column - 1);
        return TimestreamDataType.getJdbcTypeCode((Type)((ColInfo)col).type).jdbcCode;
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        this.verifyIndex(column);
        return TimestreamDataType.fromType(this.columnInfo.get(column - 1).type).toString();
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        this.verifyIndex(column);
        return TimestreamDataType.fromType(this.columnInfo.get(column - 1).type).getPrecision();
    }

    @Override
    public int getScale(int column) throws SQLException {
        this.verifyIndex(column);
        return 0;
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        this.verifyIndex(column);
        LOGGER.debug("Returning null for schema name since schemas are not supported.");
        return null;
    }

    @Override
    public String getTableName(int column) throws SQLException {
        this.verifyIndex(column);
        LOGGER.debug("Returning null for table name since there are no default tables.");
        return null;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        this.verifyIndex(column);
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        this.verifyIndex(column);
        return true;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        this.verifyIndex(column);
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        this.verifyIndex(column);
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        this.verifyIndex(column);
        return 1;
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        this.verifyIndex(column);
        return true;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        this.verifyIndex(column);
        return true;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        this.verifyIndex(column);
        int type = this.getColumnType(column);
        return type == 4 || type == -5 || type == 8;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return null != iface && iface.isAssignableFrom(this.getClass());
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        this.verifyIndex(column);
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw Error.createSQLException(LOGGER, Error.CANNOT_UNWRAP, iface.toString());
    }

    Type getTimestreamType(int column) throws SQLException {
        this.verifyIndex(column);
        return this.columnInfo.get(column - 1).getType();
    }

    private void verifyIndex(int column) throws SQLException {
        if (1 > column || column > this.columnInfo.size()) {
            throw Error.createSQLException(LOGGER, Error.INVALID_INDEX, column, this.columnInfo.size());
        }
    }

    static class ColInfo {
        private final Type type;
        private final String name;

        ColInfo(Type type, String name) {
            this.type = type;
            this.name = name;
        }

        Type getType() {
            return this.type;
        }
    }
}

