/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.timestream.jdbc;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.http.timers.client.ClientExecutionTimeoutException;
import com.amazonaws.services.timestreamquery.AmazonTimestreamQuery;
import com.amazonaws.services.timestreamquery.AmazonTimestreamQueryClientBuilder;
import com.amazonaws.services.timestreamquery.model.AmazonTimestreamQueryException;
import com.amazonaws.services.timestreamquery.model.CancelQueryRequest;
import com.amazonaws.services.timestreamquery.model.ConflictException;
import com.amazonaws.services.timestreamquery.model.QueryRequest;
import com.amazonaws.services.timestreamquery.model.QueryResult;
import com.google.common.annotations.VisibleForTesting;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLTimeoutException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.timestream.jdbc.Error;
import software.amazon.timestream.jdbc.TimestreamConnection;
import software.amazon.timestream.jdbc.TimestreamResultSet;
import software.amazon.timestream.jdbc.Warning;

public class TimestreamStatement
implements Statement {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimestreamStatement.class);
    private final TimestreamConnection connection;
    private final Map<String, Class<?>> typeMap;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final ClientConfiguration clientConfiguration;
    private final AtomicLong totalExecutionTime = new AtomicLong();
    private int maxFieldSize = 0;
    private long largeMaxRows = 0L;
    private final AtomicReference<String> queryId = new AtomicReference<Object>(null);
    private final AtomicInteger numEmptyPages = new AtomicInteger();
    private final AtomicInteger numPages = new AtomicInteger();
    private boolean shouldCloseOnCompletion = false;
    private SQLWarning warnings;
    private int fetchSize = 0;
    private ResultSet resultSet;
    private AmazonTimestreamQuery queryClient;
    @VisibleForTesting
    final AtomicBoolean canCancel = new AtomicBoolean(false);

    TimestreamStatement(TimestreamConnection connection) throws SQLException {
        this.connection = connection;
        this.warnings = null;
        this.typeMap = connection.getTypeMap();
        this.clientConfiguration = new ClientConfiguration(connection.getQueryClientBuilder().getClientConfiguration());
        this.queryClient = (AmazonTimestreamQuery)((AmazonTimestreamQueryClientBuilder)connection.getQueryClientBuilder().withClientConfiguration(this.clientConfiguration)).build();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void cancel() throws SQLException {
        this.verifyOpen();
        this.doCancel();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.verifyOpen();
        this.warnings = null;
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed.getAndSet(true)) {
            LOGGER.debug("Cancel any running queries.");
            this.doCancel();
            if (this.resultSet != null) {
                LOGGER.debug("Close opened result set.");
                this.resultSet.close();
            }
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.verifyOpen();
        this.shouldCloseOnCompletion = true;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.resultSet = this.executeQuery(sql);
        return true;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(Error.lookup(Error.READ_ONLY, new Object[0]));
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(Error.lookup(Error.READ_ONLY, new Object[0]));
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(Error.lookup(Error.READ_ONLY, new Object[0]));
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(Error.lookup(Error.READ_ONLY, new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized ResultSet executeQuery(String sql) throws SQLException {
        this.verifyOpen();
        if (this.resultSet != null) {
            this.resultSet.close();
        }
        QueryRequest request = new QueryRequest().withQueryString(sql);
        int queryFetchSize = this.getFetchSize();
        if (queryFetchSize != 0) {
            request.withMaxRows(Integer.valueOf(queryFetchSize));
        }
        try {
            QueryResult result;
            try {
                result = this.retrieveResult(request);
                this.queryId.set(result.getQueryId());
                LOGGER.info("Query ID: {}", this.queryId);
                this.canCancel.set(true);
                List rows = result.getRows();
                String nextToken = result.getNextToken();
                while (rows.size() == 0 && nextToken != null) {
                    this.numEmptyPages.incrementAndGet();
                    if (this.isClosed.get()) {
                        this.doCancel();
                        throw Error.createSQLException(LOGGER, Error.STMT_CLOSED_DURING_EXECUTE, this.queryId.get());
                    }
                    try {
                        result = this.retrieveResult(request.withNextToken(nextToken));
                        rows = result.getRows();
                        nextToken = result.getNextToken();
                    }
                    catch (ConflictException conflictException) {
                        throw Error.createSQLException(LOGGER, "HY008", (Exception)((Object)conflictException), Error.QUERY_CANCELED, this.queryId.get());
                    }
                }
            }
            finally {
                this.canCancel.set(false);
            }
            this.resultSet = new TimestreamResultSet(this, sql, result, this.typeMap, this.largeMaxRows, this.maxFieldSize, this.totalExecutionTime.get(), this.numPages.get());
            LOGGER.info("Query ID: {}\nTime to first result: {}ms\nTotal number of pages: {}\nNumber of empty pages: {}\nNumber of rows: {}", new Object[]{this.queryId, this.totalExecutionTime, this.numPages, this.numEmptyPages, result.getRows().size()});
            return this.resultSet;
        }
        catch (AmazonTimestreamQueryException e) {
            throw Error.createSQLException(LOGGER, (Exception)((Object)e), Error.INVALID_QUERY, this.queryId.get(), e.getLocalizedMessage());
        }
        catch (ClientExecutionTimeoutException e) {
            throw new SQLTimeoutException(Error.getErrorMessage(LOGGER, Error.QUERY_TIMED_OUT, this.queryId.get()), e);
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(Error.lookup(Error.READ_ONLY, new Object[0]));
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(Error.lookup(Error.READ_ONLY, new Object[0]));
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(Error.lookup(Error.READ_ONLY, new Object[0]));
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(Error.lookup(Error.READ_ONLY, new Object[0]));
    }

    @Override
    public TimestreamConnection getConnection() throws SQLException {
        this.verifyOpen();
        return this.connection;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.verifyOpen();
        return 1000;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.verifyOpen();
        return this.fetchSize;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(Error.lookup(Error.UNSUPPORTED_GENERATED_KEYS, new Object[0]));
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        this.verifyOpen();
        return this.largeMaxRows;
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        this.verifyOpen();
        return -1L;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.verifyOpen();
        return this.maxFieldSize;
    }

    @Override
    public int getMaxRows() throws SQLException {
        long maxRows = this.getLargeMaxRows();
        if (maxRows > Integer.MAX_VALUE) {
            String warning = Warning.lookup(Warning.MAX_VALUE_TRUNCATED, maxRows, Integer.MAX_VALUE);
            LOGGER.warn(warning);
            this.addWarning(new SQLWarning(warning));
            return Integer.MAX_VALUE;
        }
        return (int)maxRows;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.verifyOpen();
        if (2 != current && this.resultSet != null) {
            this.resultSet.close();
            this.resultSet = null;
        }
        return false;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.verifyOpen();
        return this.clientConfiguration.getClientExecutionTimeout() / 1000;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.verifyOpen();
        return this.resultSet;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.verifyOpen();
        return 1007;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.verifyOpen();
        return 2;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.verifyOpen();
        return 1003;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return (int)this.getLargeUpdateCount();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.verifyOpen();
        return this.warnings;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed.get();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.verifyOpen();
        return this.shouldCloseOnCompletion;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.verifyOpen();
        return false;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return null != iface && iface.isAssignableFrom(this.getClass());
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(Error.lookup(Error.READ_ONLY, new Object[0]));
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.verifyOpen();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.verifyOpen();
        if (direction != 1000) {
            throw Error.createSQLException(LOGGER, Error.UNSUPPORTED_FETCH_DIRECTION, direction);
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.verifyOpen();
        if (rows < 1) {
            throw Error.createSQLException(LOGGER, Error.INVALID_FETCH_SIZE, rows);
        }
        this.fetchSize = Math.min(rows, 1000);
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        this.verifyOpen();
        if (max < 0L) {
            throw Error.createSQLException(LOGGER, Error.INVALID_LARGE_MAX_ROWS_SIZE, max);
        }
        this.largeMaxRows = max;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.verifyOpen();
        if (max < 0) {
            throw Error.createSQLException(LOGGER, Error.INVALID_MAX_FIELD_SIZE, max);
        }
        this.maxFieldSize = max;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.setLargeMaxRows(max);
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.verifyOpen();
        throw new SQLFeatureNotSupportedException(Error.lookup(Error.POOLING_NOT_SUPPORTED, new Object[0]));
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.verifyOpen();
        if (seconds < 0) {
            throw Error.createSQLException(LOGGER, Error.INVALID_TIMEOUT, seconds);
        }
        this.clientConfiguration.setClientExecutionTimeout(seconds * 1000);
        this.queryClient = (AmazonTimestreamQuery)((AmazonTimestreamQueryClientBuilder)this.connection.getQueryClientBuilder().withClientConfiguration(this.clientConfiguration)).build();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw Error.createSQLException(LOGGER, Error.CANNOT_UNWRAP, iface.toString());
    }

    void childClose() throws SQLException {
        if (this.shouldCloseOnCompletion) {
            this.close();
        }
    }

    AmazonTimestreamQuery getClient() {
        return this.queryClient;
    }

    void setResultNoMoreRows() {
        this.queryId.set(null);
    }

    void addWarning(SQLWarning warning) {
        if (this.warnings == null) {
            this.warnings = warning;
        } else {
            this.warnings.setNextWarning(warning);
        }
    }

    private void doCancel() {
        if (this.queryId.get() == null || !this.canCancel.get()) {
            LOGGER.debug("Query is not cancelable.");
            return;
        }
        try {
            LOGGER.debug("Sending a CancelQueryRequest for query ID: {}", this.queryId);
            this.getClient().cancelQuery(new CancelQueryRequest().withQueryId(this.queryId.get()));
            LOGGER.info("Query ID: {} has been canceled.\nTotal execution time until interruption: {}ms\nTotal number of pages: {}\nNumber of empty pages: {}", new Object[]{this.queryId, this.totalExecutionTime, this.numPages, this.numEmptyPages});
        }
        catch (AmazonTimestreamQueryException e) {
            String warning = Warning.lookup(Warning.ERROR_CANCELING_QUERY, this.queryId.get(), e.getLocalizedMessage());
            LOGGER.warn(warning);
            this.addWarning(new SQLWarning(warning, e));
        }
    }

    protected void verifyOpen() throws SQLException {
        if (this.isClosed.get()) {
            throw Error.createSQLException(LOGGER, Error.STMT_CLOSED, new Object[0]);
        }
    }

    private QueryResult retrieveResult(QueryRequest request) {
        long startRetrievalTime = System.nanoTime();
        QueryResult result = this.connection.getQueryClient().query(request);
        long executionTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startRetrievalTime);
        this.totalExecutionTime.addAndGet(executionTime);
        this.numPages.incrementAndGet();
        return result;
    }
}

