/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.samples.connectors.timestream;

import org.apache.flink.shaded.guava30.com.google.common.base.Utf8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.timestreamwrite.model.Dimension;
import software.amazon.awssdk.services.timestreamwrite.model.MeasureValue;
import software.amazon.awssdk.services.timestreamwrite.model.MeasureValueType;
import software.amazon.awssdk.services.timestreamwrite.model.Record;
import software.amazon.awssdk.services.timestreamwrite.model.WriteRecordsRequest;

public class TimestreamModelUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TimestreamModelUtils.class);
    private static final int LONG_BYTE_SIZE = 8;
    private static final int BOOLEAN_BYTE_SIZE = 1;
    private static final int DOUBLE_BYTE_SIZE = 8;
    private static final long DATAPOINT_INITIAL_VERSION = 1L;

    public static int countRecordsInWriteRecordsRequest(WriteRecordsRequest wrr) {
        if (wrr.records() != null) {
            return wrr.records().size();
        }
        LOG.error("Unexpected argument: Request is null for countRecordsInWriteRecordsRequest");
        return 0;
    }

    public static int countMeasuresInWriteRecordsRequest(WriteRecordsRequest wrr) {
        int commonAttributesMeasures = wrr.commonAttributes() == null ? 1 : TimestreamModelUtils.countMeasuresInRecord(wrr.commonAttributes());
        int allRecordMeasures = 0;
        for (Record r : wrr.records()) {
            allRecordMeasures += TimestreamModelUtils.countMeasuresInRecord(r);
        }
        return commonAttributesMeasures * allRecordMeasures;
    }

    private static int countMeasuresInRecord(Record record) {
        if (record != null) {
            if (MeasureValueType.MULTI.equals((Object)record.measureValueType())) {
                return record.measureValues().size();
            }
            return 1;
        }
        LOG.error("Unexpected argument: Record is null for countMeasuresInRecord");
        return 0;
    }

    public static long getRecordSizeInBytes(Record record) {
        long bytesRecord = 0L;
        if (record.measureName() != null) {
            bytesRecord += (long)TimestreamModelUtils.sizeOfString(record.measureName());
        }
        if (record.hasDimensions()) {
            for (Dimension dimension : record.dimensions()) {
                if (dimension.name() != null) {
                    bytesRecord += (long)dimension.name().length();
                }
                if (dimension.value() == null) continue;
                bytesRecord += (long)dimension.value().length();
            }
        }
        if (record.time() != null) {
            bytesRecord += 8L;
        }
        if (record.measureValueType() != null && record.measureValue() != null) {
            bytesRecord += (long)TimestreamModelUtils.getMeasureValueSizeForScalarMeasureType(record.measureValueType(), record.measureValue());
        } else if (record.measureValues() != null && MeasureValueType.MULTI.equals((Object)record.measureValueType())) {
            for (MeasureValue measureValue : record.measureValues()) {
                bytesRecord += (long)TimestreamModelUtils.sizeOfString(measureValue.name());
                bytesRecord += (long)TimestreamModelUtils.getMeasureValueSizeForScalarMeasureType(measureValue.type(), measureValue.value());
            }
        }
        return bytesRecord;
    }

    private static int getMeasureValueSizeForScalarMeasureType(MeasureValueType measureValueType, String measureValue) {
        switch (measureValueType) {
            case DOUBLE: {
                return 8;
            }
            case TIMESTAMP: 
            case BIGINT: {
                return 8;
            }
            case VARCHAR: {
                return TimestreamModelUtils.sizeOfString(measureValue);
            }
            case BOOLEAN: {
                return 1;
            }
        }
        LOG.error("Unsupported Measure type: {}. Calculated record size, and emitted metrics will be incorrect", (Object)measureValueType);
        return 0;
    }

    private static int sizeOfString(String stringToSize) {
        return Utf8.encodedLength((CharSequence)stringToSize);
    }

    public static int countCommonAttributesDimensionsPerWriteRecordRequest(WriteRecordsRequest wrr) {
        if (wrr.commonAttributes() != null && wrr.commonAttributes().dimensions() != null) {
            return wrr.commonAttributes().dimensions().size();
        }
        return 0;
    }
}

