/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.samples.connectors.timestream;

import com.amazonaws.samples.connectors.timestream.BatchConverter;
import com.amazonaws.samples.connectors.timestream.NoOpSimpleVersionedSerializer;
import com.amazonaws.samples.connectors.timestream.TimestreamSinkConfig;
import com.amazonaws.samples.connectors.timestream.TimestreamSinkWriter;
import com.amazonaws.samples.connectors.timestream.metrics.CloudWatchEmittedMetricGroupHelper;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.api.connector.sink2.StatefulSink;
import org.apache.flink.connector.base.sink.AsyncSinkBase;
import org.apache.flink.connector.base.sink.writer.BufferedRequestState;
import org.apache.flink.connector.base.sink.writer.ElementConverter;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.timestreamwrite.model.Record;

@PublicEvolving
public class TimestreamSink<InputT>
extends AsyncSinkBase<InputT, Record> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(TimestreamSink.class);
    protected static final int MAX_BATCH_SIZE_IN_BYTES = Integer.MAX_VALUE;
    protected static final int MAX_RECORD_SIZE_IN_BYTES = Integer.MAX_VALUE;
    private final BatchConverter batchConverter;
    private final TimestreamSinkConfig timestreamSinkConfig;

    public TimestreamSink(ElementConverter<InputT, Record> elementConverter, BatchConverter batchConverter, TimestreamSinkConfig timestreamSinkConfig) {
        super(elementConverter, timestreamSinkConfig.getMaxBatchSize(), timestreamSinkConfig.getMaxInFlightRequests(), timestreamSinkConfig.getMaxBufferedRequests(), Integer.MAX_VALUE, timestreamSinkConfig.getMaxTimeInBufferMS(), Integer.MAX_VALUE);
        this.batchConverter = batchConverter;
        this.timestreamSinkConfig = timestreamSinkConfig;
        LOG.debug("Initialized TimestreamSink class");
    }

    public StatefulSink.StatefulSinkWriter<InputT, BufferedRequestState<Record>> createWriter(Sink.InitContext initContext) throws IOException {
        return this.restoreWriter(initContext, Collections.emptyList());
    }

    public StatefulSink.StatefulSinkWriter<InputT, BufferedRequestState<Record>> restoreWriter(Sink.InitContext context, Collection<BufferedRequestState<Record>> collection) throws IOException {
        LOG.debug("Creating a new TimestreamSinkWriter...");
        CloudWatchEmittedMetricGroupHelper.StaticEmitSinkMetricsToCloudWatch = this.timestreamSinkConfig.isEmitSinkMetricsToCloudWatch();
        return new TimestreamSinkWriter(this.getElementConverter(), this.batchConverter, context, this.timestreamSinkConfig);
    }

    public SimpleVersionedSerializer<BufferedRequestState<Record>> getWriterStateSerializer() {
        return new NoOpSimpleVersionedSerializer();
    }
}

