/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.samples.connectors.timestream;

import com.amazonaws.samples.connectors.timestream.DefaultWriteRequestFailureHandler;
import java.io.Serializable;
import java.time.Duration;
import lombok.Generated;
import lombok.NonNull;
import org.apache.flink.annotation.PublicEvolving;

@PublicEvolving
public class TimestreamSinkConfig
implements Serializable {
    @NonNull
    private final WriteClientConfig writeClientConfig;
    private final int maxBatchSize;
    private final int maxInFlightRequests;
    private final int maxBufferedRequests;
    private final long maxTimeInBufferMS;
    private final boolean emitSinkMetricsToCloudWatch;
    private final FailureHandlerConfig failureHandlerConfig;
    private final CredentialProviderType credentialsProviderType;
    private final CredentialConfig credentialConfig;

    @Generated
    private static int $default$maxBatchSize() {
        return 100;
    }

    @Generated
    private static int $default$maxInFlightRequests() {
        return 100;
    }

    @Generated
    private static int $default$maxBufferedRequests() {
        return 1000;
    }

    @Generated
    private static long $default$maxTimeInBufferMS() {
        return 15000L;
    }

    @Generated
    private static boolean $default$emitSinkMetricsToCloudWatch() {
        return false;
    }

    @Generated
    private static FailureHandlerConfig $default$failureHandlerConfig() {
        return FailureHandlerConfig.builder().build();
    }

    @Generated
    private static CredentialProviderType $default$credentialsProviderType() {
        return CredentialProviderType.AUTO;
    }

    @Generated
    private static CredentialConfig $default$credentialConfig() {
        return null;
    }

    @Generated
    TimestreamSinkConfig(@NonNull WriteClientConfig writeClientConfig, int maxBatchSize, int maxInFlightRequests, int maxBufferedRequests, long maxTimeInBufferMS, boolean emitSinkMetricsToCloudWatch, FailureHandlerConfig failureHandlerConfig, CredentialProviderType credentialsProviderType, CredentialConfig credentialConfig) {
        if (writeClientConfig == null) {
            throw new NullPointerException("writeClientConfig is marked non-null but is null");
        }
        this.writeClientConfig = writeClientConfig;
        this.maxBatchSize = maxBatchSize;
        this.maxInFlightRequests = maxInFlightRequests;
        this.maxBufferedRequests = maxBufferedRequests;
        this.maxTimeInBufferMS = maxTimeInBufferMS;
        this.emitSinkMetricsToCloudWatch = emitSinkMetricsToCloudWatch;
        this.failureHandlerConfig = failureHandlerConfig;
        this.credentialsProviderType = credentialsProviderType;
        this.credentialConfig = credentialConfig;
    }

    @Generated
    public static TimestreamSinkConfigBuilder builder() {
        return new TimestreamSinkConfigBuilder();
    }

    @NonNull
    @Generated
    public WriteClientConfig getWriteClientConfig() {
        return this.writeClientConfig;
    }

    @Generated
    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    @Generated
    public int getMaxInFlightRequests() {
        return this.maxInFlightRequests;
    }

    @Generated
    public int getMaxBufferedRequests() {
        return this.maxBufferedRequests;
    }

    @Generated
    public long getMaxTimeInBufferMS() {
        return this.maxTimeInBufferMS;
    }

    @Generated
    public boolean isEmitSinkMetricsToCloudWatch() {
        return this.emitSinkMetricsToCloudWatch;
    }

    @Generated
    public FailureHandlerConfig getFailureHandlerConfig() {
        return this.failureHandlerConfig;
    }

    @Generated
    public CredentialProviderType getCredentialsProviderType() {
        return this.credentialsProviderType;
    }

    @Generated
    public CredentialConfig getCredentialConfig() {
        return this.credentialConfig;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimestreamSinkConfig)) {
            return false;
        }
        TimestreamSinkConfig other = (TimestreamSinkConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxBatchSize() != other.getMaxBatchSize()) {
            return false;
        }
        if (this.getMaxInFlightRequests() != other.getMaxInFlightRequests()) {
            return false;
        }
        if (this.getMaxBufferedRequests() != other.getMaxBufferedRequests()) {
            return false;
        }
        if (this.getMaxTimeInBufferMS() != other.getMaxTimeInBufferMS()) {
            return false;
        }
        if (this.isEmitSinkMetricsToCloudWatch() != other.isEmitSinkMetricsToCloudWatch()) {
            return false;
        }
        WriteClientConfig this$writeClientConfig = this.getWriteClientConfig();
        WriteClientConfig other$writeClientConfig = other.getWriteClientConfig();
        if (this$writeClientConfig == null ? other$writeClientConfig != null : !((Object)this$writeClientConfig).equals(other$writeClientConfig)) {
            return false;
        }
        FailureHandlerConfig this$failureHandlerConfig = this.getFailureHandlerConfig();
        FailureHandlerConfig other$failureHandlerConfig = other.getFailureHandlerConfig();
        if (this$failureHandlerConfig == null ? other$failureHandlerConfig != null : !((Object)this$failureHandlerConfig).equals(other$failureHandlerConfig)) {
            return false;
        }
        CredentialProviderType this$credentialsProviderType = this.getCredentialsProviderType();
        CredentialProviderType other$credentialsProviderType = other.getCredentialsProviderType();
        if (this$credentialsProviderType == null ? other$credentialsProviderType != null : !((Object)((Object)this$credentialsProviderType)).equals((Object)other$credentialsProviderType)) {
            return false;
        }
        CredentialConfig this$credentialConfig = this.getCredentialConfig();
        CredentialConfig other$credentialConfig = other.getCredentialConfig();
        return !(this$credentialConfig == null ? other$credentialConfig != null : !((Object)this$credentialConfig).equals(other$credentialConfig));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TimestreamSinkConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxBatchSize();
        result = result * 59 + this.getMaxInFlightRequests();
        result = result * 59 + this.getMaxBufferedRequests();
        long $maxTimeInBufferMS = this.getMaxTimeInBufferMS();
        result = result * 59 + (int)($maxTimeInBufferMS >>> 32 ^ $maxTimeInBufferMS);
        result = result * 59 + (this.isEmitSinkMetricsToCloudWatch() ? 79 : 97);
        WriteClientConfig $writeClientConfig = this.getWriteClientConfig();
        result = result * 59 + ($writeClientConfig == null ? 43 : ((Object)$writeClientConfig).hashCode());
        FailureHandlerConfig $failureHandlerConfig = this.getFailureHandlerConfig();
        result = result * 59 + ($failureHandlerConfig == null ? 43 : ((Object)$failureHandlerConfig).hashCode());
        CredentialProviderType $credentialsProviderType = this.getCredentialsProviderType();
        result = result * 59 + ($credentialsProviderType == null ? 43 : ((Object)((Object)$credentialsProviderType)).hashCode());
        CredentialConfig $credentialConfig = this.getCredentialConfig();
        result = result * 59 + ($credentialConfig == null ? 43 : ((Object)$credentialConfig).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TimestreamSinkConfig(writeClientConfig=" + this.getWriteClientConfig() + ", maxBatchSize=" + this.getMaxBatchSize() + ", maxInFlightRequests=" + this.getMaxInFlightRequests() + ", maxBufferedRequests=" + this.getMaxBufferedRequests() + ", maxTimeInBufferMS=" + this.getMaxTimeInBufferMS() + ", emitSinkMetricsToCloudWatch=" + this.isEmitSinkMetricsToCloudWatch() + ", failureHandlerConfig=" + this.getFailureHandlerConfig() + ", credentialsProviderType=" + this.getCredentialsProviderType() + ", credentialConfig=" + this.getCredentialConfig() + ")";
    }

    @Generated
    public static class TimestreamSinkConfigBuilder {
        @Generated
        private WriteClientConfig writeClientConfig;
        @Generated
        private boolean maxBatchSize$set;
        @Generated
        private int maxBatchSize$value;
        @Generated
        private boolean maxInFlightRequests$set;
        @Generated
        private int maxInFlightRequests$value;
        @Generated
        private boolean maxBufferedRequests$set;
        @Generated
        private int maxBufferedRequests$value;
        @Generated
        private boolean maxTimeInBufferMS$set;
        @Generated
        private long maxTimeInBufferMS$value;
        @Generated
        private boolean emitSinkMetricsToCloudWatch$set;
        @Generated
        private boolean emitSinkMetricsToCloudWatch$value;
        @Generated
        private boolean failureHandlerConfig$set;
        @Generated
        private FailureHandlerConfig failureHandlerConfig$value;
        @Generated
        private boolean credentialsProviderType$set;
        @Generated
        private CredentialProviderType credentialsProviderType$value;
        @Generated
        private boolean credentialConfig$set;
        @Generated
        private CredentialConfig credentialConfig$value;

        @Generated
        TimestreamSinkConfigBuilder() {
        }

        @Generated
        public TimestreamSinkConfigBuilder writeClientConfig(@NonNull WriteClientConfig writeClientConfig) {
            if (writeClientConfig == null) {
                throw new NullPointerException("writeClientConfig is marked non-null but is null");
            }
            this.writeClientConfig = writeClientConfig;
            return this;
        }

        @Generated
        public TimestreamSinkConfigBuilder maxBatchSize(int maxBatchSize) {
            this.maxBatchSize$value = maxBatchSize;
            this.maxBatchSize$set = true;
            return this;
        }

        @Generated
        public TimestreamSinkConfigBuilder maxInFlightRequests(int maxInFlightRequests) {
            this.maxInFlightRequests$value = maxInFlightRequests;
            this.maxInFlightRequests$set = true;
            return this;
        }

        @Generated
        public TimestreamSinkConfigBuilder maxBufferedRequests(int maxBufferedRequests) {
            this.maxBufferedRequests$value = maxBufferedRequests;
            this.maxBufferedRequests$set = true;
            return this;
        }

        @Generated
        public TimestreamSinkConfigBuilder maxTimeInBufferMS(long maxTimeInBufferMS) {
            this.maxTimeInBufferMS$value = maxTimeInBufferMS;
            this.maxTimeInBufferMS$set = true;
            return this;
        }

        @Generated
        public TimestreamSinkConfigBuilder emitSinkMetricsToCloudWatch(boolean emitSinkMetricsToCloudWatch) {
            this.emitSinkMetricsToCloudWatch$value = emitSinkMetricsToCloudWatch;
            this.emitSinkMetricsToCloudWatch$set = true;
            return this;
        }

        @Generated
        public TimestreamSinkConfigBuilder failureHandlerConfig(FailureHandlerConfig failureHandlerConfig) {
            this.failureHandlerConfig$value = failureHandlerConfig;
            this.failureHandlerConfig$set = true;
            return this;
        }

        @Generated
        public TimestreamSinkConfigBuilder credentialsProviderType(CredentialProviderType credentialsProviderType) {
            this.credentialsProviderType$value = credentialsProviderType;
            this.credentialsProviderType$set = true;
            return this;
        }

        @Generated
        public TimestreamSinkConfigBuilder credentialConfig(CredentialConfig credentialConfig) {
            this.credentialConfig$value = credentialConfig;
            this.credentialConfig$set = true;
            return this;
        }

        @Generated
        public TimestreamSinkConfig build() {
            int maxBatchSize$value = this.maxBatchSize$value;
            if (!this.maxBatchSize$set) {
                maxBatchSize$value = TimestreamSinkConfig.$default$maxBatchSize();
            }
            int maxInFlightRequests$value = this.maxInFlightRequests$value;
            if (!this.maxInFlightRequests$set) {
                maxInFlightRequests$value = TimestreamSinkConfig.$default$maxInFlightRequests();
            }
            int maxBufferedRequests$value = this.maxBufferedRequests$value;
            if (!this.maxBufferedRequests$set) {
                maxBufferedRequests$value = TimestreamSinkConfig.$default$maxBufferedRequests();
            }
            long maxTimeInBufferMS$value = this.maxTimeInBufferMS$value;
            if (!this.maxTimeInBufferMS$set) {
                maxTimeInBufferMS$value = TimestreamSinkConfig.$default$maxTimeInBufferMS();
            }
            boolean emitSinkMetricsToCloudWatch$value = this.emitSinkMetricsToCloudWatch$value;
            if (!this.emitSinkMetricsToCloudWatch$set) {
                emitSinkMetricsToCloudWatch$value = TimestreamSinkConfig.$default$emitSinkMetricsToCloudWatch();
            }
            FailureHandlerConfig failureHandlerConfig$value = this.failureHandlerConfig$value;
            if (!this.failureHandlerConfig$set) {
                failureHandlerConfig$value = TimestreamSinkConfig.$default$failureHandlerConfig();
            }
            CredentialProviderType credentialsProviderType$value = this.credentialsProviderType$value;
            if (!this.credentialsProviderType$set) {
                credentialsProviderType$value = TimestreamSinkConfig.$default$credentialsProviderType();
            }
            CredentialConfig credentialConfig$value = this.credentialConfig$value;
            if (!this.credentialConfig$set) {
                credentialConfig$value = TimestreamSinkConfig.$default$credentialConfig();
            }
            return new TimestreamSinkConfig(this.writeClientConfig, maxBatchSize$value, maxInFlightRequests$value, maxBufferedRequests$value, maxTimeInBufferMS$value, emitSinkMetricsToCloudWatch$value, failureHandlerConfig$value, credentialsProviderType$value, credentialConfig$value);
        }

        @Generated
        public String toString() {
            return "TimestreamSinkConfig.TimestreamSinkConfigBuilder(writeClientConfig=" + this.writeClientConfig + ", maxBatchSize$value=" + this.maxBatchSize$value + ", maxInFlightRequests$value=" + this.maxInFlightRequests$value + ", maxBufferedRequests$value=" + this.maxBufferedRequests$value + ", maxTimeInBufferMS$value=" + this.maxTimeInBufferMS$value + ", emitSinkMetricsToCloudWatch$value=" + this.emitSinkMetricsToCloudWatch$value + ", failureHandlerConfig$value=" + this.failureHandlerConfig$value + ", credentialsProviderType$value=" + this.credentialsProviderType$value + ", credentialConfig$value=" + this.credentialConfig$value + ")";
        }
    }

    public static enum CredentialProviderType {
        AUTO,
        ENV_VAR,
        SYS_PROP,
        PROFILE;

    }

    public static class WriteClientConfig
    implements Serializable {
        private final String region;
        private final int maxConcurrency;
        private final Duration requestTimeout;
        private final int maxErrorRetry;
        private final String endpointOverride;

        @Generated
        private static int $default$maxConcurrency() {
            return 5000;
        }

        @Generated
        private static Duration $default$requestTimeout() {
            return Duration.ofSeconds(20L);
        }

        @Generated
        private static int $default$maxErrorRetry() {
            return 10;
        }

        @Generated
        private static String $default$endpointOverride() {
            return null;
        }

        @Generated
        WriteClientConfig(String region, int maxConcurrency, Duration requestTimeout, int maxErrorRetry, String endpointOverride) {
            this.region = region;
            this.maxConcurrency = maxConcurrency;
            this.requestTimeout = requestTimeout;
            this.maxErrorRetry = maxErrorRetry;
            this.endpointOverride = endpointOverride;
        }

        @Generated
        public static WriteClientConfigBuilder builder() {
            return new WriteClientConfigBuilder();
        }

        @Generated
        public String getRegion() {
            return this.region;
        }

        @Generated
        public int getMaxConcurrency() {
            return this.maxConcurrency;
        }

        @Generated
        public Duration getRequestTimeout() {
            return this.requestTimeout;
        }

        @Generated
        public int getMaxErrorRetry() {
            return this.maxErrorRetry;
        }

        @Generated
        public String getEndpointOverride() {
            return this.endpointOverride;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WriteClientConfig)) {
                return false;
            }
            WriteClientConfig other = (WriteClientConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getMaxConcurrency() != other.getMaxConcurrency()) {
                return false;
            }
            if (this.getMaxErrorRetry() != other.getMaxErrorRetry()) {
                return false;
            }
            String this$region = this.getRegion();
            String other$region = other.getRegion();
            if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
                return false;
            }
            Duration this$requestTimeout = this.getRequestTimeout();
            Duration other$requestTimeout = other.getRequestTimeout();
            if (this$requestTimeout == null ? other$requestTimeout != null : !((Object)this$requestTimeout).equals(other$requestTimeout)) {
                return false;
            }
            String this$endpointOverride = this.getEndpointOverride();
            String other$endpointOverride = other.getEndpointOverride();
            return !(this$endpointOverride == null ? other$endpointOverride != null : !this$endpointOverride.equals(other$endpointOverride));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof WriteClientConfig;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMaxConcurrency();
            result = result * 59 + this.getMaxErrorRetry();
            String $region = this.getRegion();
            result = result * 59 + ($region == null ? 43 : $region.hashCode());
            Duration $requestTimeout = this.getRequestTimeout();
            result = result * 59 + ($requestTimeout == null ? 43 : ((Object)$requestTimeout).hashCode());
            String $endpointOverride = this.getEndpointOverride();
            result = result * 59 + ($endpointOverride == null ? 43 : $endpointOverride.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TimestreamSinkConfig.WriteClientConfig(region=" + this.getRegion() + ", maxConcurrency=" + this.getMaxConcurrency() + ", requestTimeout=" + this.getRequestTimeout() + ", maxErrorRetry=" + this.getMaxErrorRetry() + ", endpointOverride=" + this.getEndpointOverride() + ")";
        }

        @Generated
        public static class WriteClientConfigBuilder {
            @Generated
            private String region;
            @Generated
            private boolean maxConcurrency$set;
            @Generated
            private int maxConcurrency$value;
            @Generated
            private boolean requestTimeout$set;
            @Generated
            private Duration requestTimeout$value;
            @Generated
            private boolean maxErrorRetry$set;
            @Generated
            private int maxErrorRetry$value;
            @Generated
            private boolean endpointOverride$set;
            @Generated
            private String endpointOverride$value;

            @Generated
            WriteClientConfigBuilder() {
            }

            @Generated
            public WriteClientConfigBuilder region(String region) {
                this.region = region;
                return this;
            }

            @Generated
            public WriteClientConfigBuilder maxConcurrency(int maxConcurrency) {
                this.maxConcurrency$value = maxConcurrency;
                this.maxConcurrency$set = true;
                return this;
            }

            @Generated
            public WriteClientConfigBuilder requestTimeout(Duration requestTimeout) {
                this.requestTimeout$value = requestTimeout;
                this.requestTimeout$set = true;
                return this;
            }

            @Generated
            public WriteClientConfigBuilder maxErrorRetry(int maxErrorRetry) {
                this.maxErrorRetry$value = maxErrorRetry;
                this.maxErrorRetry$set = true;
                return this;
            }

            @Generated
            public WriteClientConfigBuilder endpointOverride(String endpointOverride) {
                this.endpointOverride$value = endpointOverride;
                this.endpointOverride$set = true;
                return this;
            }

            @Generated
            public WriteClientConfig build() {
                int maxConcurrency$value = this.maxConcurrency$value;
                if (!this.maxConcurrency$set) {
                    maxConcurrency$value = WriteClientConfig.$default$maxConcurrency();
                }
                Duration requestTimeout$value = this.requestTimeout$value;
                if (!this.requestTimeout$set) {
                    requestTimeout$value = WriteClientConfig.$default$requestTimeout();
                }
                int maxErrorRetry$value = this.maxErrorRetry$value;
                if (!this.maxErrorRetry$set) {
                    maxErrorRetry$value = WriteClientConfig.$default$maxErrorRetry();
                }
                String endpointOverride$value = this.endpointOverride$value;
                if (!this.endpointOverride$set) {
                    endpointOverride$value = WriteClientConfig.$default$endpointOverride();
                }
                return new WriteClientConfig(this.region, maxConcurrency$value, requestTimeout$value, maxErrorRetry$value, endpointOverride$value);
            }

            @Generated
            public String toString() {
                return "TimestreamSinkConfig.WriteClientConfig.WriteClientConfigBuilder(region=" + this.region + ", maxConcurrency$value=" + this.maxConcurrency$value + ", requestTimeout$value=" + this.requestTimeout$value + ", maxErrorRetry$value=" + this.maxErrorRetry$value + ", endpointOverride$value=" + this.endpointOverride$value + ")";
            }
        }
    }

    public static class CredentialConfig
    implements Serializable {
        private final String profileName;
        private final String profileConfigPath;

        @Generated
        private static String $default$profileName() {
            return null;
        }

        @Generated
        private static String $default$profileConfigPath() {
            return null;
        }

        @Generated
        CredentialConfig(String profileName, String profileConfigPath) {
            this.profileName = profileName;
            this.profileConfigPath = profileConfigPath;
        }

        @Generated
        public static CredentialConfigBuilder builder() {
            return new CredentialConfigBuilder();
        }

        @Generated
        public String getProfileName() {
            return this.profileName;
        }

        @Generated
        public String getProfileConfigPath() {
            return this.profileConfigPath;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CredentialConfig)) {
                return false;
            }
            CredentialConfig other = (CredentialConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$profileName = this.getProfileName();
            String other$profileName = other.getProfileName();
            if (this$profileName == null ? other$profileName != null : !this$profileName.equals(other$profileName)) {
                return false;
            }
            String this$profileConfigPath = this.getProfileConfigPath();
            String other$profileConfigPath = other.getProfileConfigPath();
            return !(this$profileConfigPath == null ? other$profileConfigPath != null : !this$profileConfigPath.equals(other$profileConfigPath));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CredentialConfig;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $profileName = this.getProfileName();
            result = result * 59 + ($profileName == null ? 43 : $profileName.hashCode());
            String $profileConfigPath = this.getProfileConfigPath();
            result = result * 59 + ($profileConfigPath == null ? 43 : $profileConfigPath.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TimestreamSinkConfig.CredentialConfig(profileName=" + this.getProfileName() + ", profileConfigPath=" + this.getProfileConfigPath() + ")";
        }

        @Generated
        public static class CredentialConfigBuilder {
            @Generated
            private boolean profileName$set;
            @Generated
            private String profileName$value;
            @Generated
            private boolean profileConfigPath$set;
            @Generated
            private String profileConfigPath$value;

            @Generated
            CredentialConfigBuilder() {
            }

            @Generated
            public CredentialConfigBuilder profileName(String profileName) {
                this.profileName$value = profileName;
                this.profileName$set = true;
                return this;
            }

            @Generated
            public CredentialConfigBuilder profileConfigPath(String profileConfigPath) {
                this.profileConfigPath$value = profileConfigPath;
                this.profileConfigPath$set = true;
                return this;
            }

            @Generated
            public CredentialConfig build() {
                String profileName$value = this.profileName$value;
                if (!this.profileName$set) {
                    profileName$value = CredentialConfig.$default$profileName();
                }
                String profileConfigPath$value = this.profileConfigPath$value;
                if (!this.profileConfigPath$set) {
                    profileConfigPath$value = CredentialConfig.$default$profileConfigPath();
                }
                return new CredentialConfig(profileName$value, profileConfigPath$value);
            }

            @Generated
            public String toString() {
                return "TimestreamSinkConfig.CredentialConfig.CredentialConfigBuilder(profileName$value=" + this.profileName$value + ", profileConfigPath$value=" + this.profileConfigPath$value + ")";
            }
        }
    }

    public static class FailureHandlerConfig
    implements Serializable {
        private final String failureHandlerClass;
        private final boolean printFailedRequests;
        private final boolean failProcessingOnRejectedRecordsException;
        private final boolean failProcessingOnValidationException;
        private final boolean failProcessingOnErrorDefault;

        @Generated
        private static String $default$failureHandlerClass() {
            return DefaultWriteRequestFailureHandler.class.getCanonicalName();
        }

        @Generated
        private static boolean $default$printFailedRequests() {
            return false;
        }

        @Generated
        private static boolean $default$failProcessingOnRejectedRecordsException() {
            return true;
        }

        @Generated
        private static boolean $default$failProcessingOnValidationException() {
            return true;
        }

        @Generated
        private static boolean $default$failProcessingOnErrorDefault() {
            return true;
        }

        @Generated
        FailureHandlerConfig(String failureHandlerClass, boolean printFailedRequests, boolean failProcessingOnRejectedRecordsException, boolean failProcessingOnValidationException, boolean failProcessingOnErrorDefault) {
            this.failureHandlerClass = failureHandlerClass;
            this.printFailedRequests = printFailedRequests;
            this.failProcessingOnRejectedRecordsException = failProcessingOnRejectedRecordsException;
            this.failProcessingOnValidationException = failProcessingOnValidationException;
            this.failProcessingOnErrorDefault = failProcessingOnErrorDefault;
        }

        @Generated
        public static FailureHandlerConfigBuilder builder() {
            return new FailureHandlerConfigBuilder();
        }

        @Generated
        public String getFailureHandlerClass() {
            return this.failureHandlerClass;
        }

        @Generated
        public boolean isPrintFailedRequests() {
            return this.printFailedRequests;
        }

        @Generated
        public boolean isFailProcessingOnRejectedRecordsException() {
            return this.failProcessingOnRejectedRecordsException;
        }

        @Generated
        public boolean isFailProcessingOnValidationException() {
            return this.failProcessingOnValidationException;
        }

        @Generated
        public boolean isFailProcessingOnErrorDefault() {
            return this.failProcessingOnErrorDefault;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FailureHandlerConfig)) {
                return false;
            }
            FailureHandlerConfig other = (FailureHandlerConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isPrintFailedRequests() != other.isPrintFailedRequests()) {
                return false;
            }
            if (this.isFailProcessingOnRejectedRecordsException() != other.isFailProcessingOnRejectedRecordsException()) {
                return false;
            }
            if (this.isFailProcessingOnValidationException() != other.isFailProcessingOnValidationException()) {
                return false;
            }
            if (this.isFailProcessingOnErrorDefault() != other.isFailProcessingOnErrorDefault()) {
                return false;
            }
            String this$failureHandlerClass = this.getFailureHandlerClass();
            String other$failureHandlerClass = other.getFailureHandlerClass();
            return !(this$failureHandlerClass == null ? other$failureHandlerClass != null : !this$failureHandlerClass.equals(other$failureHandlerClass));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FailureHandlerConfig;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isPrintFailedRequests() ? 79 : 97);
            result = result * 59 + (this.isFailProcessingOnRejectedRecordsException() ? 79 : 97);
            result = result * 59 + (this.isFailProcessingOnValidationException() ? 79 : 97);
            result = result * 59 + (this.isFailProcessingOnErrorDefault() ? 79 : 97);
            String $failureHandlerClass = this.getFailureHandlerClass();
            result = result * 59 + ($failureHandlerClass == null ? 43 : $failureHandlerClass.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TimestreamSinkConfig.FailureHandlerConfig(failureHandlerClass=" + this.getFailureHandlerClass() + ", printFailedRequests=" + this.isPrintFailedRequests() + ", failProcessingOnRejectedRecordsException=" + this.isFailProcessingOnRejectedRecordsException() + ", failProcessingOnValidationException=" + this.isFailProcessingOnValidationException() + ", failProcessingOnErrorDefault=" + this.isFailProcessingOnErrorDefault() + ")";
        }

        @Generated
        public static class FailureHandlerConfigBuilder {
            @Generated
            private boolean failureHandlerClass$set;
            @Generated
            private String failureHandlerClass$value;
            @Generated
            private boolean printFailedRequests$set;
            @Generated
            private boolean printFailedRequests$value;
            @Generated
            private boolean failProcessingOnRejectedRecordsException$set;
            @Generated
            private boolean failProcessingOnRejectedRecordsException$value;
            @Generated
            private boolean failProcessingOnValidationException$set;
            @Generated
            private boolean failProcessingOnValidationException$value;
            @Generated
            private boolean failProcessingOnErrorDefault$set;
            @Generated
            private boolean failProcessingOnErrorDefault$value;

            @Generated
            FailureHandlerConfigBuilder() {
            }

            @Generated
            public FailureHandlerConfigBuilder failureHandlerClass(String failureHandlerClass) {
                this.failureHandlerClass$value = failureHandlerClass;
                this.failureHandlerClass$set = true;
                return this;
            }

            @Generated
            public FailureHandlerConfigBuilder printFailedRequests(boolean printFailedRequests) {
                this.printFailedRequests$value = printFailedRequests;
                this.printFailedRequests$set = true;
                return this;
            }

            @Generated
            public FailureHandlerConfigBuilder failProcessingOnRejectedRecordsException(boolean failProcessingOnRejectedRecordsException) {
                this.failProcessingOnRejectedRecordsException$value = failProcessingOnRejectedRecordsException;
                this.failProcessingOnRejectedRecordsException$set = true;
                return this;
            }

            @Generated
            public FailureHandlerConfigBuilder failProcessingOnValidationException(boolean failProcessingOnValidationException) {
                this.failProcessingOnValidationException$value = failProcessingOnValidationException;
                this.failProcessingOnValidationException$set = true;
                return this;
            }

            @Generated
            public FailureHandlerConfigBuilder failProcessingOnErrorDefault(boolean failProcessingOnErrorDefault) {
                this.failProcessingOnErrorDefault$value = failProcessingOnErrorDefault;
                this.failProcessingOnErrorDefault$set = true;
                return this;
            }

            @Generated
            public FailureHandlerConfig build() {
                String failureHandlerClass$value = this.failureHandlerClass$value;
                if (!this.failureHandlerClass$set) {
                    failureHandlerClass$value = FailureHandlerConfig.$default$failureHandlerClass();
                }
                boolean printFailedRequests$value = this.printFailedRequests$value;
                if (!this.printFailedRequests$set) {
                    printFailedRequests$value = FailureHandlerConfig.$default$printFailedRequests();
                }
                boolean failProcessingOnRejectedRecordsException$value = this.failProcessingOnRejectedRecordsException$value;
                if (!this.failProcessingOnRejectedRecordsException$set) {
                    failProcessingOnRejectedRecordsException$value = FailureHandlerConfig.$default$failProcessingOnRejectedRecordsException();
                }
                boolean failProcessingOnValidationException$value = this.failProcessingOnValidationException$value;
                if (!this.failProcessingOnValidationException$set) {
                    failProcessingOnValidationException$value = FailureHandlerConfig.$default$failProcessingOnValidationException();
                }
                boolean failProcessingOnErrorDefault$value = this.failProcessingOnErrorDefault$value;
                if (!this.failProcessingOnErrorDefault$set) {
                    failProcessingOnErrorDefault$value = FailureHandlerConfig.$default$failProcessingOnErrorDefault();
                }
                return new FailureHandlerConfig(failureHandlerClass$value, printFailedRequests$value, failProcessingOnRejectedRecordsException$value, failProcessingOnValidationException$value, failProcessingOnErrorDefault$value);
            }

            @Generated
            public String toString() {
                return "TimestreamSinkConfig.FailureHandlerConfig.FailureHandlerConfigBuilder(failureHandlerClass$value=" + this.failureHandlerClass$value + ", printFailedRequests$value=" + this.printFailedRequests$value + ", failProcessingOnRejectedRecordsException$value=" + this.failProcessingOnRejectedRecordsException$value + ", failProcessingOnValidationException$value=" + this.failProcessingOnValidationException$value + ", failProcessingOnErrorDefault$value=" + this.failProcessingOnErrorDefault$value + ")";
            }
        }
    }
}

