/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.samples.connectors.timestream.metrics;

import java.util.HashMap;
import lombok.Generated;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.MetricGroup;
import software.amazon.awssdk.services.timestreamwrite.model.AccessDeniedException;
import software.amazon.awssdk.services.timestreamwrite.model.ConflictException;
import software.amazon.awssdk.services.timestreamwrite.model.InternalServerException;
import software.amazon.awssdk.services.timestreamwrite.model.InvalidEndpointException;
import software.amazon.awssdk.services.timestreamwrite.model.RejectedRecordsException;
import software.amazon.awssdk.services.timestreamwrite.model.ResourceNotFoundException;
import software.amazon.awssdk.services.timestreamwrite.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.timestreamwrite.model.ThrottlingException;
import software.amazon.awssdk.services.timestreamwrite.model.ValidationException;

@Internal
public class TimestreamSinkMetricGroup {
    private static final String UNKNOWN_EXCEPTION_NAME = "UNKNOWNEXCEPTION";
    private static final String EXCEPTION_COUNTER_PATTERN = "numOf%s";
    private final MetricGroup sinkGroup;
    @VisibleForTesting
    static final String SINK_METRIC_GROUP = "timestreamSink";
    private final Counter numRecordsSuccess;
    private final Counter numWritesSuccess;
    private final Counter numRecordsDrop;
    private final Counter numWritesNonSDKRetries;
    private int numOfRecordsPerWriteRecordRequest;
    private int numOfMeasuresPerWriteRecordRequest;
    private int numOfCommonAttributesDimensionsPerWriteRecordRequest;
    final HashMap<String, Counter> exceptionTypeToCounter;

    public TimestreamSinkMetricGroup(MetricGroup metricGroup) {
        this.sinkGroup = metricGroup.addGroup(SINK_METRIC_GROUP);
        this.numRecordsSuccess = this.sinkGroup.counter("numRecordsSuccess");
        this.numWritesSuccess = this.sinkGroup.counter("numWritesSuccess");
        this.numWritesNonSDKRetries = this.sinkGroup.counter("numWritesNonSDKRetries");
        this.numRecordsDrop = this.sinkGroup.counter("numRecordsDrop");
        this.exceptionTypeToCounter = new HashMap();
        this.addCounter(this.exceptionTypeToCounter, AccessDeniedException.class, this.sinkGroup);
        this.addCounter(this.exceptionTypeToCounter, ConflictException.class, this.sinkGroup);
        this.addCounter(this.exceptionTypeToCounter, InternalServerException.class, this.sinkGroup);
        this.addCounter(this.exceptionTypeToCounter, InvalidEndpointException.class, this.sinkGroup);
        this.addCounter(this.exceptionTypeToCounter, RejectedRecordsException.class, this.sinkGroup);
        this.addCounter(this.exceptionTypeToCounter, ResourceNotFoundException.class, this.sinkGroup);
        this.addCounter(this.exceptionTypeToCounter, ServiceQuotaExceededException.class, this.sinkGroup);
        this.addCounter(this.exceptionTypeToCounter, ThrottlingException.class, this.sinkGroup);
        this.addCounter(this.exceptionTypeToCounter, ValidationException.class, this.sinkGroup);
        this.exceptionTypeToCounter.put(UNKNOWN_EXCEPTION_NAME, this.sinkGroup.counter(String.format(EXCEPTION_COUNTER_PATTERN, UNKNOWN_EXCEPTION_NAME)));
        this.sinkGroup.gauge("numOfRecordsPerWriteRecordRequest", () -> this.numOfRecordsPerWriteRecordRequest);
        this.sinkGroup.gauge("numOfMeasuresPerWriteRecordRequest", () -> this.numOfMeasuresPerWriteRecordRequest);
        this.sinkGroup.gauge("numOfCommonAttributesDimensionsPerWriteRecordRequest", () -> this.numOfCommonAttributesDimensionsPerWriteRecordRequest);
    }

    private void addCounter(HashMap<String, Counter> exceptionTypeToCounter, Class<?> exceptionClass, MetricGroup sinkGroup) {
        String exceptionName = exceptionClass.getSimpleName();
        exceptionTypeToCounter.put(exceptionName, sinkGroup.counter(String.format(EXCEPTION_COUNTER_PATTERN, exceptionName)));
    }

    public void incrementExceptionCounter(String simpleExceptionName) {
        if (this.exceptionTypeToCounter.containsKey(simpleExceptionName)) {
            this.exceptionTypeToCounter.get(simpleExceptionName).inc();
        } else {
            this.exceptionTypeToCounter.get(UNKNOWN_EXCEPTION_NAME).inc();
        }
    }

    @Generated
    public Counter getNumRecordsSuccess() {
        return this.numRecordsSuccess;
    }

    @Generated
    public Counter getNumWritesSuccess() {
        return this.numWritesSuccess;
    }

    @Generated
    public Counter getNumRecordsDrop() {
        return this.numRecordsDrop;
    }

    @Generated
    public Counter getNumWritesNonSDKRetries() {
        return this.numWritesNonSDKRetries;
    }

    @Generated
    public void setNumOfRecordsPerWriteRecordRequest(int numOfRecordsPerWriteRecordRequest) {
        this.numOfRecordsPerWriteRecordRequest = numOfRecordsPerWriteRecordRequest;
    }

    @Generated
    public void setNumOfMeasuresPerWriteRecordRequest(int numOfMeasuresPerWriteRecordRequest) {
        this.numOfMeasuresPerWriteRecordRequest = numOfMeasuresPerWriteRecordRequest;
    }

    @Generated
    public void setNumOfCommonAttributesDimensionsPerWriteRecordRequest(int numOfCommonAttributesDimensionsPerWriteRecordRequest) {
        this.numOfCommonAttributesDimensionsPerWriteRecordRequest = numOfCommonAttributesDimensionsPerWriteRecordRequest;
    }
}

