package software.aws.awsprototypingsdk.cdkgraph;

/**
 * (experimental) Edge class defines a link (relationship) between nodes, as in standard <a href="https://en.wikipedia.org/wiki/Graph_theory">graph theory</a>.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.82.0 (build 2d2ddd7)", date = "2023-08-24T23:07:44.326Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.aws.awsprototypingsdk.cdkgraph.$Module.class, fqn = "@aws-prototyping-sdk/cdk-graph.Edge")
public class Edge extends software.aws.awsprototypingsdk.cdkgraph.BaseEntity implements software.aws.awsprototypingsdk.cdkgraph.ISerializableEdge {

    protected Edge(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Edge(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Edge(final @org.jetbrains.annotations.NotNull software.aws.awsprototypingsdk.cdkgraph.IEdgeProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Find all matching edges based on predicate within an EdgeChain.
     * <p>
     * @param chain This parameter is required.
     * @param predicate This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull java.util.List<software.aws.awsprototypingsdk.cdkgraph.Edge> findAllInChain(final @org.jetbrains.annotations.NotNull java.util.List<? extends java.lang.Object> chain, final @org.jetbrains.annotations.NotNull software.aws.awsprototypingsdk.cdkgraph.IEdgePredicate predicate) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.aws.awsprototypingsdk.cdkgraph.Edge.class, "findAllInChain", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.aws.awsprototypingsdk.cdkgraph.Edge.class)), new Object[] { java.util.Objects.requireNonNull(chain, "chain is required"), java.util.Objects.requireNonNull(predicate, "predicate is required") }));
    }

    /**
     * (experimental) Find first edge matching predicate within an EdgeChain.
     * <p>
     * @param chain This parameter is required.
     * @param predicate This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.Nullable software.aws.awsprototypingsdk.cdkgraph.Edge findInChain(final @org.jetbrains.annotations.NotNull java.util.List<? extends java.lang.Object> chain, final @org.jetbrains.annotations.NotNull software.aws.awsprototypingsdk.cdkgraph.IEdgePredicate predicate) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.aws.awsprototypingsdk.cdkgraph.Edge.class, "findInChain", software.amazon.jsii.NativeType.forClass(software.aws.awsprototypingsdk.cdkgraph.Edge.class), new Object[] { java.util.Objects.requireNonNull(chain, "chain is required"), java.util.Objects.requireNonNull(predicate, "predicate is required") });
    }

    /**
     * (experimental) Indicates if this edge is equivalent to another edge.
     * <p>
     * Edges are considered equivalent if they share same type, source, and target.
     * <p>
     * @param edge This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean isEquivalent(final @org.jetbrains.annotations.NotNull software.aws.awsprototypingsdk.cdkgraph.Edge edge) {
        return software.amazon.jsii.Kernel.call(this, "isEquivalent", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { java.util.Objects.requireNonNull(edge, "edge is required") });
    }

    /**
     * (experimental) Merge an equivalent edge's data into this edge and destroy the other edge.
     * <p>
     * Used during filtering operations to consolidate equivalent edges.
     * <p>
     * @param edge <ul><li>The edge to consume.</li></ul> This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void mutateConsume(final @org.jetbrains.annotations.NotNull software.aws.awsprototypingsdk.cdkgraph.Edge edge) {
        software.amazon.jsii.Kernel.call(this, "mutateConsume", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(edge, "edge is required") });
    }

    /**
     * (experimental) Destroy the edge.
     * <p>
     * Remove all references and remove from store.
     * <p>
     * @param _strict
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void mutateDestroy(final @org.jetbrains.annotations.Nullable java.lang.Boolean _strict) {
        software.amazon.jsii.Kernel.call(this, "mutateDestroy", software.amazon.jsii.NativeType.VOID, new Object[] { _strict });
    }

    /**
     * (experimental) Destroy the edge.
     * <p>
     * Remove all references and remove from store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void mutateDestroy() {
        software.amazon.jsii.Kernel.call(this, "mutateDestroy", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * (experimental) Change the edge <strong>direction</strong>.
     * <p>
     * @param direction This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void mutateDirection(final @org.jetbrains.annotations.NotNull software.aws.awsprototypingsdk.cdkgraph.EdgeDirectionEnum direction) {
        software.amazon.jsii.Kernel.call(this, "mutateDirection", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(direction, "direction is required") });
    }

    /**
     * (experimental) Change the edge <strong>source</strong>.
     * <p>
     * @param node This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void mutateSource(final @org.jetbrains.annotations.NotNull software.aws.awsprototypingsdk.cdkgraph.Node node) {
        software.amazon.jsii.Kernel.call(this, "mutateSource", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(node, "node is required") });
    }

    /**
     * (experimental) Change the edge <strong>target</strong>.
     * <p>
     * @param node This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void mutateTarget(final @org.jetbrains.annotations.NotNull software.aws.awsprototypingsdk.cdkgraph.Node node) {
        software.amazon.jsii.Kernel.call(this, "mutateTarget", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(node, "node is required") });
    }

    /**
     * (experimental) Get string representation of this edge.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Indicates if edge allows destructive mutations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getAllowDestructiveMutations() {
        return software.amazon.jsii.Kernel.get(this, "allowDestructiveMutations", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * (experimental) Indicates the direction in which the edge is directed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.aws.awsprototypingsdk.cdkgraph.EdgeDirectionEnum getDirection() {
        return software.amazon.jsii.Kernel.get(this, "direction", software.amazon.jsii.NativeType.forClass(software.aws.awsprototypingsdk.cdkgraph.EdgeDirectionEnum.class));
    }

    /**
     * (experimental) Type of edge.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.aws.awsprototypingsdk.cdkgraph.EdgeTypeEnum getEdgeType() {
        return software.amazon.jsii.Kernel.get(this, "edgeType", software.amazon.jsii.NativeType.forClass(software.aws.awsprototypingsdk.cdkgraph.EdgeTypeEnum.class));
    }

    /**
     * (experimental) Indicates if the Edge's <strong>source</strong> and <strong>target</strong> are the same, or were the same when it was created (prior to mutations).
     * <p>
     * To check whether it was originally closed, use <code>hasFlag(FlagEnum.CLOSED_EDGE)</code> instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getIsClosed() {
        return software.amazon.jsii.Kernel.get(this, "isClosed", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * (experimental) Indicates if <strong>source</strong> and <strong>target</strong> nodes reside in different <em>root</em> stacks.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getIsCrossStack() {
        return software.amazon.jsii.Kernel.get(this, "isCrossStack", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * (experimental) Indicates if edge is extraneous which is determined by explicitly having <em>EXTRANEOUS</em> flag added and/or being a closed loop (source===target).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getIsExtraneous() {
        return software.amazon.jsii.Kernel.get(this, "isExtraneous", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * (experimental) Edge <strong>source</strong> is the node that defines the edge (tail).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.aws.awsprototypingsdk.cdkgraph.Node getSource() {
        return software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(software.aws.awsprototypingsdk.cdkgraph.Node.class));
    }

    /**
     * (experimental) Edge <strong>target</strong> is the node being referenced by the <strong>source</strong> (head).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.aws.awsprototypingsdk.cdkgraph.Node getTarget() {
        return software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(software.aws.awsprototypingsdk.cdkgraph.Node.class));
    }
}
