package software.aws.awsprototypingsdk.cdkgraph;

/**
 * (experimental) Store class provides the in-memory database-like interface for managing all entities in the graph.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.82.0 (build 2d2ddd7)", date = "2023-08-24T23:07:44.495Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.aws.awsprototypingsdk.cdkgraph.$Module.class, fqn = "@aws-prototyping-sdk/cdk-graph.Store")
public class Store extends software.amazon.jsii.JsiiObject implements software.aws.awsprototypingsdk.cdkgraph.ISerializableGraphStore {

    protected Store(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Store(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param allowDestructiveMutations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Store(final @org.jetbrains.annotations.Nullable java.lang.Boolean allowDestructiveMutations) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { allowDestructiveMutations });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Store() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * (experimental) Builds store from serialized store data.
     * <p>
     * @param serializedStore This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.aws.awsprototypingsdk.cdkgraph.Store fromSerializedStore(final @org.jetbrains.annotations.NotNull software.aws.awsprototypingsdk.cdkgraph.SGGraphStore serializedStore) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.aws.awsprototypingsdk.cdkgraph.Store.class, "fromSerializedStore", software.amazon.jsii.NativeType.forClass(software.aws.awsprototypingsdk.cdkgraph.Store.class), new Object[] { java.util.Objects.requireNonNull(serializedStore, "serializedStore is required") });
    }

    /**
     * (experimental) Add <strong>edge</strong> to the store.
     * <p>
     * @param edge This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addEdge(final @org.jetbrains.annotations.NotNull software.aws.awsprototypingsdk.cdkgraph.Edge edge) {
        software.amazon.jsii.Kernel.call(this, "addEdge", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(edge, "edge is required") });
    }

    /**
     * (experimental) Add <strong>node</strong> to the store.
     * <p>
     * @param node This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addNode(final @org.jetbrains.annotations.NotNull software.aws.awsprototypingsdk.cdkgraph.Node node) {
        software.amazon.jsii.Kernel.call(this, "addNode", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(node, "node is required") });
    }

    /**
     * (experimental) Add <strong>stack</strong> node to the store.
     * <p>
     * @param stack This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addStack(final @org.jetbrains.annotations.NotNull software.aws.awsprototypingsdk.cdkgraph.StackNode stack) {
        software.amazon.jsii.Kernel.call(this, "addStack", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(stack, "stack is required") });
    }

    /**
     * (experimental) Add <strong>stage</strong> to the store.
     * <p>
     * @param stage This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addStage(final @org.jetbrains.annotations.NotNull software.aws.awsprototypingsdk.cdkgraph.StageNode stage) {
        software.amazon.jsii.Kernel.call(this, "addStage", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(stage, "stage is required") });
    }

    /**
     * (experimental) Clone the store to allow destructive mutations.
     * <p>
     * @return Returns a clone of the store that allows destructive mutations
     * @param allowDestructiveMutations Indicates if destructive mutations are allowed;.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.aws.awsprototypingsdk.cdkgraph.Store clone(final @org.jetbrains.annotations.Nullable java.lang.Boolean allowDestructiveMutations) {
        return software.amazon.jsii.Kernel.call(this, "clone", software.amazon.jsii.NativeType.forClass(software.aws.awsprototypingsdk.cdkgraph.Store.class), new Object[] { allowDestructiveMutations });
    }

    /**
     * (experimental) Clone the store to allow destructive mutations.
     * <p>
     * @return Returns a clone of the store that allows destructive mutations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.aws.awsprototypingsdk.cdkgraph.Store clone() {
        return software.amazon.jsii.Kernel.call(this, "clone", software.amazon.jsii.NativeType.forClass(software.aws.awsprototypingsdk.cdkgraph.Store.class));
    }

    /**
     * (experimental) Compute <strong>universal</strong> <em>logicalId</em> based on parent stack and construct <em>logicalId</em> (<code>&lt;stack&gt;:&lt;logicalId&gt;</code>).
     * <p>
     * Construct *logicalIds are only unique within their containing stack, so to use <em>logicalId</em>
     * lookups universally (like resolving references) we need a universal key.
     * <p>
     * @param stack This parameter is required.
     * @param logicalId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String computeLogicalUniversalId(final @org.jetbrains.annotations.NotNull software.aws.awsprototypingsdk.cdkgraph.StackNode stack, final @org.jetbrains.annotations.NotNull java.lang.String logicalId) {
        return software.amazon.jsii.Kernel.call(this, "computeLogicalUniversalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(stack, "stack is required"), java.util.Objects.requireNonNull(logicalId, "logicalId is required") });
    }

    /**
     * (experimental) Attempts to lookup the {@link Node} associated with a given *import arn token*.
     * <p>
     * @return Returns matching {@link Node } if found, otherwise undefined.
     * @param value Import arn value, which is either object to tokenize or already tokenized string. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable software.aws.awsprototypingsdk.cdkgraph.Node findNodeByImportArn(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        return software.amazon.jsii.Kernel.call(this, "findNodeByImportArn", software.amazon.jsii.NativeType.forClass(software.aws.awsprototypingsdk.cdkgraph.Node.class), new Object[] { value });
    }

    /**
     * (experimental) Find node within given <strong>stack</strong> with given <em>logicalId</em>.
     * <p>
     * @param stack This parameter is required.
     * @param logicalId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.aws.awsprototypingsdk.cdkgraph.Node findNodeByLogicalId(final @org.jetbrains.annotations.NotNull software.aws.awsprototypingsdk.cdkgraph.StackNode stack, final @org.jetbrains.annotations.NotNull java.lang.String logicalId) {
        return software.amazon.jsii.Kernel.call(this, "findNodeByLogicalId", software.amazon.jsii.NativeType.forClass(software.aws.awsprototypingsdk.cdkgraph.Node.class), new Object[] { java.util.Objects.requireNonNull(stack, "stack is required"), java.util.Objects.requireNonNull(logicalId, "logicalId is required") });
    }

    /**
     * (experimental) Find node by <strong>universal</strong> <em>logicalId</em> (<code>&lt;stack&gt;:&lt;logicalId&gt;</code>).
     * <p>
     * @param uid This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.aws.awsprototypingsdk.cdkgraph.Node findNodeByLogicalUniversalId(final @org.jetbrains.annotations.NotNull java.lang.String uid) {
        return software.amazon.jsii.Kernel.call(this, "findNodeByLogicalUniversalId", software.amazon.jsii.NativeType.forClass(software.aws.awsprototypingsdk.cdkgraph.Node.class), new Object[] { java.util.Objects.requireNonNull(uid, "uid is required") });
    }

    /**
     * (experimental) Get stored <strong>edge</strong> by UUID.
     * <p>
     * @param uuid This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.aws.awsprototypingsdk.cdkgraph.Edge getEdge(final @org.jetbrains.annotations.NotNull java.lang.String uuid) {
        return software.amazon.jsii.Kernel.call(this, "getEdge", software.amazon.jsii.NativeType.forClass(software.aws.awsprototypingsdk.cdkgraph.Edge.class), new Object[] { java.util.Objects.requireNonNull(uuid, "uuid is required") });
    }

    /**
     * (experimental) Get stored <strong>node</strong> by UUID.
     * <p>
     * @param uuid This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.aws.awsprototypingsdk.cdkgraph.Node getNode(final @org.jetbrains.annotations.NotNull java.lang.String uuid) {
        return software.amazon.jsii.Kernel.call(this, "getNode", software.amazon.jsii.NativeType.forClass(software.aws.awsprototypingsdk.cdkgraph.Node.class), new Object[] { java.util.Objects.requireNonNull(uuid, "uuid is required") });
    }

    /**
     * (experimental) Get stored <strong>stack</strong> node by UUID.
     * <p>
     * @param uuid This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.aws.awsprototypingsdk.cdkgraph.StackNode getStack(final @org.jetbrains.annotations.NotNull java.lang.String uuid) {
        return software.amazon.jsii.Kernel.call(this, "getStack", software.amazon.jsii.NativeType.forClass(software.aws.awsprototypingsdk.cdkgraph.StackNode.class), new Object[] { java.util.Objects.requireNonNull(uuid, "uuid is required") });
    }

    /**
     * (experimental) Get stored <strong>stage</strong> node by UUID.
     * <p>
     * @param uuid This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.aws.awsprototypingsdk.cdkgraph.StageNode getStage(final @org.jetbrains.annotations.NotNull java.lang.String uuid) {
        return software.amazon.jsii.Kernel.call(this, "getStage", software.amazon.jsii.NativeType.forClass(software.aws.awsprototypingsdk.cdkgraph.StageNode.class), new Object[] { java.util.Objects.requireNonNull(uuid, "uuid is required") });
    }

    /**
     * (experimental) Remove <strong>edge</strong> from the store.
     * <p>
     * @param edge This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean mutateRemoveEdge(final @org.jetbrains.annotations.NotNull software.aws.awsprototypingsdk.cdkgraph.Edge edge) {
        return software.amazon.jsii.Kernel.call(this, "mutateRemoveEdge", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { java.util.Objects.requireNonNull(edge, "edge is required") });
    }

    /**
     * (experimental) Remove <strong>node</strong> from the store.
     * <p>
     * @param node This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean mutateRemoveNode(final @org.jetbrains.annotations.NotNull software.aws.awsprototypingsdk.cdkgraph.Node node) {
        return software.amazon.jsii.Kernel.call(this, "mutateRemoveNode", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { java.util.Objects.requireNonNull(node, "node is required") });
    }

    /**
     * (experimental) Records arn tokens from imported resources (eg: <code>s3.Bucket.fromBucketArn()</code>) that are used for resolving references.
     * <p>
     * @param arnToken This parameter is required.
     * @param resource This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void recordImportArn(final @org.jetbrains.annotations.NotNull java.lang.String arnToken, final @org.jetbrains.annotations.NotNull software.aws.awsprototypingsdk.cdkgraph.Node resource) {
        software.amazon.jsii.Kernel.call(this, "recordImportArn", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(arnToken, "arnToken is required"), java.util.Objects.requireNonNull(resource, "resource is required") });
    }

    /**
     * (experimental) Record a <strong>universal</strong> <em>logicalId</em> to node mapping in the store.
     * <p>
     * @param stack This parameter is required.
     * @param logicalId This parameter is required.
     * @param resource This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void recordLogicalId(final @org.jetbrains.annotations.NotNull software.aws.awsprototypingsdk.cdkgraph.StackNode stack, final @org.jetbrains.annotations.NotNull java.lang.String logicalId, final @org.jetbrains.annotations.NotNull software.aws.awsprototypingsdk.cdkgraph.Node resource) {
        software.amazon.jsii.Kernel.call(this, "recordLogicalId", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(stack, "stack is required"), java.util.Objects.requireNonNull(logicalId, "logicalId is required"), java.util.Objects.requireNonNull(resource, "resource is required") });
    }

    /**
     * (experimental) Serialize the store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.aws.awsprototypingsdk.cdkgraph.SGGraphStore serialize() {
        return software.amazon.jsii.Kernel.call(this, "serialize", software.amazon.jsii.NativeType.forClass(software.aws.awsprototypingsdk.cdkgraph.SGGraphStore.class));
    }

    /**
     * (experimental) Verifies that the store allows destructive mutations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void verifyDestructiveMutationAllowed() {
        software.amazon.jsii.Kernel.call(this, "verifyDestructiveMutationAllowed", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * (experimental) Indicates if the store allows destructive mutations.
     * <p>
     * Destructive mutations are only allowed on clones of the store to prevent plugins and filters from
     * mutating the store for downstream plugins.
     * <p>
     * All <code>mutate*</code> methods are only allowed on stores that allow destructive mutations.
     * <p>
     * This behavior may change in the future if the need arises for plugins to pass mutated stores
     * to downstream plugins. But it will be done cautiously with ensuring the intent of
     * downstream plugin is to receive the mutated store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getAllowDestructiveMutations() {
        return software.amazon.jsii.Kernel.get(this, "allowDestructiveMutations", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * (experimental) Get record of all store counters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.aws.awsprototypingsdk.cdkgraph.IStoreCounts getCounts() {
        return software.amazon.jsii.Kernel.get(this, "counts", software.amazon.jsii.NativeType.forClass(software.aws.awsprototypingsdk.cdkgraph.IStoreCounts.class));
    }

    /**
     * (experimental) Gets all stored <strong>edges</strong>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.List<software.aws.awsprototypingsdk.cdkgraph.Edge> getEdges() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "edges", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.aws.awsprototypingsdk.cdkgraph.Edge.class))));
    }

    /**
     * (experimental) Gets all stored <strong>nodes</strong>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.List<software.aws.awsprototypingsdk.cdkgraph.Node> getNodes() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "nodes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.aws.awsprototypingsdk.cdkgraph.Node.class))));
    }

    /**
     * (experimental) Root node in the store.
     * <p>
     * The <strong>root</strong> node is not the computed root, but the graph root
     * which is auto-generated and can not be mutated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.aws.awsprototypingsdk.cdkgraph.RootNode getRoot() {
        return software.amazon.jsii.Kernel.get(this, "root", software.amazon.jsii.NativeType.forClass(software.aws.awsprototypingsdk.cdkgraph.RootNode.class));
    }

    /**
     * (experimental) Gets all stored <strong>root stack</strong> nodes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.List<software.aws.awsprototypingsdk.cdkgraph.StackNode> getRootStacks() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "rootStacks", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.aws.awsprototypingsdk.cdkgraph.StackNode.class))));
    }

    /**
     * (experimental) Gets all stored <strong>stack</strong> nodes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.List<software.aws.awsprototypingsdk.cdkgraph.StackNode> getStacks() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "stacks", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.aws.awsprototypingsdk.cdkgraph.StackNode.class))));
    }

    /**
     * (experimental) Gets all stored <strong>stage</strong> nodes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.List<software.aws.awsprototypingsdk.cdkgraph.StageNode> getStages() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "stages", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.aws.awsprototypingsdk.cdkgraph.StageNode.class))));
    }

    /**
     * (experimental) Current SemVer version of the store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getVersion() {
        return software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
