/*
 * Decompiled with CFR 0.152.
 */
package software.aws.pdk.cdk_graph;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.aws.pdk.$Module;
import software.aws.pdk.cdk_graph.BaseEntity;
import software.aws.pdk.cdk_graph.ConstructInfo;
import software.aws.pdk.cdk_graph.Dependency;
import software.aws.pdk.cdk_graph.Edge;
import software.aws.pdk.cdk_graph.IEdgePredicate;
import software.aws.pdk.cdk_graph.IFindEdgeOptions;
import software.aws.pdk.cdk_graph.IFindNodeOptions;
import software.aws.pdk.cdk_graph.INodePredicate;
import software.aws.pdk.cdk_graph.INodeProps;
import software.aws.pdk.cdk_graph.ISerializableNode;
import software.aws.pdk.cdk_graph.NodeTypeEnum;
import software.aws.pdk.cdk_graph.PlainObject;
import software.aws.pdk.cdk_graph.Reference;
import software.aws.pdk.cdk_graph.StackNode;

@Jsii(module=$Module.class, fqn="@aws/pdk.cdk_graph.Node")
public class Node
extends BaseEntity
implements ISerializableNode {
    protected Node(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Node(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Node(@NotNull INodeProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    public void addChild(@NotNull Node node) {
        Kernel.call((Object)this, (String)"addChild", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(node, "node is required")});
    }

    public void addLink(@NotNull Edge edge) {
        Kernel.call((Object)this, (String)"addLink", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(edge, "edge is required")});
    }

    public void addReverseLink(@NotNull Edge edge) {
        Kernel.call((Object)this, (String)"addReverseLink", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(edge, "edge is required")});
    }

    @NotNull
    public Boolean doesDependOn(@NotNull Node node) {
        return (Boolean)Kernel.call((Object)this, (String)"doesDependOn", (NativeType)NativeType.forClass(Boolean.class), (Object[])new Object[]{Objects.requireNonNull(node, "node is required")});
    }

    @NotNull
    public Boolean doesReference(@NotNull Node node) {
        return (Boolean)Kernel.call((Object)this, (String)"doesReference", (NativeType)NativeType.forClass(Boolean.class), (Object[])new Object[]{Objects.requireNonNull(node, "node is required")});
    }

    @Nullable
    public Node find(@NotNull INodePredicate predicate) {
        return (Node)Kernel.call((Object)this, (String)"find", (NativeType)NativeType.forClass(Node.class), (Object[])new Object[]{Objects.requireNonNull(predicate, "predicate is required")});
    }

    @NotNull
    public List<Node> findAll(@Nullable IFindNodeOptions options) {
        return Collections.unmodifiableList((List)Kernel.call((Object)this, (String)"findAll", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Node.class)), (Object[])new Object[]{options}));
    }

    @NotNull
    public List<Node> findAll() {
        return Collections.unmodifiableList((List)Kernel.call((Object)this, (String)"findAll", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Node.class)), (Object[])new Object[0]));
    }

    @NotNull
    public List<Edge> findAllLinks(@Nullable IFindEdgeOptions options) {
        return Collections.unmodifiableList((List)Kernel.call((Object)this, (String)"findAllLinks", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Edge.class)), (Object[])new Object[]{options}));
    }

    @NotNull
    public List<Edge> findAllLinks() {
        return Collections.unmodifiableList((List)Kernel.call((Object)this, (String)"findAllLinks", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Edge.class)), (Object[])new Object[0]));
    }

    @Nullable
    public Node findAncestor(@NotNull INodePredicate predicate, @Nullable Number max) {
        return (Node)Kernel.call((Object)this, (String)"findAncestor", (NativeType)NativeType.forClass(Node.class), (Object[])new Object[]{Objects.requireNonNull(predicate, "predicate is required"), max});
    }

    @Nullable
    public Node findAncestor(@NotNull INodePredicate predicate) {
        return (Node)Kernel.call((Object)this, (String)"findAncestor", (NativeType)NativeType.forClass(Node.class), (Object[])new Object[]{Objects.requireNonNull(predicate, "predicate is required")});
    }

    @Nullable
    public Node findChild(@NotNull String id) {
        return (Node)Kernel.call((Object)this, (String)"findChild", (NativeType)NativeType.forClass(Node.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Nullable
    public Edge findLink(@NotNull IEdgePredicate predicate, @Nullable Boolean reverse, @Nullable Boolean follow, @Nullable Boolean direct) {
        return (Edge)Kernel.call((Object)this, (String)"findLink", (NativeType)NativeType.forClass(Edge.class), (Object[])new Object[]{Objects.requireNonNull(predicate, "predicate is required"), reverse, follow, direct});
    }

    @Nullable
    public Edge findLink(@NotNull IEdgePredicate predicate, @Nullable Boolean reverse, @Nullable Boolean follow) {
        return (Edge)Kernel.call((Object)this, (String)"findLink", (NativeType)NativeType.forClass(Edge.class), (Object[])new Object[]{Objects.requireNonNull(predicate, "predicate is required"), reverse, follow});
    }

    @Nullable
    public Edge findLink(@NotNull IEdgePredicate predicate, @Nullable Boolean reverse) {
        return (Edge)Kernel.call((Object)this, (String)"findLink", (NativeType)NativeType.forClass(Edge.class), (Object[])new Object[]{Objects.requireNonNull(predicate, "predicate is required"), reverse});
    }

    @Nullable
    public Edge findLink(@NotNull IEdgePredicate predicate) {
        return (Edge)Kernel.call((Object)this, (String)"findLink", (NativeType)NativeType.forClass(Edge.class), (Object[])new Object[]{Objects.requireNonNull(predicate, "predicate is required")});
    }

    @NotNull
    public List<Edge> findLinks(@NotNull IEdgePredicate predicate, @Nullable Boolean reverse, @Nullable Boolean follow, @Nullable Boolean direct) {
        return Collections.unmodifiableList((List)Kernel.call((Object)this, (String)"findLinks", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Edge.class)), (Object[])new Object[]{Objects.requireNonNull(predicate, "predicate is required"), reverse, follow, direct}));
    }

    @NotNull
    public List<Edge> findLinks(@NotNull IEdgePredicate predicate, @Nullable Boolean reverse, @Nullable Boolean follow) {
        return Collections.unmodifiableList((List)Kernel.call((Object)this, (String)"findLinks", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Edge.class)), (Object[])new Object[]{Objects.requireNonNull(predicate, "predicate is required"), reverse, follow}));
    }

    @NotNull
    public List<Edge> findLinks(@NotNull IEdgePredicate predicate, @Nullable Boolean reverse) {
        return Collections.unmodifiableList((List)Kernel.call((Object)this, (String)"findLinks", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Edge.class)), (Object[])new Object[]{Objects.requireNonNull(predicate, "predicate is required"), reverse}));
    }

    @NotNull
    public List<Edge> findLinks(@NotNull IEdgePredicate predicate) {
        return Collections.unmodifiableList((List)Kernel.call((Object)this, (String)"findLinks", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Edge.class)), (Object[])new Object[]{Objects.requireNonNull(predicate, "predicate is required")}));
    }

    @Nullable
    public Object getCfnProp(@NotNull String key) {
        return Kernel.call((Object)this, (String)"getCfnProp", (NativeType)NativeType.forClass(Object.class), (Object[])new Object[]{Objects.requireNonNull(key, "key is required")});
    }

    @NotNull
    public Node getChild(@NotNull String id) {
        return (Node)Kernel.call((Object)this, (String)"getChild", (NativeType)NativeType.forClass(Node.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public List<List<Object>> getLinkChains(@Nullable Boolean reverse) {
        return Collections.unmodifiableList((List)Kernel.call((Object)this, (String)"getLinkChains", (NativeType)NativeType.listOf((NativeType)NativeType.listOf((NativeType)NativeType.forClass(Object.class))), (Object[])new Object[]{reverse}));
    }

    @NotNull
    public List<List<Object>> getLinkChains() {
        return Collections.unmodifiableList((List)Kernel.call((Object)this, (String)"getLinkChains", (NativeType)NativeType.listOf((NativeType)NativeType.listOf((NativeType)NativeType.forClass(Object.class))), (Object[])new Object[0]));
    }

    @NotNull
    public Node getNearestAncestor(@NotNull Node node) {
        return (Node)Kernel.call((Object)this, (String)"getNearestAncestor", (NativeType)NativeType.forClass(Node.class), (Object[])new Object[]{Objects.requireNonNull(node, "node is required")});
    }

    @NotNull
    public Boolean isAncestor(@NotNull Node ancestor) {
        return (Boolean)Kernel.call((Object)this, (String)"isAncestor", (NativeType)NativeType.forClass(Boolean.class), (Object[])new Object[]{Objects.requireNonNull(ancestor, "ancestor is required")});
    }

    @NotNull
    public Boolean isChild(@NotNull Node node) {
        return (Boolean)Kernel.call((Object)this, (String)"isChild", (NativeType)NativeType.forClass(Boolean.class), (Object[])new Object[]{Objects.requireNonNull(node, "node is required")});
    }

    public void mutateCollapse() {
        Kernel.call((Object)this, (String)"mutateCollapse", (NativeType)NativeType.VOID, (Object[])new Object[0]);
    }

    @NotNull
    public Node mutateCollapseTo(@NotNull Node ancestor) {
        return (Node)Kernel.call((Object)this, (String)"mutateCollapseTo", (NativeType)NativeType.forClass(Node.class), (Object[])new Object[]{Objects.requireNonNull(ancestor, "ancestor is required")});
    }

    @NotNull
    public Node mutateCollapseToParent() {
        return (Node)Kernel.call((Object)this, (String)"mutateCollapseToParent", (NativeType)NativeType.forClass(Node.class), (Object[])new Object[0]);
    }

    @Override
    public void mutateDestroy(@Nullable Boolean strict) {
        Kernel.call((Object)this, (String)"mutateDestroy", (NativeType)NativeType.VOID, (Object[])new Object[]{strict});
    }

    @Override
    public void mutateDestroy() {
        Kernel.call((Object)this, (String)"mutateDestroy", (NativeType)NativeType.VOID, (Object[])new Object[0]);
    }

    public void mutateHoist(@NotNull Node newParent) {
        Kernel.call((Object)this, (String)"mutateHoist", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(newParent, "newParent is required")});
    }

    public void mutateMove(@NotNull Node newParent) {
        Kernel.call((Object)this, (String)"mutateMove", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(newParent, "newParent is required")});
    }

    @NotNull
    public Boolean mutateRemoveChild(@NotNull Node node) {
        return (Boolean)Kernel.call((Object)this, (String)"mutateRemoveChild", (NativeType)NativeType.forClass(Boolean.class), (Object[])new Object[]{Objects.requireNonNull(node, "node is required")});
    }

    @NotNull
    public Boolean mutateRemoveLink(@NotNull Edge link) {
        return (Boolean)Kernel.call((Object)this, (String)"mutateRemoveLink", (NativeType)NativeType.forClass(Boolean.class), (Object[])new Object[]{Objects.requireNonNull(link, "link is required")});
    }

    @NotNull
    public Boolean mutateRemoveReverseLink(@NotNull Edge link) {
        return (Boolean)Kernel.call((Object)this, (String)"mutateRemoveReverseLink", (NativeType)NativeType.forClass(Boolean.class), (Object[])new Object[]{Objects.requireNonNull(link, "link is required")});
    }

    public void mutateUncluster() {
        Kernel.call((Object)this, (String)"mutateUncluster", (NativeType)NativeType.VOID, (Object[])new Object[0]);
    }

    @NotNull
    public String toString() {
        return (String)Kernel.call((Object)this, (String)"toString", (NativeType)NativeType.forClass(String.class), (Object[])new Object[0]);
    }

    @NotNull
    public Boolean getAllowDestructiveMutations() {
        return (Boolean)Kernel.get((Object)this, (String)"allowDestructiveMutations", (NativeType)NativeType.forClass(Boolean.class));
    }

    @NotNull
    public List<Node> getChildren() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"children", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Node.class))));
    }

    @NotNull
    public List<Node> getDependedOnBy() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"dependedOnBy", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Node.class))));
    }

    @NotNull
    public List<Node> getDependencies() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"dependencies", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Node.class))));
    }

    @NotNull
    public List<Dependency> getDependencyLinks() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"dependencyLinks", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Dependency.class))));
    }

    @NotNull
    public Number getDepth() {
        return (Number)Kernel.get((Object)this, (String)"depth", (NativeType)NativeType.forClass(Number.class));
    }

    @NotNull
    public String getId() {
        return (String)Kernel.get((Object)this, (String)"id", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public Boolean getIsAsset() {
        return (Boolean)Kernel.get((Object)this, (String)"isAsset", (NativeType)NativeType.forClass(Boolean.class));
    }

    @NotNull
    public Boolean getIsCfnFqn() {
        return (Boolean)Kernel.get((Object)this, (String)"isCfnFqn", (NativeType)NativeType.forClass(Boolean.class));
    }

    @NotNull
    public Boolean getIsCluster() {
        return (Boolean)Kernel.get((Object)this, (String)"isCluster", (NativeType)NativeType.forClass(Boolean.class));
    }

    @NotNull
    public Boolean getIsCustomResource() {
        return (Boolean)Kernel.get((Object)this, (String)"isCustomResource", (NativeType)NativeType.forClass(Boolean.class));
    }

    @NotNull
    public Boolean getIsExtraneous() {
        return (Boolean)Kernel.get((Object)this, (String)"isExtraneous", (NativeType)NativeType.forClass(Boolean.class));
    }

    @NotNull
    public Boolean getIsGraphContainer() {
        return (Boolean)Kernel.get((Object)this, (String)"isGraphContainer", (NativeType)NativeType.forClass(Boolean.class));
    }

    @NotNull
    public Boolean getIsLeaf() {
        return (Boolean)Kernel.get((Object)this, (String)"isLeaf", (NativeType)NativeType.forClass(Boolean.class));
    }

    @NotNull
    public Boolean getIsTopLevel() {
        return (Boolean)Kernel.get((Object)this, (String)"isTopLevel", (NativeType)NativeType.forClass(Boolean.class));
    }

    @NotNull
    public List<Edge> getLinks() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"links", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Edge.class))));
    }

    @NotNull
    public NodeTypeEnum getNodeType() {
        return (NodeTypeEnum)((Object)Kernel.get((Object)this, (String)"nodeType", (NativeType)NativeType.forClass(NodeTypeEnum.class)));
    }

    @NotNull
    public String getPath() {
        return (String)Kernel.get((Object)this, (String)"path", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public List<Node> getReferencedBy() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"referencedBy", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Node.class))));
    }

    @NotNull
    public List<Reference> getReferenceLinks() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"referenceLinks", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Reference.class))));
    }

    @NotNull
    public List<Node> getReferences() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"references", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Node.class))));
    }

    @NotNull
    public List<Dependency> getReverseDependencyLinks() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"reverseDependencyLinks", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Dependency.class))));
    }

    @NotNull
    public List<Edge> getReverseLinks() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"reverseLinks", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Edge.class))));
    }

    @NotNull
    public List<Reference> getReverseReferenceLinks() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"reverseReferenceLinks", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Reference.class))));
    }

    @NotNull
    public List<Node> getScopes() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"scopes", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Node.class))));
    }

    @NotNull
    public List<Node> getSiblings() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"siblings", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Node.class))));
    }

    @Nullable
    public PlainObject getCfnProps() {
        return (PlainObject)Kernel.get((Object)this, (String)"cfnProps", (NativeType)NativeType.forClass(PlainObject.class));
    }

    @Nullable
    public String getCfnType() {
        return (String)Kernel.get((Object)this, (String)"cfnType", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public ConstructInfo getConstructInfo() {
        return (ConstructInfo)Kernel.get((Object)this, (String)"constructInfo", (NativeType)NativeType.forClass(ConstructInfo.class));
    }

    @Nullable
    public String getConstructInfoFqn() {
        return (String)Kernel.get((Object)this, (String)"constructInfoFqn", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public String getLogicalId() {
        return (String)Kernel.get((Object)this, (String)"logicalId", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public Node getParent() {
        return (Node)Kernel.get((Object)this, (String)"parent", (NativeType)NativeType.forClass(Node.class));
    }

    @Nullable
    public StackNode getRootStack() {
        return (StackNode)Kernel.get((Object)this, (String)"rootStack", (NativeType)NativeType.forClass(StackNode.class));
    }

    @Nullable
    public StackNode getStack() {
        return (StackNode)Kernel.get((Object)this, (String)"stack", (NativeType)NativeType.forClass(StackNode.class));
    }
}

