package software.aws.pdk.monorepo;

/**
 * Interface that all NXProject implementations should implement.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.88.0 (build eaabd08)", date = "2023-10-16T23:32:42.232Z")
@software.amazon.jsii.Jsii(module = software.aws.pdk.$Module.class, fqn = "@aws/pdk.monorepo.INxProjectCore")
@software.amazon.jsii.Jsii.Proxy(INxProjectCore.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface INxProjectCore extends software.amazon.jsii.JsiiSerializable {

    /**
     * Return the NxWorkspace instance.
     * <p>
     * This should be implemented using a getter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.aws.pdk.monorepo.NxWorkspace getNx();

    /**
     * Create an implicit dependency between two Projects.
     * <p>
     * This is typically
     * used in polygot repos where a Typescript project wants a build dependency
     * on a Python project as an example.
     * <p>
     * @param dependent project you want to have the dependency. This parameter is required.
     * @param dependee project you wish to depend on. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void addImplicitDependency(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.Project dependent, final @org.jetbrains.annotations.NotNull java.lang.Object dependee);

    /**
     * Adds a dependency between two Java Projects in the monorepo.
     * <p>
     * @param dependent project you want to have the dependency. This parameter is required.
     * @param dependee project you wish to depend on. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void addJavaDependency(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.java.JavaProject dependent, final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.java.JavaProject dependee);

    /**
     * Add project task that executes <code>npx nx run-many ...</code> style command.
     * <p>
     * @param name task name. This parameter is required.
     * @param options options. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.Task addNxRunManyTask(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.NotNull software.aws.pdk.monorepo.nx.RunManyOptions options);

    /**
     * Adds a dependency between two Python Projects in the monorepo.
     * <p>
     * The dependent must have Poetry enabled.
     * <p>
     * @param dependent project you want to have the dependency (must be a Poetry Python Project). This parameter is required.
     * @param dependee project you wish to depend on. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void addPythonPoetryDependency(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.python.PythonProject dependent, final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.python.PythonProject dependee);

    /**
     * Helper to format <code>npx nx run-many ...</code> style command.
     * <p>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> composeNxRunManyCommand(final @org.jetbrains.annotations.NotNull software.aws.pdk.monorepo.nx.RunManyOptions options);

    /**
     * Helper to format <code>npx nx run-many ...</code> style command execution in package manager.
     * <p>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String execNxRunManyCommand(final @org.jetbrains.annotations.NotNull software.aws.pdk.monorepo.nx.RunManyOptions options);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.aws.pdk.monorepo.INxProjectCore.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Return the NxWorkspace instance.
         * <p>
         * This should be implemented using a getter.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.aws.pdk.monorepo.NxWorkspace getNx() {
            return software.amazon.jsii.Kernel.get(this, "nx", software.amazon.jsii.NativeType.forClass(software.aws.pdk.monorepo.NxWorkspace.class));
        }

        /**
         * Create an implicit dependency between two Projects.
         * <p>
         * This is typically
         * used in polygot repos where a Typescript project wants a build dependency
         * on a Python project as an example.
         * <p>
         * @param dependent project you want to have the dependency. This parameter is required.
         * @param dependee project you wish to depend on. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void addImplicitDependency(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.Project dependent, final @org.jetbrains.annotations.NotNull java.lang.Object dependee) {
            if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
                if (
                     !(dependee instanceof java.lang.String)
                    && !(dependee instanceof io.github.cdklabs.projen.Project)
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("dependee")
                            .append(" to be one of: java.lang.String, io.github.cdklabs.projen.Project; received ")
                            .append(dependee.getClass()).toString());
                }
            }
            software.amazon.jsii.Kernel.call(this, "addImplicitDependency", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(dependent, "dependent is required"), java.util.Objects.requireNonNull(dependee, "dependee is required") });
        }

        /**
         * Adds a dependency between two Java Projects in the monorepo.
         * <p>
         * @param dependent project you want to have the dependency. This parameter is required.
         * @param dependee project you wish to depend on. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void addJavaDependency(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.java.JavaProject dependent, final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.java.JavaProject dependee) {
            software.amazon.jsii.Kernel.call(this, "addJavaDependency", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(dependent, "dependent is required"), java.util.Objects.requireNonNull(dependee, "dependee is required") });
        }

        /**
         * Add project task that executes <code>npx nx run-many ...</code> style command.
         * <p>
         * @param name task name. This parameter is required.
         * @param options options. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.Task addNxRunManyTask(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.NotNull software.aws.pdk.monorepo.nx.RunManyOptions options) {
            return software.amazon.jsii.Kernel.call(this, "addNxRunManyTask", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.Task.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required"), java.util.Objects.requireNonNull(options, "options is required") });
        }

        /**
         * Adds a dependency between two Python Projects in the monorepo.
         * <p>
         * The dependent must have Poetry enabled.
         * <p>
         * @param dependent project you want to have the dependency (must be a Poetry Python Project). This parameter is required.
         * @param dependee project you wish to depend on. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void addPythonPoetryDependency(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.python.PythonProject dependent, final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.python.PythonProject dependee) {
            software.amazon.jsii.Kernel.call(this, "addPythonPoetryDependency", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(dependent, "dependent is required"), java.util.Objects.requireNonNull(dependee, "dependee is required") });
        }

        /**
         * Helper to format <code>npx nx run-many ...</code> style command.
         * <p>
         * @param options This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> composeNxRunManyCommand(final @org.jetbrains.annotations.NotNull software.aws.pdk.monorepo.nx.RunManyOptions options) {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "composeNxRunManyCommand", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(options, "options is required") }));
        }

        /**
         * Helper to format <code>npx nx run-many ...</code> style command execution in package manager.
         * <p>
         * @param options This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull java.lang.String execNxRunManyCommand(final @org.jetbrains.annotations.NotNull software.aws.pdk.monorepo.nx.RunManyOptions options) {
            return software.amazon.jsii.Kernel.call(this, "execNxRunManyCommand", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
        }
    }

    /**
     * Internal default implementation for {@link INxProjectCore}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends INxProjectCore {

        /**
         * Return the NxWorkspace instance.
         * <p>
         * This should be implemented using a getter.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.aws.pdk.monorepo.NxWorkspace getNx() {
            return software.amazon.jsii.Kernel.get(this, "nx", software.amazon.jsii.NativeType.forClass(software.aws.pdk.monorepo.NxWorkspace.class));
        }

        /**
         * Create an implicit dependency between two Projects.
         * <p>
         * This is typically
         * used in polygot repos where a Typescript project wants a build dependency
         * on a Python project as an example.
         * <p>
         * @param dependent project you want to have the dependency. This parameter is required.
         * @param dependee project you wish to depend on. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void addImplicitDependency(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.Project dependent, final @org.jetbrains.annotations.NotNull java.lang.Object dependee) {
            if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
                if (
                     !(dependee instanceof java.lang.String)
                    && !(dependee instanceof io.github.cdklabs.projen.Project)
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("dependee")
                            .append(" to be one of: java.lang.String, io.github.cdklabs.projen.Project; received ")
                            .append(dependee.getClass()).toString());
                }
            }
            software.amazon.jsii.Kernel.call(this, "addImplicitDependency", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(dependent, "dependent is required"), java.util.Objects.requireNonNull(dependee, "dependee is required") });
        }

        /**
         * Adds a dependency between two Java Projects in the monorepo.
         * <p>
         * @param dependent project you want to have the dependency. This parameter is required.
         * @param dependee project you wish to depend on. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void addJavaDependency(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.java.JavaProject dependent, final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.java.JavaProject dependee) {
            software.amazon.jsii.Kernel.call(this, "addJavaDependency", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(dependent, "dependent is required"), java.util.Objects.requireNonNull(dependee, "dependee is required") });
        }

        /**
         * Add project task that executes <code>npx nx run-many ...</code> style command.
         * <p>
         * @param name task name. This parameter is required.
         * @param options options. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.Task addNxRunManyTask(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.NotNull software.aws.pdk.monorepo.nx.RunManyOptions options) {
            return software.amazon.jsii.Kernel.call(this, "addNxRunManyTask", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.Task.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required"), java.util.Objects.requireNonNull(options, "options is required") });
        }

        /**
         * Adds a dependency between two Python Projects in the monorepo.
         * <p>
         * The dependent must have Poetry enabled.
         * <p>
         * @param dependent project you want to have the dependency (must be a Poetry Python Project). This parameter is required.
         * @param dependee project you wish to depend on. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void addPythonPoetryDependency(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.python.PythonProject dependent, final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.python.PythonProject dependee) {
            software.amazon.jsii.Kernel.call(this, "addPythonPoetryDependency", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(dependent, "dependent is required"), java.util.Objects.requireNonNull(dependee, "dependee is required") });
        }

        /**
         * Helper to format <code>npx nx run-many ...</code> style command.
         * <p>
         * @param options This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> composeNxRunManyCommand(final @org.jetbrains.annotations.NotNull software.aws.pdk.monorepo.nx.RunManyOptions options) {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "composeNxRunManyCommand", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(options, "options is required") }));
        }

        /**
         * Helper to format <code>npx nx run-many ...</code> style command execution in package manager.
         * <p>
         * @param options This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull java.lang.String execNxRunManyCommand(final @org.jetbrains.annotations.NotNull software.aws.pdk.monorepo.nx.RunManyOptions options) {
            return software.amazon.jsii.Kernel.call(this, "execNxRunManyCommand", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
        }
    }
}
