package software.aws.pdk.monorepo;

/**
 * Workspace configurations.
 * <p>
 * @see <a href="https://classic.yarnpkg.com/lang/en/docs/workspaces/">https://classic.yarnpkg.com/lang/en/docs/workspaces/</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.88.0 (build eaabd08)", date = "2023-10-16T23:32:42.333Z")
@software.amazon.jsii.Jsii(module = software.aws.pdk.$Module.class, fqn = "@aws/pdk.monorepo.WorkspaceConfig")
@software.amazon.jsii.Jsii.Proxy(WorkspaceConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface WorkspaceConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * List of additional package globs to include in the workspace.
     * <p>
     * All packages which are parented by the monorepo are automatically added to the workspace, but you can use this
     * property to specify any additional paths to packages which may not be managed by projen.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAdditionalPackages() {
        return null;
    }

    /**
     * Links all local workspace project bins so they can be used for local development.
     * <p>
     * Package bins are only linked when installed from the registry, however it is very useful
     * for monorepo development to also utilize these bin scripts. When enabled, this flag will
     * recursively link all bins from packages.json files to the root node_modules/.bin.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getLinkLocalWorkspaceBins() {
        return null;
    }

    /**
     * Yarn workspace config.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.aws.pdk.monorepo.YarnWorkspaceConfig getYarn() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link WorkspaceConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link WorkspaceConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<WorkspaceConfig> {
        java.util.List<java.lang.String> additionalPackages;
        java.lang.Boolean linkLocalWorkspaceBins;
        software.aws.pdk.monorepo.YarnWorkspaceConfig yarn;

        /**
         * Sets the value of {@link WorkspaceConfig#getAdditionalPackages}
         * @param additionalPackages List of additional package globs to include in the workspace.
         *                           All packages which are parented by the monorepo are automatically added to the workspace, but you can use this
         *                           property to specify any additional paths to packages which may not be managed by projen.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalPackages(java.util.List<java.lang.String> additionalPackages) {
            this.additionalPackages = additionalPackages;
            return this;
        }

        /**
         * Sets the value of {@link WorkspaceConfig#getLinkLocalWorkspaceBins}
         * @param linkLocalWorkspaceBins Links all local workspace project bins so they can be used for local development.
         *                               Package bins are only linked when installed from the registry, however it is very useful
         *                               for monorepo development to also utilize these bin scripts. When enabled, this flag will
         *                               recursively link all bins from packages.json files to the root node_modules/.bin.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder linkLocalWorkspaceBins(java.lang.Boolean linkLocalWorkspaceBins) {
            this.linkLocalWorkspaceBins = linkLocalWorkspaceBins;
            return this;
        }

        /**
         * Sets the value of {@link WorkspaceConfig#getYarn}
         * @param yarn Yarn workspace config.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder yarn(software.aws.pdk.monorepo.YarnWorkspaceConfig yarn) {
            this.yarn = yarn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link WorkspaceConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public WorkspaceConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link WorkspaceConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WorkspaceConfig {
        private final java.util.List<java.lang.String> additionalPackages;
        private final java.lang.Boolean linkLocalWorkspaceBins;
        private final software.aws.pdk.monorepo.YarnWorkspaceConfig yarn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.additionalPackages = software.amazon.jsii.Kernel.get(this, "additionalPackages", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.linkLocalWorkspaceBins = software.amazon.jsii.Kernel.get(this, "linkLocalWorkspaceBins", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.yarn = software.amazon.jsii.Kernel.get(this, "yarn", software.amazon.jsii.NativeType.forClass(software.aws.pdk.monorepo.YarnWorkspaceConfig.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.additionalPackages = builder.additionalPackages;
            this.linkLocalWorkspaceBins = builder.linkLocalWorkspaceBins;
            this.yarn = builder.yarn;
        }

        @Override
        public final java.util.List<java.lang.String> getAdditionalPackages() {
            return this.additionalPackages;
        }

        @Override
        public final java.lang.Boolean getLinkLocalWorkspaceBins() {
            return this.linkLocalWorkspaceBins;
        }

        @Override
        public final software.aws.pdk.monorepo.YarnWorkspaceConfig getYarn() {
            return this.yarn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAdditionalPackages() != null) {
                data.set("additionalPackages", om.valueToTree(this.getAdditionalPackages()));
            }
            if (this.getLinkLocalWorkspaceBins() != null) {
                data.set("linkLocalWorkspaceBins", om.valueToTree(this.getLinkLocalWorkspaceBins()));
            }
            if (this.getYarn() != null) {
                data.set("yarn", om.valueToTree(this.getYarn()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws/pdk.monorepo.WorkspaceConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            WorkspaceConfig.Jsii$Proxy that = (WorkspaceConfig.Jsii$Proxy) o;

            if (this.additionalPackages != null ? !this.additionalPackages.equals(that.additionalPackages) : that.additionalPackages != null) return false;
            if (this.linkLocalWorkspaceBins != null ? !this.linkLocalWorkspaceBins.equals(that.linkLocalWorkspaceBins) : that.linkLocalWorkspaceBins != null) return false;
            return this.yarn != null ? this.yarn.equals(that.yarn) : that.yarn == null;
        }

        @Override
        public final int hashCode() {
            int result = this.additionalPackages != null ? this.additionalPackages.hashCode() : 0;
            result = 31 * result + (this.linkLocalWorkspaceBins != null ? this.linkLocalWorkspaceBins.hashCode() : 0);
            result = 31 * result + (this.yarn != null ? this.yarn.hashCode() : 0);
            return result;
        }
    }
}
