package software.aws.pdk.pipeline;

/**
 * An extension to CodePipeline which configures sane defaults for a NX Monorepo codebase.
 * <p>
 * In addition to this, it also creates a CodeCommit repository with
 * automated PR builds and approvals.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.88.0 (build eaabd08)", date = "2023-10-16T23:32:42.345Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.aws.pdk.$Module.class, fqn = "@aws/pdk.pipeline.PDKPipeline")
public class PDKPipeline extends software.constructs.Construct {

    protected PDKPipeline(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PDKPipeline(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        ALL_BRANCHES = java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticGet(software.aws.pdk.pipeline.PDKPipeline.class, "ALL_BRANCHES", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
        DEFAULT_BRANCH_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.aws.pdk.pipeline.PDKPipeline.class, "defaultBranchName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public PDKPipeline(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.aws.pdk.pipeline.PDKPipelineProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A helper function to create a branch prefix.
     * <p>
     * The prefix is empty on the default branch.
     * <p>
     * @return The branch prefix.
     * @param props ? { defaultBranchName? Specify the default branch name without context. node? The current app to fetch defaultBranchName from context. }.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String getBranchPrefix(final @org.jetbrains.annotations.Nullable software.aws.pdk.pipeline.IsDefaultBranchProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.aws.pdk.pipeline.PDKPipeline.class, "getBranchPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { props });
    }

    /**
     * A helper function to create a branch prefix.
     * <p>
     * The prefix is empty on the default branch.
     * <p>
     * @return The branch prefix.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String getBranchPrefix() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.aws.pdk.pipeline.PDKPipeline.class, "getBranchPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A helper function to determine if the current branch is the default branch.
     * <p>
     * If there is no BRANCH environment variable, then assume this is the default
     * branch. Otherwise, check that BRANCH matches the default branch name.
     * <p>
     * The default branch name is determined in the following priority:
     * <p>
     * <ol>
     * <li>defaultBranchName property</li>
     * <li>defaultBranchName context</li>
     * <li>PDKPipeline.defaultBranchName constant</li>
     * </ol>
     * <p>
     * @return True if the current branch is the default branch.
     * @param props ? { defaultBranchName? Specify the default branch name without context. node? The current app to fetch defaultBranchName from context. }.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isDefaultBranch(final @org.jetbrains.annotations.Nullable software.aws.pdk.pipeline.IsDefaultBranchProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.aws.pdk.pipeline.PDKPipeline.class, "isDefaultBranch", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { props });
    }

    /**
     * A helper function to determine if the current branch is the default branch.
     * <p>
     * If there is no BRANCH environment variable, then assume this is the default
     * branch. Otherwise, check that BRANCH matches the default branch name.
     * <p>
     * The default branch name is determined in the following priority:
     * <p>
     * <ol>
     * <li>defaultBranchName property</li>
     * <li>defaultBranchName context</li>
     * <li>PDKPipeline.defaultBranchName constant</li>
     * </ol>
     * <p>
     * @return True if the current branch is the default branch.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isDefaultBranch() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.aws.pdk.pipeline.PDKPipeline.class, "isDefaultBranch", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * A helper function to normalize the branch name with only alphanumeric characters and hypens ('-').
     * <p>
     * @return The normalized branch name.
     * @param branchName The name of the branch to normalize. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String normalizeBranchName(final @org.jetbrains.annotations.NotNull java.lang.String branchName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.aws.pdk.pipeline.PDKPipeline.class, "normalizeBranchName", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(branchName, "branchName is required") });
    }

    /**
     * @param stage This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.StageDeployment addStage(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stage stage, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.pipelines.AddStageOpts options) {
        return software.amazon.jsii.Kernel.call(this, "addStage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.StageDeployment.class), new Object[] { java.util.Objects.requireNonNull(stage, "stage is required"), options });
    }

    /**
     * @param stage This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.StageDeployment addStage(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stage stage) {
        return software.amazon.jsii.Kernel.call(this, "addStage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.StageDeployment.class), new Object[] { java.util.Objects.requireNonNull(stage, "stage is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void buildPipeline() {
        software.amazon.jsii.Kernel.call(this, "buildPipeline", software.amazon.jsii.NativeType.VOID);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void suppressCDKViolations() {
        software.amazon.jsii.Kernel.call(this, "suppressCDKViolations", software.amazon.jsii.NativeType.VOID);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.util.List<java.lang.String> ALL_BRANCHES;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String DEFAULT_BRANCH_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.CodePipeline getCodePipeline() {
        return software.amazon.jsii.Kernel.get(this, "codePipeline", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.CodePipeline.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codecommit.IRepository getCodeRepository() {
        return software.amazon.jsii.Kernel.get(this, "codeRepository", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codecommit.IRepository.class));
    }

    /**
     * A fluent builder for {@link software.aws.pdk.pipeline.PDKPipeline}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.aws.pdk.pipeline.PDKPipeline> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.aws.pdk.pipeline.PDKPipelineProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.aws.pdk.pipeline.PDKPipelineProps.Builder();
        }

        /**
         * An existing S3 Bucket to use for storing the pipeline's artifact.
         * <p>
         * Default: - A new S3 bucket will be created.
         * <p>
         * @return {@code this}
         * @param artifactBucket An existing S3 Bucket to use for storing the pipeline's artifact. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder artifactBucket(final software.amazon.awscdk.services.s3.IBucket artifactBucket) {
            this.props.artifactBucket(artifactBucket);
            return this;
        }

        /**
         * Additional customizations to apply to the asset publishing CodeBuild projects.
         * <p>
         * Default: - Only `codeBuildDefaults` are applied
         * <p>
         * @return {@code this}
         * @param assetPublishingCodeBuildDefaults Additional customizations to apply to the asset publishing CodeBuild projects. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetPublishingCodeBuildDefaults(final software.amazon.awscdk.pipelines.CodeBuildOptions assetPublishingCodeBuildDefaults) {
            this.props.assetPublishingCodeBuildDefaults(assetPublishingCodeBuildDefaults);
            return this;
        }

        /**
         * CDK CLI version to use in self-mutation and asset publishing steps.
         * <p>
         * If you want to lock the CDK CLI version used in the pipeline, by steps
         * that are automatically generated for you, specify the version here.
         * <p>
         * We recommend you do not specify this value, as not specifying it always
         * uses the latest CLI version which is backwards compatible with old versions.
         * <p>
         * If you do specify it, be aware that this version should always be equal to or higher than the
         * version of the CDK framework used by the CDK app, when the CDK commands are
         * run during your pipeline execution. When you change this version, the <em>next
         * time</em> the <code>SelfMutate</code> step runs it will still be using the CLI of the the
         * <em>previous</em> version that was in this property: it will only start using the
         * new version after <code>SelfMutate</code> completes successfully. That means that if
         * you want to update both framework and CLI version, you should update the
         * CLI version first, commit, push and deploy, and only then update the
         * framework version.
         * <p>
         * Default: - Latest version
         * <p>
         * @return {@code this}
         * @param cliVersion CDK CLI version to use in self-mutation and asset publishing steps. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cliVersion(final java.lang.String cliVersion) {
            this.props.cliVersion(cliVersion);
            return this;
        }

        /**
         * Customize the CodeBuild projects created for this pipeline.
         * <p>
         * Default: - All projects run non-privileged build, SMALL instance, LinuxBuildImage.STANDARD_7_0
         * <p>
         * @return {@code this}
         * @param codeBuildDefaults Customize the CodeBuild projects created for this pipeline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder codeBuildDefaults(final software.amazon.awscdk.pipelines.CodeBuildOptions codeBuildDefaults) {
            this.props.codeBuildDefaults(codeBuildDefaults);
            return this;
        }

        /**
         * An existing Pipeline to be reused and built upon.
         * <p>
         * [disable-awslint:ref-via-interface]
         * <p>
         * Default: - a new underlying pipeline is created.
         * <p>
         * @return {@code this}
         * @param codePipeline An existing Pipeline to be reused and built upon. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder codePipeline(final software.amazon.awscdk.services.codepipeline.Pipeline codePipeline) {
            this.props.codePipeline(codePipeline);
            return this;
        }

        /**
         * Create KMS keys for the artifact buckets, allowing cross-account deployments.
         * <p>
         * The artifact buckets have to be encrypted to support deploying CDK apps to
         * another account, so if you want to do that or want to have your artifact
         * buckets encrypted, be sure to set this value to <code>true</code>.
         * <p>
         * Be aware there is a cost associated with maintaining the KMS keys.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param crossAccountKeys Create KMS keys for the artifact buckets, allowing cross-account deployments. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder crossAccountKeys(final java.lang.Boolean crossAccountKeys) {
            this.props.crossAccountKeys(crossAccountKeys);
            return this;
        }

        /**
         * A list of credentials used to authenticate to Docker registries.
         * <p>
         * Specify any credentials necessary within the pipeline to build, synth, update, or publish assets.
         * <p>
         * Default: []
         * <p>
         * @return {@code this}
         * @param dockerCredentials A list of credentials used to authenticate to Docker registries. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dockerCredentials(final java.util.List<? extends software.amazon.awscdk.pipelines.DockerCredential> dockerCredentials) {
            this.props.dockerCredentials(dockerCredentials);
            return this;
        }

        /**
         * Enable Docker for the self-mutate step.
         * <p>
         * Set this to true if the pipeline itself uses Docker container assets
         * (for example, if you use <code>LinuxBuildImage.fromAsset()</code> as the build
         * image of a CodeBuild step in the pipeline).
         * <p>
         * You do not need to set it if you build Docker image assets in the
         * application Stages and Stacks that are <em>deployed</em> by this pipeline.
         * <p>
         * Configures privileged mode for the self-mutation CodeBuild action.
         * <p>
         * If you are about to turn this on in an already-deployed Pipeline,
         * set the value to <code>true</code> first, commit and allow the pipeline to
         * self-update, and only then use the Docker asset in the pipeline.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param dockerEnabledForSelfMutation Enable Docker for the self-mutate step. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dockerEnabledForSelfMutation(final java.lang.Boolean dockerEnabledForSelfMutation) {
            this.props.dockerEnabledForSelfMutation(dockerEnabledForSelfMutation);
            return this;
        }

        /**
         * Enable Docker for the 'synth' step.
         * <p>
         * Set this to true if you are using file assets that require
         * "bundling" anywhere in your application (meaning an asset
         * compilation step will be run with the tools provided by
         * a Docker image), both for the Pipeline stack as well as the
         * application stacks.
         * <p>
         * A common way to use bundling assets in your application is by
         * using the <code>aws-cdk-lib/aws-lambda-nodejs</code> library.
         * <p>
         * Configures privileged mode for the synth CodeBuild action.
         * <p>
         * If you are about to turn this on in an already-deployed Pipeline,
         * set the value to <code>true</code> first, commit and allow the pipeline to
         * self-update, and only then use the bundled asset.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param dockerEnabledForSynth Enable Docker for the 'synth' step. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dockerEnabledForSynth(final java.lang.Boolean dockerEnabledForSynth) {
            this.props.dockerEnabledForSynth(dockerEnabledForSynth);
            return this;
        }

        /**
         * Enable KMS key rotation for the generated KMS keys.
         * <p>
         * By default KMS key rotation is disabled, but will add
         * additional costs when enabled.
         * <p>
         * Default: - false (key rotation is disabled)
         * <p>
         * @return {@code this}
         * @param enableKeyRotation Enable KMS key rotation for the generated KMS keys. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableKeyRotation(final java.lang.Boolean enableKeyRotation) {
            this.props.enableKeyRotation(enableKeyRotation);
            return this;
        }

        /**
         * The name of the CodePipeline pipeline.
         * <p>
         * Default: - Automatically generated
         * <p>
         * @return {@code this}
         * @param pipelineName The name of the CodePipeline pipeline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pipelineName(final java.lang.String pipelineName) {
            this.props.pipelineName(pipelineName);
            return this;
        }

        /**
         * Publish assets in multiple CodeBuild projects. If set to false, use one Project per type to publish all assets.
         * <p>
         * Publishing in parallel improves concurrency and may reduce publishing
         * latency, but may also increase overall provisioning time of the CodeBuild
         * projects.
         * <p>
         * Experiment and see what value works best for you.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param publishAssetsInParallel Publish assets in multiple CodeBuild projects. If set to false, use one Project per type to publish all assets. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publishAssetsInParallel(final java.lang.Boolean publishAssetsInParallel) {
            this.props.publishAssetsInParallel(publishAssetsInParallel);
            return this;
        }

        /**
         * Reuse the same cross region support stack for all pipelines in the App.
         * <p>
         * Default: - true (Use the same support stack for all pipelines in App)
         * <p>
         * @return {@code this}
         * @param reuseCrossRegionSupportStacks Reuse the same cross region support stack for all pipelines in the App. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reuseCrossRegionSupportStacks(final java.lang.Boolean reuseCrossRegionSupportStacks) {
            this.props.reuseCrossRegionSupportStacks(reuseCrossRegionSupportStacks);
            return this;
        }

        /**
         * The IAM role to be assumed by this Pipeline.
         * <p>
         * Default: - A new role is created
         * <p>
         * @return {@code this}
         * @param role The IAM role to be assumed by this Pipeline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * Whether the pipeline will update itself.
         * <p>
         * This needs to be set to <code>true</code> to allow the pipeline to reconfigure
         * itself when assets or stages are being added to it, and <code>true</code> is the
         * recommended setting.
         * <p>
         * You can temporarily set this to <code>false</code> while you are iterating
         * on the pipeline itself and prefer to deploy changes using <code>cdk deploy</code>.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param selfMutation Whether the pipeline will update itself. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder selfMutation(final java.lang.Boolean selfMutation) {
            this.props.selfMutation(selfMutation);
            return this;
        }

        /**
         * Additional customizations to apply to the self mutation CodeBuild projects.
         * <p>
         * Default: - Only `codeBuildDefaults` are applied
         * <p>
         * @return {@code this}
         * @param selfMutationCodeBuildDefaults Additional customizations to apply to the self mutation CodeBuild projects. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder selfMutationCodeBuildDefaults(final software.amazon.awscdk.pipelines.CodeBuildOptions selfMutationCodeBuildDefaults) {
            this.props.selfMutationCodeBuildDefaults(selfMutationCodeBuildDefaults);
            return this;
        }

        /**
         * The build step that produces the CDK Cloud Assembly.
         * <p>
         * The primary output of this step needs to be the <code>cdk.out</code> directory
         * generated by the <code>cdk synth</code> command.
         * <p>
         * If you use a <code>ShellStep</code> here and you don't configure an output directory,
         * the output directory will automatically be assumed to be <code>cdk.out</code>.
         * <p>
         * @return {@code this}
         * @param synth The build step that produces the CDK Cloud Assembly. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder synth(final software.amazon.awscdk.pipelines.IFileSetProducer synth) {
            this.props.synth(synth);
            return this;
        }

        /**
         * Additional customizations to apply to the synthesize CodeBuild projects.
         * <p>
         * Default: - Only `codeBuildDefaults` are applied
         * <p>
         * @return {@code this}
         * @param synthCodeBuildDefaults Additional customizations to apply to the synthesize CodeBuild projects. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder synthCodeBuildDefaults(final software.amazon.awscdk.pipelines.CodeBuildOptions synthCodeBuildDefaults) {
            this.props.synthCodeBuildDefaults(synthCodeBuildDefaults);
            return this;
        }

        /**
         * Deploy every stack by creating a change set and executing it.
         * <p>
         * When enabled, creates a "Prepare" and "Execute" action for each stack. Disable
         * to deploy the stack in one pipeline action.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param useChangeSets Deploy every stack by creating a change set and executing it. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useChangeSets(final java.lang.Boolean useChangeSets) {
            this.props.useChangeSets(useChangeSets);
            return this;
        }

        /**
         * Output directory for cdk synthesized artifacts i.e: packages/infra/cdk.out.
         * <p>
         * @return {@code this}
         * @param primarySynthDirectory Output directory for cdk synthesized artifacts i.e: packages/infra/cdk.out. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder primarySynthDirectory(final java.lang.String primarySynthDirectory) {
            this.props.primarySynthDirectory(primarySynthDirectory);
            return this;
        }

        /**
         * Name of the CodeCommit repository to create.
         * <p>
         * @return {@code this}
         * @param repositoryName Name of the CodeCommit repository to create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repositoryName(final java.lang.String repositoryName) {
            this.props.repositoryName(repositoryName);
            return this;
        }

        /**
         * Branch name prefixes Any branches created matching this list of prefixes will create a new pipeline and stack.
         * <p>
         * Default: undefined
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>
         * // Disables feature branches (default)
         * new PDKPipeline(this, 'PDKPipeline', {
         *   repositoryName: 'my-repo',
         *   branchNamePrefixes: [], // or simply exclude this line
         * }
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @param branchNamePrefixes Branch name prefixes Any branches created matching this list of prefixes will create a new pipeline and stack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder branchNamePrefixes(final java.util.List<java.lang.String> branchNamePrefixes) {
            this.props.branchNamePrefixes(branchNamePrefixes);
            return this;
        }

        /**
         * CDK command.
         * <p>
         * Override the command used to call cdk for synth and deploy.
         * <p>
         * Default: 'npx cdk'
         * <p>
         * @return {@code this}
         * @param cdkCommand CDK command. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cdkCommand(final java.lang.String cdkCommand) {
            this.props.cdkCommand(cdkCommand);
            return this;
        }

        /**
         * The directory with <code>cdk.json</code> to run cdk synth from. Set this if you enabled feature branches and <code>cdk.json</code> is not located in the parent directory of <code>primarySynthDirectory</code>.
         * <p>
         * Default: The parent directory of `primarySynthDirectory`
         * <p>
         * @return {@code this}
         * @param cdkSrcDir The directory with <code>cdk.json</code> to run cdk synth from. Set this if you enabled feature branches and <code>cdk.json</code> is not located in the parent directory of <code>primarySynthDirectory</code>. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cdkSrcDir(final java.lang.String cdkSrcDir) {
            this.props.cdkSrcDir(cdkSrcDir);
            return this;
        }

        /**
         * Possible values for a resource's Removal Policy The removal policy controls what happens to the resource if it stops being managed by CloudFormation.
         * <p>
         * @return {@code this}
         * @param codeCommitRemovalPolicy Possible values for a resource's Removal Policy The removal policy controls what happens to the resource if it stops being managed by CloudFormation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder codeCommitRemovalPolicy(final software.amazon.awscdk.RemovalPolicy codeCommitRemovalPolicy) {
            this.props.codeCommitRemovalPolicy(codeCommitRemovalPolicy);
            return this;
        }

        /**
         * Branch to trigger the pipeline execution.
         * <p>
         * Default: mainline
         * <p>
         * @return {@code this}
         * @param defaultBranchName Branch to trigger the pipeline execution. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultBranchName(final java.lang.String defaultBranchName) {
            this.props.defaultBranchName(defaultBranchName);
            return this;
        }

        /**
         * Configuration for enabling Sonarqube code scanning on a successful synth.
         * <p>
         * Default: undefined
         * <p>
         * @return {@code this}
         * @param sonarCodeScannerConfig Configuration for enabling Sonarqube code scanning on a successful synth. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sonarCodeScannerConfig(final software.aws.pdk.pipeline.SonarCodeScannerConfig sonarCodeScannerConfig) {
            this.props.sonarCodeScannerConfig(sonarCodeScannerConfig);
            return this;
        }

        /**
         * PDKPipeline by default assumes a NX Monorepo structure for it's codebase and uses sane defaults for the install and run commands.
         * <p>
         * To override these defaults
         * and/or provide additional inputs, specify env settings, etc you can provide
         * a partial ShellStepProps.
         * <p>
         * @return {@code this}
         * @param synthShellStepPartialProps PDKPipeline by default assumes a NX Monorepo structure for it's codebase and uses sane defaults for the install and run commands. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder synthShellStepPartialProps(final software.amazon.awscdk.pipelines.ShellStepProps synthShellStepPartialProps) {
            this.props.synthShellStepPartialProps(synthShellStepPartialProps);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.aws.pdk.pipeline.PDKPipeline}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.aws.pdk.pipeline.PDKPipeline build() {
            return new software.aws.pdk.pipeline.PDKPipeline(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
