package software.aws.pdk.static_website;

/**
 * Properties for configuring the StaticWebsite.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.88.0 (build eaabd08)", date = "2023-10-16T23:32:42.365Z")
@software.amazon.jsii.Jsii(module = software.aws.pdk.$Module.class, fqn = "@aws/pdk.static_website.StaticWebsiteProps")
@software.amazon.jsii.Jsii.Proxy(StaticWebsiteProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StaticWebsiteProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Path to the directory containing the static website files and assets.
     * <p>
     * This directory must contain an index.html file.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getWebsiteContentPath();

    /**
     * Custom bucket deployment properties.
     * <p>
     * <blockquote><pre>
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.aws.pdk.static_website.BucketDeploymentProps getBucketDeploymentProps() {
        return null;
    }

    /**
     * Bucket encryption to use for the default bucket.
     * <p>
     * Supported options are KMS or S3MANAGED.
     * Note: If planning to use KMS, ensure you associate a Lambda Edge function to sign requests to S3 as OAI does not currently support KMS encryption. Refer to {@link https://aws.amazon.com/blogs/networking-and-content-delivery/serving-sse-kms-encrypted-content-from-s3-using-cloudfront/}
     * <p>
     * Default: - "S3MANAGED"
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.BucketEncryption getDefaultWebsiteBucketEncryption() {
        return null;
    }

    /**
     * A predefined KMS customer encryption key to use for the default bucket that gets created.
     * <p>
     * Note: This is only used if the websiteBucket is left undefined, otherwise all settings from the provided websiteBucket will be used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.Key getDefaultWebsiteBucketEncryptionKey() {
        return null;
    }

    /**
     * Custom distribution properties.
     * <p>
     * Note: defaultBehaviour.origin is a required parameter, however it will not be used as this construct will wire it on your behalf.
     * You will need to pass in an instance of StaticWebsiteOrigin (NoOp) to keep the compiler happy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.aws.pdk.static_website.DistributionProps getDistributionProps() {
        return null;
    }

    /**
     * Dynamic configuration which gets resolved only during deployment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.aws.pdk.static_website.RuntimeOptions getRuntimeOptions() {
        return null;
    }

    /**
     * Limited configuration settings for the generated webAcl.
     * <p>
     * For more advanced settings, create your own ACL and pass in the webAclId as a param to distributionProps.
     * <p>
     * Note: If pass in your own ACL, make sure the SCOPE is CLOUDFRONT and it is created in us-east-1.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.aws.pdk.static_website.CloudFrontWebAclProps getWebAclProps() {
        return null;
    }

    /**
     * Predefined bucket to deploy the website into.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.IBucket getWebsiteBucket() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link StaticWebsiteProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StaticWebsiteProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<StaticWebsiteProps> {
        java.lang.String websiteContentPath;
        software.aws.pdk.static_website.BucketDeploymentProps bucketDeploymentProps;
        software.amazon.awscdk.services.s3.BucketEncryption defaultWebsiteBucketEncryption;
        software.amazon.awscdk.services.kms.Key defaultWebsiteBucketEncryptionKey;
        software.aws.pdk.static_website.DistributionProps distributionProps;
        software.aws.pdk.static_website.RuntimeOptions runtimeOptions;
        software.aws.pdk.static_website.CloudFrontWebAclProps webAclProps;
        software.amazon.awscdk.services.s3.IBucket websiteBucket;

        /**
         * Sets the value of {@link StaticWebsiteProps#getWebsiteContentPath}
         * @param websiteContentPath Path to the directory containing the static website files and assets. This parameter is required.
         *                           This directory must contain an index.html file.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder websiteContentPath(java.lang.String websiteContentPath) {
            this.websiteContentPath = websiteContentPath;
            return this;
        }

        /**
         * Sets the value of {@link StaticWebsiteProps#getBucketDeploymentProps}
         * @param bucketDeploymentProps Custom bucket deployment properties.
         *                              <blockquote><pre>
         *                              </pre></blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketDeploymentProps(software.aws.pdk.static_website.BucketDeploymentProps bucketDeploymentProps) {
            this.bucketDeploymentProps = bucketDeploymentProps;
            return this;
        }

        /**
         * Sets the value of {@link StaticWebsiteProps#getDefaultWebsiteBucketEncryption}
         * @param defaultWebsiteBucketEncryption Bucket encryption to use for the default bucket.
         *                                       Supported options are KMS or S3MANAGED.
         *                                       
         *                                       Note: If planning to use KMS, ensure you associate a Lambda Edge function to sign requests to S3 as OAI does not currently support KMS encryption. Refer to {@link https://aws.amazon.com/blogs/networking-and-content-delivery/serving-sse-kms-encrypted-content-from-s3-using-cloudfront/}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultWebsiteBucketEncryption(software.amazon.awscdk.services.s3.BucketEncryption defaultWebsiteBucketEncryption) {
            this.defaultWebsiteBucketEncryption = defaultWebsiteBucketEncryption;
            return this;
        }

        /**
         * Sets the value of {@link StaticWebsiteProps#getDefaultWebsiteBucketEncryptionKey}
         * @param defaultWebsiteBucketEncryptionKey A predefined KMS customer encryption key to use for the default bucket that gets created.
         *                                          Note: This is only used if the websiteBucket is left undefined, otherwise all settings from the provided websiteBucket will be used.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultWebsiteBucketEncryptionKey(software.amazon.awscdk.services.kms.Key defaultWebsiteBucketEncryptionKey) {
            this.defaultWebsiteBucketEncryptionKey = defaultWebsiteBucketEncryptionKey;
            return this;
        }

        /**
         * Sets the value of {@link StaticWebsiteProps#getDistributionProps}
         * @param distributionProps Custom distribution properties.
         *                          Note: defaultBehaviour.origin is a required parameter, however it will not be used as this construct will wire it on your behalf.
         *                          You will need to pass in an instance of StaticWebsiteOrigin (NoOp) to keep the compiler happy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder distributionProps(software.aws.pdk.static_website.DistributionProps distributionProps) {
            this.distributionProps = distributionProps;
            return this;
        }

        /**
         * Sets the value of {@link StaticWebsiteProps#getRuntimeOptions}
         * @param runtimeOptions Dynamic configuration which gets resolved only during deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtimeOptions(software.aws.pdk.static_website.RuntimeOptions runtimeOptions) {
            this.runtimeOptions = runtimeOptions;
            return this;
        }

        /**
         * Sets the value of {@link StaticWebsiteProps#getWebAclProps}
         * @param webAclProps Limited configuration settings for the generated webAcl.
         *                    For more advanced settings, create your own ACL and pass in the webAclId as a param to distributionProps.
         *                    <p>
         *                    Note: If pass in your own ACL, make sure the SCOPE is CLOUDFRONT and it is created in us-east-1.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder webAclProps(software.aws.pdk.static_website.CloudFrontWebAclProps webAclProps) {
            this.webAclProps = webAclProps;
            return this;
        }

        /**
         * Sets the value of {@link StaticWebsiteProps#getWebsiteBucket}
         * @param websiteBucket Predefined bucket to deploy the website into.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder websiteBucket(software.amazon.awscdk.services.s3.IBucket websiteBucket) {
            this.websiteBucket = websiteBucket;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StaticWebsiteProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public StaticWebsiteProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link StaticWebsiteProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StaticWebsiteProps {
        private final java.lang.String websiteContentPath;
        private final software.aws.pdk.static_website.BucketDeploymentProps bucketDeploymentProps;
        private final software.amazon.awscdk.services.s3.BucketEncryption defaultWebsiteBucketEncryption;
        private final software.amazon.awscdk.services.kms.Key defaultWebsiteBucketEncryptionKey;
        private final software.aws.pdk.static_website.DistributionProps distributionProps;
        private final software.aws.pdk.static_website.RuntimeOptions runtimeOptions;
        private final software.aws.pdk.static_website.CloudFrontWebAclProps webAclProps;
        private final software.amazon.awscdk.services.s3.IBucket websiteBucket;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.websiteContentPath = software.amazon.jsii.Kernel.get(this, "websiteContentPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.bucketDeploymentProps = software.amazon.jsii.Kernel.get(this, "bucketDeploymentProps", software.amazon.jsii.NativeType.forClass(software.aws.pdk.static_website.BucketDeploymentProps.class));
            this.defaultWebsiteBucketEncryption = software.amazon.jsii.Kernel.get(this, "defaultWebsiteBucketEncryption", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.BucketEncryption.class));
            this.defaultWebsiteBucketEncryptionKey = software.amazon.jsii.Kernel.get(this, "defaultWebsiteBucketEncryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.Key.class));
            this.distributionProps = software.amazon.jsii.Kernel.get(this, "distributionProps", software.amazon.jsii.NativeType.forClass(software.aws.pdk.static_website.DistributionProps.class));
            this.runtimeOptions = software.amazon.jsii.Kernel.get(this, "runtimeOptions", software.amazon.jsii.NativeType.forClass(software.aws.pdk.static_website.RuntimeOptions.class));
            this.webAclProps = software.amazon.jsii.Kernel.get(this, "webAclProps", software.amazon.jsii.NativeType.forClass(software.aws.pdk.static_website.CloudFrontWebAclProps.class));
            this.websiteBucket = software.amazon.jsii.Kernel.get(this, "websiteBucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.websiteContentPath = java.util.Objects.requireNonNull(builder.websiteContentPath, "websiteContentPath is required");
            this.bucketDeploymentProps = builder.bucketDeploymentProps;
            this.defaultWebsiteBucketEncryption = builder.defaultWebsiteBucketEncryption;
            this.defaultWebsiteBucketEncryptionKey = builder.defaultWebsiteBucketEncryptionKey;
            this.distributionProps = builder.distributionProps;
            this.runtimeOptions = builder.runtimeOptions;
            this.webAclProps = builder.webAclProps;
            this.websiteBucket = builder.websiteBucket;
        }

        @Override
        public final java.lang.String getWebsiteContentPath() {
            return this.websiteContentPath;
        }

        @Override
        public final software.aws.pdk.static_website.BucketDeploymentProps getBucketDeploymentProps() {
            return this.bucketDeploymentProps;
        }

        @Override
        public final software.amazon.awscdk.services.s3.BucketEncryption getDefaultWebsiteBucketEncryption() {
            return this.defaultWebsiteBucketEncryption;
        }

        @Override
        public final software.amazon.awscdk.services.kms.Key getDefaultWebsiteBucketEncryptionKey() {
            return this.defaultWebsiteBucketEncryptionKey;
        }

        @Override
        public final software.aws.pdk.static_website.DistributionProps getDistributionProps() {
            return this.distributionProps;
        }

        @Override
        public final software.aws.pdk.static_website.RuntimeOptions getRuntimeOptions() {
            return this.runtimeOptions;
        }

        @Override
        public final software.aws.pdk.static_website.CloudFrontWebAclProps getWebAclProps() {
            return this.webAclProps;
        }

        @Override
        public final software.amazon.awscdk.services.s3.IBucket getWebsiteBucket() {
            return this.websiteBucket;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("websiteContentPath", om.valueToTree(this.getWebsiteContentPath()));
            if (this.getBucketDeploymentProps() != null) {
                data.set("bucketDeploymentProps", om.valueToTree(this.getBucketDeploymentProps()));
            }
            if (this.getDefaultWebsiteBucketEncryption() != null) {
                data.set("defaultWebsiteBucketEncryption", om.valueToTree(this.getDefaultWebsiteBucketEncryption()));
            }
            if (this.getDefaultWebsiteBucketEncryptionKey() != null) {
                data.set("defaultWebsiteBucketEncryptionKey", om.valueToTree(this.getDefaultWebsiteBucketEncryptionKey()));
            }
            if (this.getDistributionProps() != null) {
                data.set("distributionProps", om.valueToTree(this.getDistributionProps()));
            }
            if (this.getRuntimeOptions() != null) {
                data.set("runtimeOptions", om.valueToTree(this.getRuntimeOptions()));
            }
            if (this.getWebAclProps() != null) {
                data.set("webAclProps", om.valueToTree(this.getWebAclProps()));
            }
            if (this.getWebsiteBucket() != null) {
                data.set("websiteBucket", om.valueToTree(this.getWebsiteBucket()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws/pdk.static_website.StaticWebsiteProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StaticWebsiteProps.Jsii$Proxy that = (StaticWebsiteProps.Jsii$Proxy) o;

            if (!websiteContentPath.equals(that.websiteContentPath)) return false;
            if (this.bucketDeploymentProps != null ? !this.bucketDeploymentProps.equals(that.bucketDeploymentProps) : that.bucketDeploymentProps != null) return false;
            if (this.defaultWebsiteBucketEncryption != null ? !this.defaultWebsiteBucketEncryption.equals(that.defaultWebsiteBucketEncryption) : that.defaultWebsiteBucketEncryption != null) return false;
            if (this.defaultWebsiteBucketEncryptionKey != null ? !this.defaultWebsiteBucketEncryptionKey.equals(that.defaultWebsiteBucketEncryptionKey) : that.defaultWebsiteBucketEncryptionKey != null) return false;
            if (this.distributionProps != null ? !this.distributionProps.equals(that.distributionProps) : that.distributionProps != null) return false;
            if (this.runtimeOptions != null ? !this.runtimeOptions.equals(that.runtimeOptions) : that.runtimeOptions != null) return false;
            if (this.webAclProps != null ? !this.webAclProps.equals(that.webAclProps) : that.webAclProps != null) return false;
            return this.websiteBucket != null ? this.websiteBucket.equals(that.websiteBucket) : that.websiteBucket == null;
        }

        @Override
        public final int hashCode() {
            int result = this.websiteContentPath.hashCode();
            result = 31 * result + (this.bucketDeploymentProps != null ? this.bucketDeploymentProps.hashCode() : 0);
            result = 31 * result + (this.defaultWebsiteBucketEncryption != null ? this.defaultWebsiteBucketEncryption.hashCode() : 0);
            result = 31 * result + (this.defaultWebsiteBucketEncryptionKey != null ? this.defaultWebsiteBucketEncryptionKey.hashCode() : 0);
            result = 31 * result + (this.distributionProps != null ? this.distributionProps.hashCode() : 0);
            result = 31 * result + (this.runtimeOptions != null ? this.runtimeOptions.hashCode() : 0);
            result = 31 * result + (this.webAclProps != null ? this.webAclProps.hashCode() : 0);
            result = 31 * result + (this.websiteBucket != null ? this.websiteBucket.hashCode() : 0);
            return result;
        }
    }
}
