package software.aws.pdk.type_safe_api;

/**
 * An authorizer that uses Cognito identity or access tokens.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.88.0 (build eaabd08)", date = "2023-10-16T23:32:42.377Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.aws.pdk.$Module.class, fqn = "@aws/pdk.type_safe_api.CognitoAuthorizer")
public class CognitoAuthorizer extends software.aws.pdk.type_safe_api.Authorizer {

    protected CognitoAuthorizer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CognitoAuthorizer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CognitoAuthorizer(final @org.jetbrains.annotations.NotNull software.aws.pdk.type_safe_api.CognitoAuthorizerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Returns this authorizer with scopes applied, intended for usage in individual operations where scopes may differ on a per-operation basis.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationscopes">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationscopes</a>
     * @param authorizationScopes the scopes to apply. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.aws.pdk.type_safe_api.CognitoAuthorizer withScopes(final @org.jetbrains.annotations.NotNull java.lang.String... authorizationScopes) {
        return software.amazon.jsii.Kernel.call(this, "withScopes", software.amazon.jsii.NativeType.forClass(software.aws.pdk.type_safe_api.CognitoAuthorizer.class), java.util.Arrays.<Object>stream(authorizationScopes).toArray(Object[]::new));
    }

    /**
     * The Cognito user pools associated with this authorizer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.cognito.IUserPool> getUserPools() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "userPools", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.IUserPool.class))));
    }

    /**
     * A fluent builder for {@link software.aws.pdk.type_safe_api.CognitoAuthorizer}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.aws.pdk.type_safe_api.CognitoAuthorizer> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.aws.pdk.type_safe_api.CognitoAuthorizerProps.Builder props;

        private Builder() {
            this.props = new software.aws.pdk.type_safe_api.CognitoAuthorizerProps.Builder();
        }

        /**
         * Unique identifier for this authorizer.
         * <p>
         * @return {@code this}
         * @param authorizerId Unique identifier for this authorizer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerId(final java.lang.String authorizerId) {
            this.props.authorizerId(authorizerId);
            return this;
        }

        /**
         * The Cognito user pools associated with this authorizer.
         * <p>
         * @return {@code this}
         * @param userPools The Cognito user pools associated with this authorizer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPools(final java.util.List<? extends software.amazon.awscdk.services.cognito.IUserPool> userPools) {
            this.props.userPools(userPools);
            return this;
        }

        /**
         * A list of authorization scopes configured on the method.
         * <p>
         * When used as the default authorizer, these scopes will be
         * applied to all methods without an authorizer at the integration level.
         * <p>
         * Default: []
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationscopes">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationscopes</a>
         * @param authorizationScopes A list of authorization scopes configured on the method. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizationScopes(final java.util.List<java.lang.String> authorizationScopes) {
            this.props.authorizationScopes(authorizationScopes);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.aws.pdk.type_safe_api.CognitoAuthorizer}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.aws.pdk.type_safe_api.CognitoAuthorizer build() {
            return new software.aws.pdk.type_safe_api.CognitoAuthorizer(
                this.props.build()
            );
        }
    }
}
