package software.aws.pdk.type_safe_api;

/**
 * Configuration for the OpenAPI Generator CLI.
 * <p>
 * @see <a href="https://github.com/OpenAPITools/openapi-generator-cli#configuration">https://github.com/OpenAPITools/openapi-generator-cli#configuration</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.88.0 (build eaabd08)", date = "2023-10-16T23:32:42.452Z")
@software.amazon.jsii.Jsii(module = software.aws.pdk.$Module.class, fqn = "@aws/pdk.type_safe_api.OpenApiGeneratorCliConfig")
@software.amazon.jsii.Jsii.Proxy(OpenApiGeneratorCliConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface OpenApiGeneratorCliConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * Maven repository info for fetching the OpenAPI Generator jar.
     * <p>
     * Default: public maven repository
     * <p>
     * @see <a href="https://github.com/OpenAPITools/openapi-generator-cli#using-custom--private-maven-registry">https://github.com/OpenAPITools/openapi-generator-cli#using-custom--private-maven-registry</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.aws.pdk.type_safe_api.OpenApiGeneratorCliConfigRepository getRepository() {
        return null;
    }

    /**
     * The directory in which OpenAPI Generator jars are cached.
     * <p>
     * Default: ~/.open-api-generator-cli
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStorageDir() {
        return null;
    }

    /**
     * Use docker instead of your locally installed Java version.
     * <p>
     * Default: false
     * <p>
     * @see <a href="https://github.com/OpenAPITools/openapi-generator-cli#use-docker-instead-of-running-java-locally">https://github.com/OpenAPITools/openapi-generator-cli#use-docker-instead-of-running-java-locally</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getUseDocker() {
        return null;
    }

    /**
     * OpenAPI Generator version to use.
     * <p>
     * Edit with caution - using the non-default
     * version may result in broken generated code.
     * <p>
     * Default: 6.3.0
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVersion() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link OpenApiGeneratorCliConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link OpenApiGeneratorCliConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<OpenApiGeneratorCliConfig> {
        software.aws.pdk.type_safe_api.OpenApiGeneratorCliConfigRepository repository;
        java.lang.String storageDir;
        java.lang.Boolean useDocker;
        java.lang.String version;

        /**
         * Sets the value of {@link OpenApiGeneratorCliConfig#getRepository}
         * @param repository Maven repository info for fetching the OpenAPI Generator jar.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repository(software.aws.pdk.type_safe_api.OpenApiGeneratorCliConfigRepository repository) {
            this.repository = repository;
            return this;
        }

        /**
         * Sets the value of {@link OpenApiGeneratorCliConfig#getStorageDir}
         * @param storageDir The directory in which OpenAPI Generator jars are cached.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageDir(java.lang.String storageDir) {
            this.storageDir = storageDir;
            return this;
        }

        /**
         * Sets the value of {@link OpenApiGeneratorCliConfig#getUseDocker}
         * @param useDocker Use docker instead of your locally installed Java version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useDocker(java.lang.Boolean useDocker) {
            this.useDocker = useDocker;
            return this;
        }

        /**
         * Sets the value of {@link OpenApiGeneratorCliConfig#getVersion}
         * @param version OpenAPI Generator version to use.
         *                Edit with caution - using the non-default
         *                version may result in broken generated code.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder version(java.lang.String version) {
            this.version = version;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link OpenApiGeneratorCliConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public OpenApiGeneratorCliConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link OpenApiGeneratorCliConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OpenApiGeneratorCliConfig {
        private final software.aws.pdk.type_safe_api.OpenApiGeneratorCliConfigRepository repository;
        private final java.lang.String storageDir;
        private final java.lang.Boolean useDocker;
        private final java.lang.String version;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.repository = software.amazon.jsii.Kernel.get(this, "repository", software.amazon.jsii.NativeType.forClass(software.aws.pdk.type_safe_api.OpenApiGeneratorCliConfigRepository.class));
            this.storageDir = software.amazon.jsii.Kernel.get(this, "storageDir", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.useDocker = software.amazon.jsii.Kernel.get(this, "useDocker", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.repository = builder.repository;
            this.storageDir = builder.storageDir;
            this.useDocker = builder.useDocker;
            this.version = builder.version;
        }

        @Override
        public final software.aws.pdk.type_safe_api.OpenApiGeneratorCliConfigRepository getRepository() {
            return this.repository;
        }

        @Override
        public final java.lang.String getStorageDir() {
            return this.storageDir;
        }

        @Override
        public final java.lang.Boolean getUseDocker() {
            return this.useDocker;
        }

        @Override
        public final java.lang.String getVersion() {
            return this.version;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getRepository() != null) {
                data.set("repository", om.valueToTree(this.getRepository()));
            }
            if (this.getStorageDir() != null) {
                data.set("storageDir", om.valueToTree(this.getStorageDir()));
            }
            if (this.getUseDocker() != null) {
                data.set("useDocker", om.valueToTree(this.getUseDocker()));
            }
            if (this.getVersion() != null) {
                data.set("version", om.valueToTree(this.getVersion()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws/pdk.type_safe_api.OpenApiGeneratorCliConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            OpenApiGeneratorCliConfig.Jsii$Proxy that = (OpenApiGeneratorCliConfig.Jsii$Proxy) o;

            if (this.repository != null ? !this.repository.equals(that.repository) : that.repository != null) return false;
            if (this.storageDir != null ? !this.storageDir.equals(that.storageDir) : that.storageDir != null) return false;
            if (this.useDocker != null ? !this.useDocker.equals(that.useDocker) : that.useDocker != null) return false;
            return this.version != null ? this.version.equals(that.version) : that.version == null;
        }

        @Override
        public final int hashCode() {
            int result = this.repository != null ? this.repository.hashCode() : 0;
            result = 31 * result + (this.storageDir != null ? this.storageDir.hashCode() : 0);
            result = 31 * result + (this.useDocker != null ? this.useDocker.hashCode() : 0);
            result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
            return result;
        }
    }
}
