package software.aws.pdk.type_safe_api;

/**
 * Maven repository info for fetching the OpenAPI Generator jar.
 * <p>
 * @see <a href="https://github.com/OpenAPITools/openapi-generator-cli#using-custom--private-maven-registry">https://github.com/OpenAPITools/openapi-generator-cli#using-custom--private-maven-registry</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.88.0 (build eaabd08)", date = "2023-10-16T23:32:42.452Z")
@software.amazon.jsii.Jsii(module = software.aws.pdk.$Module.class, fqn = "@aws/pdk.type_safe_api.OpenApiGeneratorCliConfigRepository")
@software.amazon.jsii.Jsii.Proxy(OpenApiGeneratorCliConfigRepository.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface OpenApiGeneratorCliConfigRepository extends software.amazon.jsii.JsiiSerializable {

    /**
     * Maven repository URL for downloading the OpenAPI Generator jar.
     * <p>
     * This must specify the full url, and can include placeholders for the groupId, artifactId and versionName.
     * For example: https://private.maven.intern/maven2/${groupId}/${artifactId}/${versionName}/${artifactId}-${versionName}.jar
     * <p>
     * @see <a href="https://github.com/OpenAPITools/openapi-generator-cli#using-custom--private-maven-registry">https://github.com/OpenAPITools/openapi-generator-cli#using-custom--private-maven-registry</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDownloadUrl();

    /**
     * @return a {@link Builder} of {@link OpenApiGeneratorCliConfigRepository}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link OpenApiGeneratorCliConfigRepository}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<OpenApiGeneratorCliConfigRepository> {
        java.lang.String downloadUrl;

        /**
         * Sets the value of {@link OpenApiGeneratorCliConfigRepository#getDownloadUrl}
         * @param downloadUrl Maven repository URL for downloading the OpenAPI Generator jar. This parameter is required.
         *                    This must specify the full url, and can include placeholders for the groupId, artifactId and versionName.
         *                    For example: https://private.maven.intern/maven2/${groupId}/${artifactId}/${versionName}/${artifactId}-${versionName}.jar
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder downloadUrl(java.lang.String downloadUrl) {
            this.downloadUrl = downloadUrl;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link OpenApiGeneratorCliConfigRepository}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public OpenApiGeneratorCliConfigRepository build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link OpenApiGeneratorCliConfigRepository}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OpenApiGeneratorCliConfigRepository {
        private final java.lang.String downloadUrl;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.downloadUrl = software.amazon.jsii.Kernel.get(this, "downloadUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.downloadUrl = java.util.Objects.requireNonNull(builder.downloadUrl, "downloadUrl is required");
        }

        @Override
        public final java.lang.String getDownloadUrl() {
            return this.downloadUrl;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("downloadUrl", om.valueToTree(this.getDownloadUrl()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws/pdk.type_safe_api.OpenApiGeneratorCliConfigRepository"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            OpenApiGeneratorCliConfigRepository.Jsii$Proxy that = (OpenApiGeneratorCliConfigRepository.Jsii$Proxy) o;

            return this.downloadUrl.equals(that.downloadUrl);
        }

        @Override
        public final int hashCode() {
            int result = this.downloadUrl.hashCode();
            return result;
        }
    }
}
