package software.aws.pdk.type_safe_api;

/**
 * Configuration for generated runtime projects.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.88.0 (build eaabd08)", date = "2023-10-16T23:32:42.461Z")
@software.amazon.jsii.Jsii(module = software.aws.pdk.$Module.class, fqn = "@aws/pdk.type_safe_api.RuntimeConfiguration")
@software.amazon.jsii.Jsii.Proxy(RuntimeConfiguration.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RuntimeConfiguration extends software.amazon.jsii.JsiiSerializable {

    /**
     * The languages that runtime projects will be generated in.
     * <p>
     * These projects can be used to provide type safety for
     * both client and server projects.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.aws.pdk.type_safe_api.Language> getLanguages();

    /**
     * Options for the generated runtimes.
     * <p>
     * Note that only options provided for the specified languages will apply.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.aws.pdk.type_safe_api.GeneratedRuntimeCodeOptions getOptions() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link RuntimeConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RuntimeConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RuntimeConfiguration> {
        java.util.List<software.aws.pdk.type_safe_api.Language> languages;
        software.aws.pdk.type_safe_api.GeneratedRuntimeCodeOptions options;

        /**
         * Sets the value of {@link RuntimeConfiguration#getLanguages}
         * @param languages The languages that runtime projects will be generated in. This parameter is required.
         *                  These projects can be used to provide type safety for
         *                  both client and server projects.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder languages(java.util.List<? extends software.aws.pdk.type_safe_api.Language> languages) {
            this.languages = (java.util.List<software.aws.pdk.type_safe_api.Language>)languages;
            return this;
        }

        /**
         * Sets the value of {@link RuntimeConfiguration#getOptions}
         * @param options Options for the generated runtimes.
         *                Note that only options provided for the specified languages will apply.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder options(software.aws.pdk.type_safe_api.GeneratedRuntimeCodeOptions options) {
            this.options = options;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RuntimeConfiguration}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RuntimeConfiguration build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RuntimeConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuntimeConfiguration {
        private final java.util.List<software.aws.pdk.type_safe_api.Language> languages;
        private final software.aws.pdk.type_safe_api.GeneratedRuntimeCodeOptions options;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.languages = software.amazon.jsii.Kernel.get(this, "languages", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.aws.pdk.type_safe_api.Language.class)));
            this.options = software.amazon.jsii.Kernel.get(this, "options", software.amazon.jsii.NativeType.forClass(software.aws.pdk.type_safe_api.GeneratedRuntimeCodeOptions.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.languages = (java.util.List<software.aws.pdk.type_safe_api.Language>)java.util.Objects.requireNonNull(builder.languages, "languages is required");
            this.options = builder.options;
        }

        @Override
        public final java.util.List<software.aws.pdk.type_safe_api.Language> getLanguages() {
            return this.languages;
        }

        @Override
        public final software.aws.pdk.type_safe_api.GeneratedRuntimeCodeOptions getOptions() {
            return this.options;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("languages", om.valueToTree(this.getLanguages()));
            if (this.getOptions() != null) {
                data.set("options", om.valueToTree(this.getOptions()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws/pdk.type_safe_api.RuntimeConfiguration"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RuntimeConfiguration.Jsii$Proxy that = (RuntimeConfiguration.Jsii$Proxy) o;

            if (!languages.equals(that.languages)) return false;
            return this.options != null ? this.options.equals(that.options) : that.options == null;
        }

        @Override
        public final int hashCode() {
            int result = this.languages.hashCode();
            result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
            return result;
        }
    }
}
