package software.aws.pdk.aws_arch;

/**
 * AwsResource class provides an interface for normalizing resource metadata between mapped systems.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.91.0 (build 1b1f239)", date = "2023-12-15T00:34:13.642Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.aws.pdk.$Module.class, fqn = "@aws/pdk.aws_arch.AwsResource")
public class AwsResource extends software.amazon.jsii.JsiiObject {

    protected AwsResource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AwsResource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Find {@link AwsResource} associated with given value.
     * <p>
     * @param value - The value to match {@link AwsResource};. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.Nullable software.aws.pdk.aws_arch.AwsResource findResource(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.aws.pdk.aws_arch.AwsResource.class, "findResource", software.amazon.jsii.NativeType.forClass(software.aws.pdk.aws_arch.AwsResource.class), new Object[] { java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Get {@link AwsResource} by CloudFormation resource type.
     * <p>
     * @param cfnResourceType <ul><li>Fully qualifief CloudFormation resource type (eg: AWS:S3:Bucket).</li></ul> This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.aws.pdk.aws_arch.AwsResource getResource(final @org.jetbrains.annotations.NotNull java.lang.String cfnResourceType) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.aws.pdk.aws_arch.AwsResource.class, "getResource", software.amazon.jsii.NativeType.forClass(software.aws.pdk.aws_arch.AwsResource.class), new Object[] { java.util.Objects.requireNonNull(cfnResourceType, "cfnResourceType is required") });
    }

    /**
     * Gets the draiwio style for the resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.aws.pdk.aws_arch.AwsDrawioShapeStyle drawioStyle() {
        return software.amazon.jsii.Kernel.call(this, "drawioStyle", software.amazon.jsii.NativeType.forClass(software.aws.pdk.aws_arch.AwsDrawioShapeStyle.class));
    }

    /**
     * Gets the category icon for the resource.
     * <p>
     * This maybe different than {@link AwsResource.service.category.icon } based on mappings overrides, which
     * if do not exist will fallback to {@link AwsResource.service.category.icon }.
     * <p>
     * @return Returns relative asset icon path
     * @see <a href="{@link AwsService.icon }">{@link AwsService.icon }</a>
     * @param format <ul><li>The format of icon.</li></ul> This parameter is required.
     * @param theme <ul><li>Optional theme.</li></ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCategoryIcon(final @org.jetbrains.annotations.NotNull java.lang.String format, final @org.jetbrains.annotations.Nullable java.lang.String theme) {
        return software.amazon.jsii.Kernel.call(this, "getCategoryIcon", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(format, "format is required"), theme });
    }

    /**
     * Gets the category icon for the resource.
     * <p>
     * This maybe different than {@link AwsResource.service.category.icon } based on mappings overrides, which
     * if do not exist will fallback to {@link AwsResource.service.category.icon }.
     * <p>
     * @return Returns relative asset icon path
     * @see <a href="{@link AwsService.icon }">{@link AwsService.icon }</a>
     * @param format <ul><li>The format of icon.</li></ul> This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCategoryIcon(final @org.jetbrains.annotations.NotNull java.lang.String format) {
        return software.amazon.jsii.Kernel.call(this, "getCategoryIcon", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(format, "format is required") });
    }

    /**
     * Gets the general icon for the resource if available.
     * <p>
     * @return Returns relative asset icon path or undefined if does not have general icon
     * @param format <ul><li>The format of icon.</li></ul> This parameter is required.
     * @param theme <ul><li>Optional theme.</li></ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getGeneralIcon(final @org.jetbrains.annotations.NotNull java.lang.String format, final @org.jetbrains.annotations.Nullable java.lang.String theme) {
        return software.amazon.jsii.Kernel.call(this, "getGeneralIcon", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(format, "format is required"), theme });
    }

    /**
     * Gets the general icon for the resource if available.
     * <p>
     * @return Returns relative asset icon path or undefined if does not have general icon
     * @param format <ul><li>The format of icon.</li></ul> This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getGeneralIcon(final @org.jetbrains.annotations.NotNull java.lang.String format) {
        return software.amazon.jsii.Kernel.call(this, "getGeneralIcon", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(format, "format is required") });
    }

    /**
     * Gets the resource specific icon for the resource.
     * <p>
     * @return Returns relative asset icon path or undefined if does not have resource icon
     * @param format <ul><li>The format of icon.</li></ul> This parameter is required.
     * @param theme <ul><li>Optional theme.</li></ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getResourceIcon(final @org.jetbrains.annotations.NotNull java.lang.String format, final @org.jetbrains.annotations.Nullable java.lang.String theme) {
        return software.amazon.jsii.Kernel.call(this, "getResourceIcon", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(format, "format is required"), theme });
    }

    /**
     * Gets the resource specific icon for the resource.
     * <p>
     * @return Returns relative asset icon path or undefined if does not have resource icon
     * @param format <ul><li>The format of icon.</li></ul> This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getResourceIcon(final @org.jetbrains.annotations.NotNull java.lang.String format) {
        return software.amazon.jsii.Kernel.call(this, "getResourceIcon", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(format, "format is required") });
    }

    /**
     * Gets the service icon for the resource.
     * <p>
     * This maybe different than {@link AwsResource.service.icon } based on mappings overrides, which
     * if do not exist will fallback to {@link AwsResource.service.icon }.
     * <p>
     * @return Returns relative asset icon path
     * @see <a href="{@link AwsService.icon }">{@link AwsService.icon }</a>
     * @param format <ul><li>The format of icon.</li></ul> This parameter is required.
     * @param theme <ul><li>Optional theme.</li></ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getServiceIcon(final @org.jetbrains.annotations.NotNull java.lang.String format, final @org.jetbrains.annotations.Nullable java.lang.String theme) {
        return software.amazon.jsii.Kernel.call(this, "getServiceIcon", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(format, "format is required"), theme });
    }

    /**
     * Gets the service icon for the resource.
     * <p>
     * This maybe different than {@link AwsResource.service.icon } based on mappings overrides, which
     * if do not exist will fallback to {@link AwsResource.service.icon }.
     * <p>
     * @return Returns relative asset icon path
     * @see <a href="{@link AwsService.icon }">{@link AwsService.icon }</a>
     * @param format <ul><li>The format of icon.</li></ul> This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getServiceIcon(final @org.jetbrains.annotations.NotNull java.lang.String format) {
        return software.amazon.jsii.Kernel.call(this, "getServiceIcon", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(format, "format is required") });
    }

    /**
     * Gets the best icon match for the resource following the order of: 1.
     * <p>
     * explicit resource icon
     * 2. general icon
     * 3. service icon
     * <p>
     * @return Returns relative asset icon path
     * @param format <ul><li>The format of icon.</li></ul> This parameter is required.
     * @param theme <ul><li>Optional theme.</li></ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String icon(final @org.jetbrains.annotations.NotNull java.lang.String format, final @org.jetbrains.annotations.Nullable java.lang.String theme) {
        return software.amazon.jsii.Kernel.call(this, "icon", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(format, "format is required"), theme });
    }

    /**
     * Gets the best icon match for the resource following the order of: 1.
     * <p>
     * explicit resource icon
     * 2. general icon
     * 3. service icon
     * <p>
     * @return Returns relative asset icon path
     * @param format <ul><li>The format of icon.</li></ul> This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String icon(final @org.jetbrains.annotations.NotNull java.lang.String format) {
        return software.amazon.jsii.Kernel.call(this, "icon", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(format, "format is required") });
    }

    /**
     * Get record of all resources keyed by resource id.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, software.aws.pdk.aws_arch.AwsResource> getResources() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.JsiiObject.jsiiStaticGet(software.aws.pdk.aws_arch.AwsResource.class, "resources", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.aws.pdk.aws_arch.AwsResource.class))));
    }

    /**
     * Fully-qualified CloudFormation resource type (eg: "AWS:S3:Bucket").
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getCfnResourceType() {
        return software.amazon.jsii.Kernel.get(this, "cfnResourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The {@link AwsService} the resource belongs to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.aws.pdk.aws_arch.AwsService getService() {
        return software.amazon.jsii.Kernel.get(this, "service", software.amazon.jsii.NativeType.forClass(software.aws.pdk.aws_arch.AwsService.class));
    }

    /**
     * The drawio shape mapped to this resource, or undefined if no mapping.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.aws.pdk.aws_arch.aws_arch.drawio_spec.aws4.ShapeNames getDrawioShape() {
        return software.amazon.jsii.Kernel.get(this, "drawioShape", software.amazon.jsii.NativeType.forClass(software.aws.pdk.aws_arch.aws_arch.drawio_spec.aws4.ShapeNames.class));
    }

    /**
     * The proper full name of the resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * "Bucket", "Amazon S3 on Outposts"
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getFullName() {
        return software.amazon.jsii.Kernel.get(this, "fullName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
