package software.aws.pdk.aws_arch;

/**
 * AwsService class provides an interface for normalizing service metadata between mapped systems.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.91.0 (build 1b1f239)", date = "2023-12-15T00:34:13.645Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.aws.pdk.$Module.class, fqn = "@aws/pdk.aws_arch.AwsService")
public class AwsService extends software.amazon.jsii.JsiiObject {

    protected AwsService(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AwsService(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Finds the {@link AwsService} associated with a given value.
     * <p>
     * @return Returns matching {@link AwsService } or `undefined` if not found
     * @param value Value to match {@link AwsService}, which can be `id`, `assetKey`, `fullName`, etc. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.Nullable software.aws.pdk.aws_arch.AwsService findService(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.aws.pdk.aws_arch.AwsService.class, "findService", software.amazon.jsii.NativeType.forClass(software.aws.pdk.aws_arch.AwsService.class), new Object[] { java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Get {@link AwsService} by CloudFormation "service" name, where service name is expressed as `<provider>::<service>::<resource>`.
     * <p>
     * @return Returns the {@link AwsService } associated with the `cfnService` provided
     * @param cfnService The service name to retrieve {@link AwsService} for. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.aws.pdk.aws_arch.AwsService getService(final @org.jetbrains.annotations.NotNull java.lang.String cfnService) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.aws.pdk.aws_arch.AwsService.class, "getService", software.amazon.jsii.NativeType.forClass(software.aws.pdk.aws_arch.AwsService.class), new Object[] { java.util.Objects.requireNonNull(cfnService, "cfnService is required") });
    }

    /**
     * Get drawio style for this service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.aws.pdk.aws_arch.AwsDrawioResourceIconStyle drawioStyle() {
        return software.amazon.jsii.Kernel.call(this, "drawioStyle", software.amazon.jsii.NativeType.forClass(software.aws.pdk.aws_arch.AwsDrawioResourceIconStyle.class));
    }

    /**
     * Get relative asset icon for the service for a given format and optional theme.
     * <p>
     * @return Returns relative asset icon path
     * @param format <ul><li>The format of icon.</li></ul> This parameter is required.
     * @param theme <ul><li>Optional theme.</li></ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String icon(final @org.jetbrains.annotations.NotNull java.lang.String format, final @org.jetbrains.annotations.Nullable java.lang.String theme) {
        return software.amazon.jsii.Kernel.call(this, "icon", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(format, "format is required"), theme });
    }

    /**
     * Get relative asset icon for the service for a given format and optional theme.
     * <p>
     * @return Returns relative asset icon path
     * @param format <ul><li>The format of icon.</li></ul> This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String icon(final @org.jetbrains.annotations.NotNull java.lang.String format) {
        return software.amazon.jsii.Kernel.call(this, "icon", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(format, "format is required") });
    }

    /**
     * List all resources of this service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.aws.pdk.aws_arch.AwsResource> serviceResources() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "serviceResources", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.aws.pdk.aws_arch.AwsResource.class))));
    }

    /**
     * Get record of all {@link AwsService}s keyed by `id`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, software.aws.pdk.aws_arch.AwsService> getServices() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.JsiiObject.jsiiStaticGet(software.aws.pdk.aws_arch.AwsService.class, "services", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.aws.pdk.aws_arch.AwsService.class))));
    }

    /**
     * The CloudFormation "provider" for the service, as expressed by <code>&lt;provicer&gt;::&lt;service&gt;::&lt;resource&gt;</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getCfnProvider() {
        return software.amazon.jsii.Kernel.get(this, "cfnProvider", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The CloudFormation "service" for the service, as expressed by <code>&lt;provicer&gt;::&lt;service&gt;::&lt;resource&gt;</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getCfnService() {
        return software.amazon.jsii.Kernel.get(this, "cfnService", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The proper full name of the service.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * "AWS Glue", "Amazon S3"
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFullName() {
        return software.amazon.jsii.Kernel.get(this, "fullName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The category the service belongs to, or undefined if does not belong to a category.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.aws.pdk.aws_arch.AwsCategory getCategory() {
        return software.amazon.jsii.Kernel.get(this, "category", software.amazon.jsii.NativeType.forClass(software.aws.pdk.aws_arch.AwsCategory.class));
    }

    /**
     * Drawio shape associated with this service, or undefined if service not mapped to draiwio shape.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.aws.pdk.aws_arch.aws_arch.drawio_spec.aws4.ShapeNames getDrawioShape() {
        return software.amazon.jsii.Kernel.get(this, "drawioShape", software.amazon.jsii.NativeType.forClass(software.aws.pdk.aws_arch.aws_arch.drawio_spec.aws4.ShapeNames.class));
    }

    /**
     * Get service pricing metadata.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.aws.pdk.aws_arch.aws_arch.pricing_manifest.Service getPricingMetadata() {
        return software.amazon.jsii.Kernel.get(this, "pricingMetadata", software.amazon.jsii.NativeType.forClass(software.aws.pdk.aws_arch.aws_arch.pricing_manifest.Service.class));
    }

    /**
     * The pricing <code>serviceCode</code> associated with this service, or undefined if service not mapped to pricing.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPricingServiceCode() {
        return software.amazon.jsii.Kernel.get(this, "pricingServiceCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
