package software.aws.pdk.cdk_graph;

/**
 * Edge class defines a link (relationship) between nodes, as in standard <a href="https://en.wikipedia.org/wiki/Graph_theory">graph theory</a>.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.91.0 (build 1b1f239)", date = "2023-12-15T00:34:13.671Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.aws.pdk.$Module.class, fqn = "@aws/pdk.cdk_graph.Edge")
public class Edge extends software.aws.pdk.cdk_graph.BaseEntity implements software.aws.pdk.cdk_graph.ISerializableEdge {

    protected Edge(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Edge(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Edge(final @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.IEdgeProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Find all matching edges based on predicate within an EdgeChain.
     * <p>
     * @param chain This parameter is required.
     * @param predicate This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<software.aws.pdk.cdk_graph.Edge> findAllInChain(final @org.jetbrains.annotations.NotNull java.util.List<? extends java.lang.Object> chain, final @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.IEdgePredicate predicate) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.aws.pdk.cdk_graph.Edge.class, "findAllInChain", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.Edge.class)), new Object[] { java.util.Objects.requireNonNull(chain, "chain is required"), java.util.Objects.requireNonNull(predicate, "predicate is required") }));
    }

    /**
     * Find first edge matching predicate within an EdgeChain.
     * <p>
     * @param chain This parameter is required.
     * @param predicate This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.Nullable software.aws.pdk.cdk_graph.Edge findInChain(final @org.jetbrains.annotations.NotNull java.util.List<? extends java.lang.Object> chain, final @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.IEdgePredicate predicate) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.aws.pdk.cdk_graph.Edge.class, "findInChain", software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.Edge.class), new Object[] { java.util.Objects.requireNonNull(chain, "chain is required"), java.util.Objects.requireNonNull(predicate, "predicate is required") });
    }

    /**
     * Indicates if this edge is equivalent to another edge.
     * <p>
     * Edges are considered equivalent if they share same type, source, and target.
     * <p>
     * @param edge This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean isEquivalent(final @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.Edge edge) {
        return software.amazon.jsii.Kernel.call(this, "isEquivalent", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { java.util.Objects.requireNonNull(edge, "edge is required") });
    }

    /**
     * Merge an equivalent edge's data into this edge and destroy the other edge.
     * <p>
     * Used during filtering operations to consolidate equivalent edges.
     * <p>
     * @param edge <ul><li>The edge to consume.</li></ul> This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void mutateConsume(final @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.Edge edge) {
        software.amazon.jsii.Kernel.call(this, "mutateConsume", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(edge, "edge is required") });
    }

    /**
     * Destroy the edge.
     * <p>
     * Remove all references and remove from store.
     * <p>
     * @param _strict
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void mutateDestroy(final @org.jetbrains.annotations.Nullable java.lang.Boolean _strict) {
        software.amazon.jsii.Kernel.call(this, "mutateDestroy", software.amazon.jsii.NativeType.VOID, new Object[] { _strict });
    }

    /**
     * Destroy the edge.
     * <p>
     * Remove all references and remove from store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void mutateDestroy() {
        software.amazon.jsii.Kernel.call(this, "mutateDestroy", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * Change the edge <strong>direction</strong>.
     * <p>
     * @param direction This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void mutateDirection(final @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.EdgeDirectionEnum direction) {
        software.amazon.jsii.Kernel.call(this, "mutateDirection", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(direction, "direction is required") });
    }

    /**
     * Change the edge <strong>source</strong>.
     * <p>
     * @param node This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void mutateSource(final @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.Node node) {
        software.amazon.jsii.Kernel.call(this, "mutateSource", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(node, "node is required") });
    }

    /**
     * Change the edge <strong>target</strong>.
     * <p>
     * @param node This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void mutateTarget(final @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.Node node) {
        software.amazon.jsii.Kernel.call(this, "mutateTarget", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(node, "node is required") });
    }

    /**
     * Get string representation of this edge.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Indicates if edge allows destructive mutations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getAllowDestructiveMutations() {
        return software.amazon.jsii.Kernel.get(this, "allowDestructiveMutations", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * Indicates the direction in which the edge is directed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.EdgeDirectionEnum getDirection() {
        return software.amazon.jsii.Kernel.get(this, "direction", software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.EdgeDirectionEnum.class));
    }

    /**
     * Type of edge.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.EdgeTypeEnum getEdgeType() {
        return software.amazon.jsii.Kernel.get(this, "edgeType", software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.EdgeTypeEnum.class));
    }

    /**
     * Indicates if the Edge's <strong>source</strong> and <strong>target</strong> are the same, or were the same when it was created (prior to mutations).
     * <p>
     * To check whether it was originally closed, use <code>hasFlag(FlagEnum.CLOSED_EDGE)</code> instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getIsClosed() {
        return software.amazon.jsii.Kernel.get(this, "isClosed", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * Indicates if <strong>source</strong> and <strong>target</strong> nodes reside in different <em>root</em> stacks.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getIsCrossStack() {
        return software.amazon.jsii.Kernel.get(this, "isCrossStack", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * Indicates if edge is extraneous which is determined by explicitly having <em>EXTRANEOUS</em> flag added and/or being a closed loop (source===target).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getIsExtraneous() {
        return software.amazon.jsii.Kernel.get(this, "isExtraneous", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * Edge <strong>source</strong> is the node that defines the edge (tail).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.Node getSource() {
        return software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.Node.class));
    }

    /**
     * Edge <strong>target</strong> is the node being referenced by the <strong>source</strong> (head).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.Node getTarget() {
        return software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.Node.class));
    }
}
