package software.aws.pdk.cdk_graph;

/**
 * Serializable graph edge entity.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.91.0 (build 1b1f239)", date = "2023-12-15T00:34:13.738Z")
@software.amazon.jsii.Jsii(module = software.aws.pdk.$Module.class, fqn = "@aws/pdk.cdk_graph.SGEdge")
@software.amazon.jsii.Jsii.Proxy(SGEdge.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SGEdge extends software.amazon.jsii.JsiiSerializable, software.aws.pdk.cdk_graph.SGEntity {

    /**
     * Indicates the direction in which the edge is directed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.EdgeDirectionEnum getDirection();

    /**
     * Type of edge.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.EdgeTypeEnum getEdgeType();

    /**
     * UUID of edge <strong>source</strong>  node (tail).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSource();

    /**
     * UUID of edge <strong>target</strong>  node (head).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTarget();

    /**
     * @return a {@link Builder} of {@link SGEdge}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SGEdge}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SGEdge> {
        software.aws.pdk.cdk_graph.EdgeDirectionEnum direction;
        software.aws.pdk.cdk_graph.EdgeTypeEnum edgeType;
        java.lang.String source;
        java.lang.String target;
        java.lang.String uuid;
        java.util.Map<java.lang.String, java.lang.Object> attributes;
        java.util.List<software.aws.pdk.cdk_graph.FlagEnum> flags;
        java.util.List<software.constructs.MetadataEntry> metadata;
        java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Sets the value of {@link SGEdge#getDirection}
         * @param direction Indicates the direction in which the edge is directed. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder direction(software.aws.pdk.cdk_graph.EdgeDirectionEnum direction) {
            this.direction = direction;
            return this;
        }

        /**
         * Sets the value of {@link SGEdge#getEdgeType}
         * @param edgeType Type of edge. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder edgeType(software.aws.pdk.cdk_graph.EdgeTypeEnum edgeType) {
            this.edgeType = edgeType;
            return this;
        }

        /**
         * Sets the value of {@link SGEdge#getSource}
         * @param source UUID of edge <strong>source</strong>  node (tail). This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(java.lang.String source) {
            this.source = source;
            return this;
        }

        /**
         * Sets the value of {@link SGEdge#getTarget}
         * @param target UUID of edge <strong>target</strong>  node (head). This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder target(java.lang.String target) {
            this.target = target;
            return this;
        }

        /**
         * Sets the value of {@link SGEdge#getUuid}
         * @param uuid Universally unique identity. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder uuid(java.lang.String uuid) {
            this.uuid = uuid;
            return this;
        }

        /**
         * Sets the value of {@link SGEdge#getAttributes}
         * @param attributes Serializable entity attributes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder attributes(java.util.Map<java.lang.String, ? extends java.lang.Object> attributes) {
            this.attributes = (java.util.Map<java.lang.String, java.lang.Object>)attributes;
            return this;
        }

        /**
         * Sets the value of {@link SGEdge#getFlags}
         * @param flags Serializable entity flags.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder flags(java.util.List<? extends software.aws.pdk.cdk_graph.FlagEnum> flags) {
            this.flags = (java.util.List<software.aws.pdk.cdk_graph.FlagEnum>)flags;
            return this;
        }

        /**
         * Sets the value of {@link SGEdge#getMetadata}
         * @param metadata Serializable entity metadata.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder metadata(java.util.List<? extends software.constructs.MetadataEntry> metadata) {
            this.metadata = (java.util.List<software.constructs.MetadataEntry>)metadata;
            return this;
        }

        /**
         * Sets the value of {@link SGEdge#getTags}
         * @param tags Serializable entity tags.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SGEdge}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SGEdge build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SGEdge}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SGEdge {
        private final software.aws.pdk.cdk_graph.EdgeDirectionEnum direction;
        private final software.aws.pdk.cdk_graph.EdgeTypeEnum edgeType;
        private final java.lang.String source;
        private final java.lang.String target;
        private final java.lang.String uuid;
        private final java.util.Map<java.lang.String, java.lang.Object> attributes;
        private final java.util.List<software.aws.pdk.cdk_graph.FlagEnum> flags;
        private final java.util.List<software.constructs.MetadataEntry> metadata;
        private final java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.direction = software.amazon.jsii.Kernel.get(this, "direction", software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.EdgeDirectionEnum.class));
            this.edgeType = software.amazon.jsii.Kernel.get(this, "edgeType", software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.EdgeTypeEnum.class));
            this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.target = software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.uuid = software.amazon.jsii.Kernel.get(this, "uuid", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.attributes = software.amazon.jsii.Kernel.get(this, "attributes", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.flags = software.amazon.jsii.Kernel.get(this, "flags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.FlagEnum.class)));
            this.metadata = software.amazon.jsii.Kernel.get(this, "metadata", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.constructs.MetadataEntry.class)));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.direction = java.util.Objects.requireNonNull(builder.direction, "direction is required");
            this.edgeType = java.util.Objects.requireNonNull(builder.edgeType, "edgeType is required");
            this.source = java.util.Objects.requireNonNull(builder.source, "source is required");
            this.target = java.util.Objects.requireNonNull(builder.target, "target is required");
            this.uuid = java.util.Objects.requireNonNull(builder.uuid, "uuid is required");
            this.attributes = (java.util.Map<java.lang.String, java.lang.Object>)builder.attributes;
            this.flags = (java.util.List<software.aws.pdk.cdk_graph.FlagEnum>)builder.flags;
            this.metadata = (java.util.List<software.constructs.MetadataEntry>)builder.metadata;
            this.tags = builder.tags;
        }

        @Override
        public final software.aws.pdk.cdk_graph.EdgeDirectionEnum getDirection() {
            return this.direction;
        }

        @Override
        public final software.aws.pdk.cdk_graph.EdgeTypeEnum getEdgeType() {
            return this.edgeType;
        }

        @Override
        public final java.lang.String getSource() {
            return this.source;
        }

        @Override
        public final java.lang.String getTarget() {
            return this.target;
        }

        @Override
        public final java.lang.String getUuid() {
            return this.uuid;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getAttributes() {
            return this.attributes;
        }

        @Override
        public final java.util.List<software.aws.pdk.cdk_graph.FlagEnum> getFlags() {
            return this.flags;
        }

        @Override
        public final java.util.List<software.constructs.MetadataEntry> getMetadata() {
            return this.metadata;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("direction", om.valueToTree(this.getDirection()));
            data.set("edgeType", om.valueToTree(this.getEdgeType()));
            data.set("source", om.valueToTree(this.getSource()));
            data.set("target", om.valueToTree(this.getTarget()));
            data.set("uuid", om.valueToTree(this.getUuid()));
            if (this.getAttributes() != null) {
                data.set("attributes", om.valueToTree(this.getAttributes()));
            }
            if (this.getFlags() != null) {
                data.set("flags", om.valueToTree(this.getFlags()));
            }
            if (this.getMetadata() != null) {
                data.set("metadata", om.valueToTree(this.getMetadata()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws/pdk.cdk_graph.SGEdge"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SGEdge.Jsii$Proxy that = (SGEdge.Jsii$Proxy) o;

            if (!direction.equals(that.direction)) return false;
            if (!edgeType.equals(that.edgeType)) return false;
            if (!source.equals(that.source)) return false;
            if (!target.equals(that.target)) return false;
            if (!uuid.equals(that.uuid)) return false;
            if (this.attributes != null ? !this.attributes.equals(that.attributes) : that.attributes != null) return false;
            if (this.flags != null ? !this.flags.equals(that.flags) : that.flags != null) return false;
            if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.direction.hashCode();
            result = 31 * result + (this.edgeType.hashCode());
            result = 31 * result + (this.source.hashCode());
            result = 31 * result + (this.target.hashCode());
            result = 31 * result + (this.uuid.hashCode());
            result = 31 * result + (this.attributes != null ? this.attributes.hashCode() : 0);
            result = 31 * result + (this.flags != null ? this.flags.hashCode() : 0);
            result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
