package software.aws.pdk.cdk_graph_plugin_diagram;

/**
 * CdkGraphDiagramPlugin is a {@link ICdkGraphPluginCdkGraph Plugin} implementation for generating diagram artifacts from the {@link CdkGraph} framework.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.91.0 (build 1b1f239)", date = "2023-12-15T00:34:13.743Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.aws.pdk.$Module.class, fqn = "@aws/pdk.cdk_graph_plugin_diagram.CdkGraphDiagramPlugin")
public class CdkGraphDiagramPlugin extends software.amazon.jsii.JsiiObject implements software.aws.pdk.cdk_graph.ICdkGraphPlugin {

    protected CdkGraphDiagramPlugin(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CdkGraphDiagramPlugin(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        ARTIFACT_NS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.aws.pdk.cdk_graph_plugin_diagram.CdkGraphDiagramPlugin.class, "ARTIFACT_NS", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.aws.pdk.cdk_graph_plugin_diagram.CdkGraphDiagramPlugin.class, "ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        VERSION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.aws.pdk.cdk_graph_plugin_diagram.CdkGraphDiagramPlugin.class, "VERSION", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param config
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CdkGraphDiagramPlugin(final @org.jetbrains.annotations.Nullable software.aws.pdk.cdk_graph_plugin_diagram.IPluginConfig config) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { config });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CdkGraphDiagramPlugin() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Get standardized artifact file name for diagram artifacts.
     * <p>
     * @param name This parameter is required.
     * @param format This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String artifactFilename(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph_plugin_diagram.DiagramFormat format) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.aws.pdk.cdk_graph_plugin_diagram.CdkGraphDiagramPlugin.class, "artifactFilename", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required"), java.util.Objects.requireNonNull(format, "format is required") });
    }

    /**
     * Get standardized artifact id for diagram artifacts.
     * <p>
     * @param name This parameter is required.
     * @param format This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String artifactId(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph_plugin_diagram.DiagramFormat format) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.aws.pdk.cdk_graph_plugin_diagram.CdkGraphDiagramPlugin.class, "artifactId", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required"), java.util.Objects.requireNonNull(format, "format is required") });
    }

    /**
     * Get diagram artifact for a given name and format.
     * <p>
     * @param name This parameter is required.
     * @param format This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.aws.pdk.cdk_graph.CdkGraphArtifact getDiagramArtifact(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph_plugin_diagram.DiagramFormat format) {
        return software.amazon.jsii.Kernel.call(this, "getDiagramArtifact", software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.CdkGraphArtifact.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required"), java.util.Objects.requireNonNull(format, "format is required") });
    }

    /**
     * Namespace for artifacts of the diagram plugin.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String ARTIFACT_NS;

    /**
     * Fixed id of the diagram plugin.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String ID;

    /**
     * Current semantic version of the diagram plugin.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String VERSION;

    /**
     * Get diagram plugin config.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph_plugin_diagram.IPluginConfig getConfig() {
        return software.amazon.jsii.Kernel.get(this, "config", software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph_plugin_diagram.IPluginConfig.class));
    }

    /**
     * Unique identifier for this plugin.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getId() {
        return software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Plugin version.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getVersion() {
        return software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Get default dot artifact.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.aws.pdk.cdk_graph.CdkGraphArtifact getDefaultDotArtifact() {
        return software.amazon.jsii.Kernel.get(this, "defaultDotArtifact", software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.CdkGraphArtifact.class));
    }

    /**
     * Get default PNG artifact.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.aws.pdk.cdk_graph.CdkGraphArtifact getDefaultPngArtifact() {
        return software.amazon.jsii.Kernel.get(this, "defaultPngArtifact", software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.CdkGraphArtifact.class));
    }

    /**
     * List of plugins this plugin depends on, including optional semver version (eg: ["foo", "bar&#64;1.2"]).
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDependencies() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "dependencies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Binds the plugin to the CdkGraph instance.
     * <p>
     * Enables plugins to receive base configs.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.IGraphPluginBindCallback getBind() {
        return software.amazon.jsii.Kernel.get(this, "bind", software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.IGraphPluginBindCallback.class));
    }

    /**
     * Binds the plugin to the CdkGraph instance.
     * <p>
     * Enables plugins to receive base configs.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBind(final @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.IGraphPluginBindCallback value) {
        software.amazon.jsii.Kernel.set(this, "bind", java.util.Objects.requireNonNull(value, "bind is required"));
    }

    /**
     * Generate asynchronous reports based on the graph.
     * <p>
     * This is not automatically called when synthesizing CDK.
     * Developer must explicitly add <code>await graphInstance.report()</code> to the CDK bin or invoke this outside
     * of the CDK synth. In either case, the plugin receives the in-memory graph interface when invoked, as the
     * CdkGraph will deserialize the graph prior to invoking the plugin report.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.aws.pdk.cdk_graph.IGraphReportCallback getReport() {
        return software.amazon.jsii.Kernel.get(this, "report", software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.IGraphReportCallback.class));
    }

    /**
     * Generate asynchronous reports based on the graph.
     * <p>
     * This is not automatically called when synthesizing CDK.
     * Developer must explicitly add <code>await graphInstance.report()</code> to the CDK bin or invoke this outside
     * of the CDK synth. In either case, the plugin receives the in-memory graph interface when invoked, as the
     * CdkGraph will deserialize the graph prior to invoking the plugin report.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReport(final @org.jetbrains.annotations.Nullable software.aws.pdk.cdk_graph.IGraphReportCallback value) {
        software.amazon.jsii.Kernel.set(this, "report", value);
    }

    /**
     * A fluent builder for {@link software.aws.pdk.cdk_graph_plugin_diagram.CdkGraphDiagramPlugin}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.aws.pdk.cdk_graph_plugin_diagram.CdkGraphDiagramPlugin> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private software.aws.pdk.cdk_graph_plugin_diagram.IPluginConfig.Builder config;

        private Builder() {
        }

        /**
         * Default configuration to apply to all diagrams.
         * <p>
         * @return {@code this}
         * @param defaults Default configuration to apply to all diagrams. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaults(final software.aws.pdk.cdk_graph_plugin_diagram.IDiagramConfigBase defaults) {
            this.config().defaults(defaults);
            return this;
        }

        /**
         * List of diagram configurations to generate diagrams.
         * <p>
         * @return {@code this}
         * @param diagrams List of diagram configurations to generate diagrams. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder diagrams(final java.util.List<? extends software.aws.pdk.cdk_graph_plugin_diagram.IDiagramConfig> diagrams) {
            this.config().diagrams(diagrams);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.aws.pdk.cdk_graph_plugin_diagram.CdkGraphDiagramPlugin}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.aws.pdk.cdk_graph_plugin_diagram.CdkGraphDiagramPlugin build() {
            return new software.aws.pdk.cdk_graph_plugin_diagram.CdkGraphDiagramPlugin(
                this.config != null ? this.config.build() : null
            );
        }

        private software.aws.pdk.cdk_graph_plugin_diagram.IPluginConfig.Builder config() {
            if (this.config == null) {
                this.config = new software.aws.pdk.cdk_graph_plugin_diagram.IPluginConfig.Builder();
            }
            return this.config;
        }
    }
}
