package software.aws.pdk.monorepo.nx;

/**
 * @see <a href="https://nx.dev/packages/nx/documents/run-many#options">https://nx.dev/packages/nx/documents/run-many#options</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.91.0 (build 1b1f239)", date = "2023-12-15T00:34:13.981Z")
@software.amazon.jsii.Jsii(module = software.aws.pdk.$Module.class, fqn = "@aws/pdk.monorepo.Nx.RunManyOptions")
@software.amazon.jsii.Jsii.Proxy(RunManyOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RunManyOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Task to run for affected projects.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTarget();

    /**
     * This is the configuration to use when performing tasks on projects.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getConfiguration() {
        return null;
    }

    /**
     * Exclude certain projects from being processed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getExclude() {
        return null;
    }

    /**
     * Ignore cycles in the task graph.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIgnoreCycles() {
        return null;
    }

    /**
     * Do not stop command execution after the first failed task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getNoBail() {
        return null;
    }

    /**
     * Defines how Nx emits outputs tasks logs.
     * <p>
     * Default: "stream"
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOutputStyle() {
        return null;
    }

    /**
     * Max number of parallel processes.
     * <p>
     * Default: 3
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getParallel() {
        return null;
    }

    /**
     * Project to run as list project names and/or patterns.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getProjects() {
        return null;
    }

    /**
     * This is the name of the tasks runner configuration in nx.json.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRunner() {
        return null;
    }

    /**
     * Rerun the tasks even when the results are available in the cache.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSkipCache() {
        return null;
    }

    /**
     * Prints additional information about the commands (e.g. stack traces).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getVerbose() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link RunManyOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RunManyOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RunManyOptions> {
        java.lang.String target;
        java.lang.String configuration;
        java.lang.String exclude;
        java.lang.Boolean ignoreCycles;
        java.lang.Boolean noBail;
        java.lang.String outputStyle;
        java.lang.Number parallel;
        java.util.List<java.lang.String> projects;
        java.lang.String runner;
        java.lang.Boolean skipCache;
        java.lang.Boolean verbose;

        /**
         * Sets the value of {@link RunManyOptions#getTarget}
         * @param target Task to run for affected projects. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder target(java.lang.String target) {
            this.target = target;
            return this;
        }

        /**
         * Sets the value of {@link RunManyOptions#getConfiguration}
         * @param configuration This is the configuration to use when performing tasks on projects.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(java.lang.String configuration) {
            this.configuration = configuration;
            return this;
        }

        /**
         * Sets the value of {@link RunManyOptions#getExclude}
         * @param exclude Exclude certain projects from being processed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exclude(java.lang.String exclude) {
            this.exclude = exclude;
            return this;
        }

        /**
         * Sets the value of {@link RunManyOptions#getIgnoreCycles}
         * @param ignoreCycles Ignore cycles in the task graph.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ignoreCycles(java.lang.Boolean ignoreCycles) {
            this.ignoreCycles = ignoreCycles;
            return this;
        }

        /**
         * Sets the value of {@link RunManyOptions#getNoBail}
         * @param noBail Do not stop command execution after the first failed task.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder noBail(java.lang.Boolean noBail) {
            this.noBail = noBail;
            return this;
        }

        /**
         * Sets the value of {@link RunManyOptions#getOutputStyle}
         * @param outputStyle Defines how Nx emits outputs tasks logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputStyle(java.lang.String outputStyle) {
            this.outputStyle = outputStyle;
            return this;
        }

        /**
         * Sets the value of {@link RunManyOptions#getParallel}
         * @param parallel Max number of parallel processes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parallel(java.lang.Number parallel) {
            this.parallel = parallel;
            return this;
        }

        /**
         * Sets the value of {@link RunManyOptions#getProjects}
         * @param projects Project to run as list project names and/or patterns.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder projects(java.util.List<java.lang.String> projects) {
            this.projects = projects;
            return this;
        }

        /**
         * Sets the value of {@link RunManyOptions#getRunner}
         * @param runner This is the name of the tasks runner configuration in nx.json.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runner(java.lang.String runner) {
            this.runner = runner;
            return this;
        }

        /**
         * Sets the value of {@link RunManyOptions#getSkipCache}
         * @param skipCache Rerun the tasks even when the results are available in the cache.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder skipCache(java.lang.Boolean skipCache) {
            this.skipCache = skipCache;
            return this;
        }

        /**
         * Sets the value of {@link RunManyOptions#getVerbose}
         * @param verbose Prints additional information about the commands (e.g. stack traces).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder verbose(java.lang.Boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RunManyOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RunManyOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RunManyOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RunManyOptions {
        private final java.lang.String target;
        private final java.lang.String configuration;
        private final java.lang.String exclude;
        private final java.lang.Boolean ignoreCycles;
        private final java.lang.Boolean noBail;
        private final java.lang.String outputStyle;
        private final java.lang.Number parallel;
        private final java.util.List<java.lang.String> projects;
        private final java.lang.String runner;
        private final java.lang.Boolean skipCache;
        private final java.lang.Boolean verbose;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.target = software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.configuration = software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.exclude = software.amazon.jsii.Kernel.get(this, "exclude", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ignoreCycles = software.amazon.jsii.Kernel.get(this, "ignoreCycles", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.noBail = software.amazon.jsii.Kernel.get(this, "noBail", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.outputStyle = software.amazon.jsii.Kernel.get(this, "outputStyle", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.parallel = software.amazon.jsii.Kernel.get(this, "parallel", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.projects = software.amazon.jsii.Kernel.get(this, "projects", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.runner = software.amazon.jsii.Kernel.get(this, "runner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.skipCache = software.amazon.jsii.Kernel.get(this, "skipCache", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.verbose = software.amazon.jsii.Kernel.get(this, "verbose", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.target = java.util.Objects.requireNonNull(builder.target, "target is required");
            this.configuration = builder.configuration;
            this.exclude = builder.exclude;
            this.ignoreCycles = builder.ignoreCycles;
            this.noBail = builder.noBail;
            this.outputStyle = builder.outputStyle;
            this.parallel = builder.parallel;
            this.projects = builder.projects;
            this.runner = builder.runner;
            this.skipCache = builder.skipCache;
            this.verbose = builder.verbose;
        }

        @Override
        public final java.lang.String getTarget() {
            return this.target;
        }

        @Override
        public final java.lang.String getConfiguration() {
            return this.configuration;
        }

        @Override
        public final java.lang.String getExclude() {
            return this.exclude;
        }

        @Override
        public final java.lang.Boolean getIgnoreCycles() {
            return this.ignoreCycles;
        }

        @Override
        public final java.lang.Boolean getNoBail() {
            return this.noBail;
        }

        @Override
        public final java.lang.String getOutputStyle() {
            return this.outputStyle;
        }

        @Override
        public final java.lang.Number getParallel() {
            return this.parallel;
        }

        @Override
        public final java.util.List<java.lang.String> getProjects() {
            return this.projects;
        }

        @Override
        public final java.lang.String getRunner() {
            return this.runner;
        }

        @Override
        public final java.lang.Boolean getSkipCache() {
            return this.skipCache;
        }

        @Override
        public final java.lang.Boolean getVerbose() {
            return this.verbose;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("target", om.valueToTree(this.getTarget()));
            if (this.getConfiguration() != null) {
                data.set("configuration", om.valueToTree(this.getConfiguration()));
            }
            if (this.getExclude() != null) {
                data.set("exclude", om.valueToTree(this.getExclude()));
            }
            if (this.getIgnoreCycles() != null) {
                data.set("ignoreCycles", om.valueToTree(this.getIgnoreCycles()));
            }
            if (this.getNoBail() != null) {
                data.set("noBail", om.valueToTree(this.getNoBail()));
            }
            if (this.getOutputStyle() != null) {
                data.set("outputStyle", om.valueToTree(this.getOutputStyle()));
            }
            if (this.getParallel() != null) {
                data.set("parallel", om.valueToTree(this.getParallel()));
            }
            if (this.getProjects() != null) {
                data.set("projects", om.valueToTree(this.getProjects()));
            }
            if (this.getRunner() != null) {
                data.set("runner", om.valueToTree(this.getRunner()));
            }
            if (this.getSkipCache() != null) {
                data.set("skipCache", om.valueToTree(this.getSkipCache()));
            }
            if (this.getVerbose() != null) {
                data.set("verbose", om.valueToTree(this.getVerbose()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws/pdk.monorepo.Nx.RunManyOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RunManyOptions.Jsii$Proxy that = (RunManyOptions.Jsii$Proxy) o;

            if (!target.equals(that.target)) return false;
            if (this.configuration != null ? !this.configuration.equals(that.configuration) : that.configuration != null) return false;
            if (this.exclude != null ? !this.exclude.equals(that.exclude) : that.exclude != null) return false;
            if (this.ignoreCycles != null ? !this.ignoreCycles.equals(that.ignoreCycles) : that.ignoreCycles != null) return false;
            if (this.noBail != null ? !this.noBail.equals(that.noBail) : that.noBail != null) return false;
            if (this.outputStyle != null ? !this.outputStyle.equals(that.outputStyle) : that.outputStyle != null) return false;
            if (this.parallel != null ? !this.parallel.equals(that.parallel) : that.parallel != null) return false;
            if (this.projects != null ? !this.projects.equals(that.projects) : that.projects != null) return false;
            if (this.runner != null ? !this.runner.equals(that.runner) : that.runner != null) return false;
            if (this.skipCache != null ? !this.skipCache.equals(that.skipCache) : that.skipCache != null) return false;
            return this.verbose != null ? this.verbose.equals(that.verbose) : that.verbose == null;
        }

        @Override
        public final int hashCode() {
            int result = this.target.hashCode();
            result = 31 * result + (this.configuration != null ? this.configuration.hashCode() : 0);
            result = 31 * result + (this.exclude != null ? this.exclude.hashCode() : 0);
            result = 31 * result + (this.ignoreCycles != null ? this.ignoreCycles.hashCode() : 0);
            result = 31 * result + (this.noBail != null ? this.noBail.hashCode() : 0);
            result = 31 * result + (this.outputStyle != null ? this.outputStyle.hashCode() : 0);
            result = 31 * result + (this.parallel != null ? this.parallel.hashCode() : 0);
            result = 31 * result + (this.projects != null ? this.projects.hashCode() : 0);
            result = 31 * result + (this.runner != null ? this.runner.hashCode() : 0);
            result = 31 * result + (this.skipCache != null ? this.skipCache.hashCode() : 0);
            result = 31 * result + (this.verbose != null ? this.verbose.hashCode() : 0);
            return result;
        }
    }
}
