package software.aws.pdk.static_website;

/**
 * Dynamic configuration which gets resolved only during deployment.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Will store a JSON file called runtime-config.json in the root of the StaticWebsite S3 bucket containing any
 * // and all resolved values.
 * const runtimeConfig = {jsonPayload: {bucketArn: s3Bucket.bucketArn}};
 * new StaticWebsite(scope, 'StaticWebsite', {websiteContentPath: 'path/to/website', runtimeConfig});
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.91.0 (build 1b1f239)", date = "2023-12-15T00:34:14.026Z")
@software.amazon.jsii.Jsii(module = software.aws.pdk.$Module.class, fqn = "@aws/pdk.static_website.RuntimeOptions")
@software.amazon.jsii.Jsii.Proxy(RuntimeOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RuntimeOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Arbitrary JSON payload containing runtime values to deploy.
     * <p>
     * Typically this contains resourceArns, etc which
     * are only known at deploy time.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * { userPoolId: some.userPool.userPoolId, someResourceArn: some.resource.Arn }
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getJsonPayload();

    /**
     * File name to store runtime configuration (jsonPayload).
     * <p>
     * Must follow pattern: '*.json'
     * <p>
     * Default: "runtime-config.json"
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getJsonFileName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link RuntimeOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RuntimeOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RuntimeOptions> {
        java.lang.Object jsonPayload;
        java.lang.String jsonFileName;

        /**
         * Sets the value of {@link RuntimeOptions#getJsonPayload}
         * @param jsonPayload Arbitrary JSON payload containing runtime values to deploy. This parameter is required.
         *                    Typically this contains resourceArns, etc which
         *                    are only known at deploy time.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jsonPayload(java.lang.Object jsonPayload) {
            this.jsonPayload = jsonPayload;
            return this;
        }

        /**
         * Sets the value of {@link RuntimeOptions#getJsonFileName}
         * @param jsonFileName File name to store runtime configuration (jsonPayload).
         *                     Must follow pattern: '*.json'
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jsonFileName(java.lang.String jsonFileName) {
            this.jsonFileName = jsonFileName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RuntimeOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RuntimeOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RuntimeOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuntimeOptions {
        private final java.lang.Object jsonPayload;
        private final java.lang.String jsonFileName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.jsonPayload = software.amazon.jsii.Kernel.get(this, "jsonPayload", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.jsonFileName = software.amazon.jsii.Kernel.get(this, "jsonFileName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.jsonPayload = java.util.Objects.requireNonNull(builder.jsonPayload, "jsonPayload is required");
            this.jsonFileName = builder.jsonFileName;
        }

        @Override
        public final java.lang.Object getJsonPayload() {
            return this.jsonPayload;
        }

        @Override
        public final java.lang.String getJsonFileName() {
            return this.jsonFileName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("jsonPayload", om.valueToTree(this.getJsonPayload()));
            if (this.getJsonFileName() != null) {
                data.set("jsonFileName", om.valueToTree(this.getJsonFileName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws/pdk.static_website.RuntimeOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RuntimeOptions.Jsii$Proxy that = (RuntimeOptions.Jsii$Proxy) o;

            if (!jsonPayload.equals(that.jsonPayload)) return false;
            return this.jsonFileName != null ? this.jsonFileName.equals(that.jsonFileName) : that.jsonFileName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.jsonPayload.hashCode();
            result = 31 * result + (this.jsonFileName != null ? this.jsonFileName.hashCode() : 0);
            return result;
        }
    }
}
