package software.aws.pdk.static_website;

/**
 * Deploys a Static Website using by default a private S3 bucket as an origin and Cloudfront as the entrypoint.
 * <p>
 * This construct configures a webAcl containing rules that are generally applicable to web applications. This
 * provides protection against exploitation of a wide range of vulnerabilities, including some of the high risk
 * and commonly occurring vulnerabilities described in OWASP publications such as OWASP Top 10.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.91.0 (build 1b1f239)", date = "2023-12-15T00:34:14.027Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.aws.pdk.$Module.class, fqn = "@aws/pdk.static_website.StaticWebsite")
public class StaticWebsite extends software.constructs.Construct {

    protected StaticWebsite(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected StaticWebsite(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public StaticWebsite(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.aws.pdk.static_website.StaticWebsiteProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.deployment.BucketDeployment getBucketDeployment() {
        return software.amazon.jsii.Kernel.get(this, "bucketDeployment", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.deployment.BucketDeployment.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.Distribution getCloudFrontDistribution() {
        return software.amazon.jsii.Kernel.get(this, "cloudFrontDistribution", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.Distribution.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket getWebsiteBucket() {
        return software.amazon.jsii.Kernel.get(this, "websiteBucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
    }

    /**
     * A fluent builder for {@link software.aws.pdk.static_website.StaticWebsite}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.aws.pdk.static_website.StaticWebsite> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.aws.pdk.static_website.StaticWebsiteProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.aws.pdk.static_website.StaticWebsiteProps.Builder();
        }

        /**
         * Path to the directory containing the static website files and assets.
         * <p>
         * This directory must contain an index.html file.
         * <p>
         * @return {@code this}
         * @param websiteContentPath Path to the directory containing the static website files and assets. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder websiteContentPath(final java.lang.String websiteContentPath) {
            this.props.websiteContentPath(websiteContentPath);
            return this;
        }

        /**
         * Custom bucket deployment properties.
         * <p>
         * <blockquote><pre>
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @param bucketDeploymentProps Custom bucket deployment properties. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketDeploymentProps(final software.aws.pdk.static_website.BucketDeploymentProps bucketDeploymentProps) {
            this.props.bucketDeploymentProps(bucketDeploymentProps);
            return this;
        }

        /**
         * Bucket encryption to use for the default bucket.
         * <p>
         * Supported options are KMS or S3MANAGED.
         * Note: If planning to use KMS, ensure you associate a Lambda Edge function to sign requests to S3 as OAI does not currently support KMS encryption. Refer to {@link https://aws.amazon.com/blogs/networking-and-content-delivery/serving-sse-kms-encrypted-content-from-s3-using-cloudfront/}
         * <p>
         * Default: - "S3MANAGED"
         * <p>
         * @return {@code this}
         * @param defaultWebsiteBucketEncryption Bucket encryption to use for the default bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultWebsiteBucketEncryption(final software.amazon.awscdk.services.s3.BucketEncryption defaultWebsiteBucketEncryption) {
            this.props.defaultWebsiteBucketEncryption(defaultWebsiteBucketEncryption);
            return this;
        }

        /**
         * A predefined KMS customer encryption key to use for the default bucket that gets created.
         * <p>
         * Note: This is only used if the websiteBucket is left undefined, otherwise all settings from the provided websiteBucket will be used.
         * <p>
         * @return {@code this}
         * @param defaultWebsiteBucketEncryptionKey A predefined KMS customer encryption key to use for the default bucket that gets created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultWebsiteBucketEncryptionKey(final software.amazon.awscdk.services.kms.Key defaultWebsiteBucketEncryptionKey) {
            this.props.defaultWebsiteBucketEncryptionKey(defaultWebsiteBucketEncryptionKey);
            return this;
        }

        /**
         * Custom distribution properties.
         * <p>
         * Note: defaultBehaviour.origin is a required parameter, however it will not be used as this construct will wire it on your behalf.
         * You will need to pass in an instance of StaticWebsiteOrigin (NoOp) to keep the compiler happy.
         * <p>
         * @return {@code this}
         * @param distributionProps Custom distribution properties. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder distributionProps(final software.aws.pdk.static_website.DistributionProps distributionProps) {
            this.props.distributionProps(distributionProps);
            return this;
        }

        /**
         * Dynamic configuration which gets resolved only during deployment.
         * <p>
         * @return {@code this}
         * @param runtimeOptions Dynamic configuration which gets resolved only during deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtimeOptions(final software.aws.pdk.static_website.RuntimeOptions runtimeOptions) {
            this.props.runtimeOptions(runtimeOptions);
            return this;
        }

        /**
         * Limited configuration settings for the generated webAcl.
         * <p>
         * For more advanced settings, create your own ACL and pass in the webAclId as a param to distributionProps.
         * <p>
         * Note: If pass in your own ACL, make sure the SCOPE is CLOUDFRONT and it is created in us-east-1.
         * <p>
         * @return {@code this}
         * @param webAclProps Limited configuration settings for the generated webAcl. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder webAclProps(final software.aws.pdk.static_website.CloudFrontWebAclProps webAclProps) {
            this.props.webAclProps(webAclProps);
            return this;
        }

        /**
         * Predefined bucket to deploy the website into.
         * <p>
         * @return {@code this}
         * @param websiteBucket Predefined bucket to deploy the website into. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder websiteBucket(final software.amazon.awscdk.services.s3.IBucket websiteBucket) {
            this.props.websiteBucket(websiteBucket);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.aws.pdk.static_website.StaticWebsite}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.aws.pdk.static_website.StaticWebsite build() {
            return new software.aws.pdk.static_website.StaticWebsite(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
