package software.aws.pdk.type_safe_api;

/**
 * Properties for rendering an integration into an API Gateway OpenAPI extension.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.91.0 (build 1b1f239)", date = "2023-12-15T00:34:14.094Z")
@software.amazon.jsii.Jsii(module = software.aws.pdk.$Module.class, fqn = "@aws/pdk.type_safe_api.IntegrationRenderProps")
@software.amazon.jsii.Jsii.Proxy(IntegrationRenderProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IntegrationRenderProps extends software.amazon.jsii.JsiiSerializable, software.aws.pdk.type_safe_api.OperationDetails {

    /**
     * The ID of the operation being rendered.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getOperationId();

    /**
     * Details about all operations in the API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, software.aws.pdk.type_safe_api.OperationDetails> getOperationLookup();

    /**
     * The scope in which the integration is being rendered.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.constructs.Construct getScope();

    /**
     * Cross Origin Resource Sharing options for the API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.aws.pdk.type_safe_api.SerializedCorsOptions getCorsOptions() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link IntegrationRenderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link IntegrationRenderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<IntegrationRenderProps> {
        java.lang.String operationId;
        java.util.Map<java.lang.String, software.aws.pdk.type_safe_api.OperationDetails> operationLookup;
        software.constructs.Construct scope;
        software.aws.pdk.type_safe_api.SerializedCorsOptions corsOptions;
        java.util.List<java.lang.String> contentTypes;
        java.lang.String method;
        java.lang.String path;

        /**
         * Sets the value of {@link IntegrationRenderProps#getOperationId}
         * @param operationId The ID of the operation being rendered. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder operationId(java.lang.String operationId) {
            this.operationId = operationId;
            return this;
        }

        /**
         * Sets the value of {@link IntegrationRenderProps#getOperationLookup}
         * @param operationLookup Details about all operations in the API. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder operationLookup(java.util.Map<java.lang.String, ? extends software.aws.pdk.type_safe_api.OperationDetails> operationLookup) {
            this.operationLookup = (java.util.Map<java.lang.String, software.aws.pdk.type_safe_api.OperationDetails>)operationLookup;
            return this;
        }

        /**
         * Sets the value of {@link IntegrationRenderProps#getScope}
         * @param scope The scope in which the integration is being rendered. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scope(software.constructs.Construct scope) {
            this.scope = scope;
            return this;
        }

        /**
         * Sets the value of {@link IntegrationRenderProps#getCorsOptions}
         * @param corsOptions Cross Origin Resource Sharing options for the API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder corsOptions(software.aws.pdk.type_safe_api.SerializedCorsOptions corsOptions) {
            this.corsOptions = corsOptions;
            return this;
        }

        /**
         * Sets the value of {@link IntegrationRenderProps#getContentTypes}
         * @param contentTypes Content types accepted by this operation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentTypes(java.util.List<java.lang.String> contentTypes) {
            this.contentTypes = contentTypes;
            return this;
        }

        /**
         * Sets the value of {@link IntegrationRenderProps#getMethod}
         * @param method The http method of this operation. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder method(java.lang.String method) {
            this.method = method;
            return this;
        }

        /**
         * Sets the value of {@link IntegrationRenderProps#getPath}
         * @param path The path of this operation in the api. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder path(java.lang.String path) {
            this.path = path;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link IntegrationRenderProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public IntegrationRenderProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link IntegrationRenderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IntegrationRenderProps {
        private final java.lang.String operationId;
        private final java.util.Map<java.lang.String, software.aws.pdk.type_safe_api.OperationDetails> operationLookup;
        private final software.constructs.Construct scope;
        private final software.aws.pdk.type_safe_api.SerializedCorsOptions corsOptions;
        private final java.util.List<java.lang.String> contentTypes;
        private final java.lang.String method;
        private final java.lang.String path;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.operationId = software.amazon.jsii.Kernel.get(this, "operationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.operationLookup = software.amazon.jsii.Kernel.get(this, "operationLookup", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.aws.pdk.type_safe_api.OperationDetails.class)));
            this.scope = software.amazon.jsii.Kernel.get(this, "scope", software.amazon.jsii.NativeType.forClass(software.constructs.Construct.class));
            this.corsOptions = software.amazon.jsii.Kernel.get(this, "corsOptions", software.amazon.jsii.NativeType.forClass(software.aws.pdk.type_safe_api.SerializedCorsOptions.class));
            this.contentTypes = software.amazon.jsii.Kernel.get(this, "contentTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.method = software.amazon.jsii.Kernel.get(this, "method", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.operationId = java.util.Objects.requireNonNull(builder.operationId, "operationId is required");
            this.operationLookup = (java.util.Map<java.lang.String, software.aws.pdk.type_safe_api.OperationDetails>)java.util.Objects.requireNonNull(builder.operationLookup, "operationLookup is required");
            this.scope = java.util.Objects.requireNonNull(builder.scope, "scope is required");
            this.corsOptions = builder.corsOptions;
            this.contentTypes = builder.contentTypes;
            this.method = java.util.Objects.requireNonNull(builder.method, "method is required");
            this.path = java.util.Objects.requireNonNull(builder.path, "path is required");
        }

        @Override
        public final java.lang.String getOperationId() {
            return this.operationId;
        }

        @Override
        public final java.util.Map<java.lang.String, software.aws.pdk.type_safe_api.OperationDetails> getOperationLookup() {
            return this.operationLookup;
        }

        @Override
        public final software.constructs.Construct getScope() {
            return this.scope;
        }

        @Override
        public final software.aws.pdk.type_safe_api.SerializedCorsOptions getCorsOptions() {
            return this.corsOptions;
        }

        @Override
        public final java.util.List<java.lang.String> getContentTypes() {
            return this.contentTypes;
        }

        @Override
        public final java.lang.String getMethod() {
            return this.method;
        }

        @Override
        public final java.lang.String getPath() {
            return this.path;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("operationId", om.valueToTree(this.getOperationId()));
            data.set("operationLookup", om.valueToTree(this.getOperationLookup()));
            data.set("scope", om.valueToTree(this.getScope()));
            if (this.getCorsOptions() != null) {
                data.set("corsOptions", om.valueToTree(this.getCorsOptions()));
            }
            if (this.getContentTypes() != null) {
                data.set("contentTypes", om.valueToTree(this.getContentTypes()));
            }
            data.set("method", om.valueToTree(this.getMethod()));
            data.set("path", om.valueToTree(this.getPath()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws/pdk.type_safe_api.IntegrationRenderProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            IntegrationRenderProps.Jsii$Proxy that = (IntegrationRenderProps.Jsii$Proxy) o;

            if (!operationId.equals(that.operationId)) return false;
            if (!operationLookup.equals(that.operationLookup)) return false;
            if (!scope.equals(that.scope)) return false;
            if (this.corsOptions != null ? !this.corsOptions.equals(that.corsOptions) : that.corsOptions != null) return false;
            if (this.contentTypes != null ? !this.contentTypes.equals(that.contentTypes) : that.contentTypes != null) return false;
            if (!method.equals(that.method)) return false;
            return this.path.equals(that.path);
        }

        @Override
        public final int hashCode() {
            int result = this.operationId.hashCode();
            result = 31 * result + (this.operationLookup.hashCode());
            result = 31 * result + (this.scope.hashCode());
            result = 31 * result + (this.corsOptions != null ? this.corsOptions.hashCode() : 0);
            result = 31 * result + (this.contentTypes != null ? this.contentTypes.hashCode() : 0);
            result = 31 * result + (this.method.hashCode());
            result = 31 * result + (this.path.hashCode());
            return result;
        }
    }
}
