package software.aws.pdk.type_safe_api;

/**
 * A collection of integrations to connect API operations with a backend to service requests.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.91.0 (build 1b1f239)", date = "2023-12-15T00:34:14.095Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.aws.pdk.$Module.class, fqn = "@aws/pdk.type_safe_api.Integrations")
public class Integrations extends software.amazon.jsii.JsiiObject {

    protected Integrations(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Integrations(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Integrations() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * An integration that invokes a lambda function to service the request.
     * <p>
     * @param lambdaFunction the function to invoke. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.aws.pdk.type_safe_api.LambdaIntegration lambda(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction lambdaFunction) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.aws.pdk.type_safe_api.Integrations.class, "lambda", software.amazon.jsii.NativeType.forClass(software.aws.pdk.type_safe_api.LambdaIntegration.class), new Object[] { java.util.Objects.requireNonNull(lambdaFunction, "lambdaFunction is required") });
    }

    /**
     * An integration that returns a hardcoded response.
     * <p>
     * @param response the response to return. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.aws.pdk.type_safe_api.MockIntegration mock(final @org.jetbrains.annotations.NotNull software.aws.pdk.type_safe_api.MockIntegrationResponse response) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.aws.pdk.type_safe_api.Integrations.class, "mock", software.amazon.jsii.NativeType.forClass(software.aws.pdk.type_safe_api.MockIntegration.class), new Object[] { java.util.Objects.requireNonNull(response, "response is required") });
    }

    /**
     * An integration that can read/write to an S3 bucket.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/integrating-api-with-aws-services-s3.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/integrating-api-with-aws-services-s3.html</a>
     * @param props the integration props. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.aws.pdk.type_safe_api.S3Integration s3(final @org.jetbrains.annotations.NotNull software.aws.pdk.type_safe_api.S3IntegrationProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.aws.pdk.type_safe_api.Integrations.class, "s3", software.amazon.jsii.NativeType.forClass(software.aws.pdk.type_safe_api.S3Integration.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }
}
