package software.aws.pdk.type_safe_api;

/**
 * An S3 integration.
 * <p>
 * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/integrating-api-with-aws-services-s3.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/integrating-api-with-aws-services-s3.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.91.0 (build 1b1f239)", date = "2023-12-15T00:34:14.106Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.aws.pdk.$Module.class, fqn = "@aws/pdk.type_safe_api.S3Integration")
public class S3Integration extends software.aws.pdk.type_safe_api.Integration {

    protected S3Integration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected S3Integration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public S3Integration(final @org.jetbrains.annotations.NotNull software.aws.pdk.type_safe_api.S3IntegrationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Grant API Gateway permissions to invoke the S3 bucket.
     * <p>
     * @param __0 This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void grant(final @org.jetbrains.annotations.NotNull software.aws.pdk.type_safe_api.IntegrationGrantProps __0) {
        software.amazon.jsii.Kernel.call(this, "grant", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(__0, "__0 is required") });
    }

    /**
     * Render the S3 integration as a snippet of OpenAPI.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.aws.pdk.type_safe_api.ApiGatewayIntegration render(final @org.jetbrains.annotations.NotNull software.aws.pdk.type_safe_api.IntegrationRenderProps props) {
        return software.amazon.jsii.Kernel.call(this, "render", software.amazon.jsii.NativeType.forClass(software.aws.pdk.type_safe_api.ApiGatewayIntegration.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A fluent builder for {@link software.aws.pdk.type_safe_api.S3Integration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.aws.pdk.type_safe_api.S3Integration> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.aws.pdk.type_safe_api.S3IntegrationProps.Builder props;

        private Builder() {
            this.props = new software.aws.pdk.type_safe_api.S3IntegrationProps.Builder();
        }

        /**
         * The S3 bucket to be invoked on integration.
         * <p>
         * @return {@code this}
         * @param bucket The S3 bucket to be invoked on integration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucket(final software.amazon.awscdk.services.s3.IBucket bucket) {
            this.props.bucket(bucket);
            return this;
        }

        /**
         * Override the integration response set for the S3 integration.
         * <p>
         * Default: - a combination of IntegrationResponseSets.defaultPassthrough() and IntegrationResponseSets.s3JsonErrorMessage()
         * <p>
         * @return {@code this}
         * @param integrationResponseSet Override the integration response set for the S3 integration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationResponseSet(final software.aws.pdk.type_safe_api.IntegrationResponseSet integrationResponseSet) {
            this.props.integrationResponseSet(integrationResponseSet);
            return this;
        }

        /**
         * The HTTP method to use when invoking the S3 bucket.
         * <p>
         * Default: - integration method is used
         * <p>
         * @return {@code this}
         * @param method The HTTP method to use when invoking the S3 bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder method(final java.lang.String method) {
            this.props.method(method);
            return this;
        }

        /**
         * The path override to use when invoking the S3 bucket.
         * <p>
         * Default: - integration path is used
         * <p>
         * @return {@code this}
         * @param path The path override to use when invoking the S3 bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder path(final java.lang.String path) {
            this.props.path(path);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.aws.pdk.type_safe_api.S3Integration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.aws.pdk.type_safe_api.S3Integration build() {
            return new software.aws.pdk.type_safe_api.S3Integration(
                this.props.build()
            );
        }
    }
}
