package software.aws.pdk.type_safe_api;

/**
 * Options for the smithy build files.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.91.0 (build 1b1f239)", date = "2023-12-15T00:34:14.107Z")
@software.amazon.jsii.Jsii(module = software.aws.pdk.$Module.class, fqn = "@aws/pdk.type_safe_api.SmithyBuildOptions")
@software.amazon.jsii.Jsii.Proxy(SmithyBuildOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SmithyBuildOptions extends software.amazon.jsii.JsiiSerializable, software.aws.pdk.type_safe_api.SmithyCommon {

    /**
     * Paths to any additional model files or directories to be used as sources for the smithy build.
     * <p>
     * The src/main/smithy directory is always included.
     * Paths must be relative to the model project directory. Absolute paths will
     * be resolved as relative paths.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAdditionalSources() {
        return null;
    }

    /**
     * If a plugin can't be found, Smithy will by default fail the build.
     * <p>
     * This setting can be set to true to allow the build to progress
     * even if a plugin can't be found on the classpath.
     * <p>
     * Default: - no ignoreMissingPlugins set in the smithy-build.json file
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIgnoreMissingPlugins() {
        return null;
    }

    /**
     * Maven configuration for the Smithy build project, used to specify dependencies and repositories in the build.gradle and smithy-build.json files.
     * <p>
     * Default: the default configuration required for Smithy to OpenAPI conversion
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.aws.pdk.type_safe_api.SmithyMavenConfiguration getMaven() {
        return null;
    }

    /**
     * Map of projections name to projection configurations https://awslabs.github.io/smithy/2.0/guides/building-models/build-config.html#projections.
     * <p>
     * Default: - no projections
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.aws.pdk.type_safe_api.SmithyProjection> getProjections() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SmithyBuildOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SmithyBuildOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SmithyBuildOptions> {
        java.util.List<java.lang.String> additionalSources;
        java.lang.Boolean ignoreMissingPlugins;
        software.aws.pdk.type_safe_api.SmithyMavenConfiguration maven;
        java.util.Map<java.lang.String, software.aws.pdk.type_safe_api.SmithyProjection> projections;
        java.util.List<java.lang.String> imports;
        java.util.Map<java.lang.String, java.util.Map<java.lang.String, java.lang.Object>> plugins;

        /**
         * Sets the value of {@link SmithyBuildOptions#getAdditionalSources}
         * @param additionalSources Paths to any additional model files or directories to be used as sources for the smithy build.
         *                          The src/main/smithy directory is always included.
         *                          Paths must be relative to the model project directory. Absolute paths will
         *                          be resolved as relative paths.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalSources(java.util.List<java.lang.String> additionalSources) {
            this.additionalSources = additionalSources;
            return this;
        }

        /**
         * Sets the value of {@link SmithyBuildOptions#getIgnoreMissingPlugins}
         * @param ignoreMissingPlugins If a plugin can't be found, Smithy will by default fail the build.
         *                             This setting can be set to true to allow the build to progress
         *                             even if a plugin can't be found on the classpath.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ignoreMissingPlugins(java.lang.Boolean ignoreMissingPlugins) {
            this.ignoreMissingPlugins = ignoreMissingPlugins;
            return this;
        }

        /**
         * Sets the value of {@link SmithyBuildOptions#getMaven}
         * @param maven Maven configuration for the Smithy build project, used to specify dependencies and repositories in the build.gradle and smithy-build.json files.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maven(software.aws.pdk.type_safe_api.SmithyMavenConfiguration maven) {
            this.maven = maven;
            return this;
        }

        /**
         * Sets the value of {@link SmithyBuildOptions#getProjections}
         * @param projections Map of projections name to projection configurations https://awslabs.github.io/smithy/2.0/guides/building-models/build-config.html#projections.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder projections(java.util.Map<java.lang.String, ? extends software.aws.pdk.type_safe_api.SmithyProjection> projections) {
            this.projections = (java.util.Map<java.lang.String, software.aws.pdk.type_safe_api.SmithyProjection>)projections;
            return this;
        }

        /**
         * Sets the value of {@link SmithyBuildOptions#getImports}
         * @param imports List of imports.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imports(java.util.List<java.lang.String> imports) {
            this.imports = imports;
            return this;
        }

        /**
         * Sets the value of {@link SmithyBuildOptions#getPlugins}
         * @param plugins Plugins keyed by plugin id.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder plugins(java.util.Map<java.lang.String, ? extends java.util.Map<java.lang.String, ? extends java.lang.Object>> plugins) {
            this.plugins = (java.util.Map<java.lang.String, java.util.Map<java.lang.String, java.lang.Object>>)plugins;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SmithyBuildOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SmithyBuildOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SmithyBuildOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SmithyBuildOptions {
        private final java.util.List<java.lang.String> additionalSources;
        private final java.lang.Boolean ignoreMissingPlugins;
        private final software.aws.pdk.type_safe_api.SmithyMavenConfiguration maven;
        private final java.util.Map<java.lang.String, software.aws.pdk.type_safe_api.SmithyProjection> projections;
        private final java.util.List<java.lang.String> imports;
        private final java.util.Map<java.lang.String, java.util.Map<java.lang.String, java.lang.Object>> plugins;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.additionalSources = software.amazon.jsii.Kernel.get(this, "additionalSources", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.ignoreMissingPlugins = software.amazon.jsii.Kernel.get(this, "ignoreMissingPlugins", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.maven = software.amazon.jsii.Kernel.get(this, "maven", software.amazon.jsii.NativeType.forClass(software.aws.pdk.type_safe_api.SmithyMavenConfiguration.class));
            this.projections = software.amazon.jsii.Kernel.get(this, "projections", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.aws.pdk.type_safe_api.SmithyProjection.class)));
            this.imports = software.amazon.jsii.Kernel.get(this, "imports", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.plugins = software.amazon.jsii.Kernel.get(this, "plugins", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.additionalSources = builder.additionalSources;
            this.ignoreMissingPlugins = builder.ignoreMissingPlugins;
            this.maven = builder.maven;
            this.projections = (java.util.Map<java.lang.String, software.aws.pdk.type_safe_api.SmithyProjection>)builder.projections;
            this.imports = builder.imports;
            this.plugins = (java.util.Map<java.lang.String, java.util.Map<java.lang.String, java.lang.Object>>)builder.plugins;
        }

        @Override
        public final java.util.List<java.lang.String> getAdditionalSources() {
            return this.additionalSources;
        }

        @Override
        public final java.lang.Boolean getIgnoreMissingPlugins() {
            return this.ignoreMissingPlugins;
        }

        @Override
        public final software.aws.pdk.type_safe_api.SmithyMavenConfiguration getMaven() {
            return this.maven;
        }

        @Override
        public final java.util.Map<java.lang.String, software.aws.pdk.type_safe_api.SmithyProjection> getProjections() {
            return this.projections;
        }

        @Override
        public final java.util.List<java.lang.String> getImports() {
            return this.imports;
        }

        @Override
        public final java.util.Map<java.lang.String, java.util.Map<java.lang.String, java.lang.Object>> getPlugins() {
            return this.plugins;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAdditionalSources() != null) {
                data.set("additionalSources", om.valueToTree(this.getAdditionalSources()));
            }
            if (this.getIgnoreMissingPlugins() != null) {
                data.set("ignoreMissingPlugins", om.valueToTree(this.getIgnoreMissingPlugins()));
            }
            if (this.getMaven() != null) {
                data.set("maven", om.valueToTree(this.getMaven()));
            }
            if (this.getProjections() != null) {
                data.set("projections", om.valueToTree(this.getProjections()));
            }
            if (this.getImports() != null) {
                data.set("imports", om.valueToTree(this.getImports()));
            }
            if (this.getPlugins() != null) {
                data.set("plugins", om.valueToTree(this.getPlugins()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws/pdk.type_safe_api.SmithyBuildOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SmithyBuildOptions.Jsii$Proxy that = (SmithyBuildOptions.Jsii$Proxy) o;

            if (this.additionalSources != null ? !this.additionalSources.equals(that.additionalSources) : that.additionalSources != null) return false;
            if (this.ignoreMissingPlugins != null ? !this.ignoreMissingPlugins.equals(that.ignoreMissingPlugins) : that.ignoreMissingPlugins != null) return false;
            if (this.maven != null ? !this.maven.equals(that.maven) : that.maven != null) return false;
            if (this.projections != null ? !this.projections.equals(that.projections) : that.projections != null) return false;
            if (this.imports != null ? !this.imports.equals(that.imports) : that.imports != null) return false;
            return this.plugins != null ? this.plugins.equals(that.plugins) : that.plugins == null;
        }

        @Override
        public final int hashCode() {
            int result = this.additionalSources != null ? this.additionalSources.hashCode() : 0;
            result = 31 * result + (this.ignoreMissingPlugins != null ? this.ignoreMissingPlugins.hashCode() : 0);
            result = 31 * result + (this.maven != null ? this.maven.hashCode() : 0);
            result = 31 * result + (this.projections != null ? this.projections.hashCode() : 0);
            result = 31 * result + (this.imports != null ? this.imports.hashCode() : 0);
            result = 31 * result + (this.plugins != null ? this.plugins.hashCode() : 0);
            return result;
        }
    }
}
