package software.aws.pdk.type_safe_api;

/**
 * Project for a type-safe API, defined using Smithy or OpenAPI.
 * <p>
 * Generates a CDK construct to deploy your API, as well as client and server code to help build your API quickly.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.91.0 (build 1b1f239)", date = "2023-12-15T00:34:14.122Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.aws.pdk.$Module.class, fqn = "@aws/pdk.type_safe_api.TypeSafeApiProject")
public class TypeSafeApiProject extends io.github.cdklabs.projen.Project {

    protected TypeSafeApiProject(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected TypeSafeApiProject(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public TypeSafeApiProject(final @org.jetbrains.annotations.NotNull software.aws.pdk.type_safe_api.TypeSafeApiProjectOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Called after all components are synthesized.
     * <p>
     * Order is <em>not</em> guaranteed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void postSynthesize() {
        software.amazon.jsii.Kernel.call(this, "postSynthesize", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * Collections of all sub-projects managed by this project.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.aws.pdk.type_safe_api.ProjectCollections getAll() {
        return software.amazon.jsii.Kernel.get(this, "all", software.amazon.jsii.NativeType.forClass(software.aws.pdk.type_safe_api.ProjectCollections.class));
    }

    /**
     * Generated documentation projects.
     * <p>
     * Only the properties corresponding to specified <code>documentation.formats</code> will be defined.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.aws.pdk.type_safe_api.GeneratedDocumentationProjects getDocumentation() {
        return software.amazon.jsii.Kernel.get(this, "documentation", software.amazon.jsii.NativeType.forClass(software.aws.pdk.type_safe_api.GeneratedDocumentationProjects.class));
    }

    /**
     * Lambda handlers projects.
     * <p>
     * Only the properties corresponding to <code>handlers.languages</code> will be defined.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.aws.pdk.type_safe_api.GeneratedCodeProjects getHandlers() {
        return software.amazon.jsii.Kernel.get(this, "handlers", software.amazon.jsii.NativeType.forClass(software.aws.pdk.type_safe_api.GeneratedCodeProjects.class));
    }

    /**
     * Generated infrastructure projects.
     * <p>
     * Only the property corresponding to <code>infrastructure.language</code> will be defined.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.aws.pdk.type_safe_api.GeneratedCodeProjects getInfrastructure() {
        return software.amazon.jsii.Kernel.get(this, "infrastructure", software.amazon.jsii.NativeType.forClass(software.aws.pdk.type_safe_api.GeneratedCodeProjects.class));
    }

    /**
     * Generated library projects.
     * <p>
     * Only the properties corresponding to specified <code>library.libraries</code> will be defined.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.aws.pdk.type_safe_api.GeneratedLibraryProjects getLibrary() {
        return software.amazon.jsii.Kernel.get(this, "library", software.amazon.jsii.NativeType.forClass(software.aws.pdk.type_safe_api.GeneratedLibraryProjects.class));
    }

    /**
     * Project for the api model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.aws.pdk.type_safe_api.TypeSafeApiModelProject getModel() {
        return software.amazon.jsii.Kernel.get(this, "model", software.amazon.jsii.NativeType.forClass(software.aws.pdk.type_safe_api.TypeSafeApiModelProject.class));
    }

    /**
     * Generated runtime projects.
     * <p>
     * When <code>runtime.languages</code> includes the corresponding language, the project can be
     * assumed to be defined.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.aws.pdk.type_safe_api.GeneratedCodeProjects getRuntime() {
        return software.amazon.jsii.Kernel.get(this, "runtime", software.amazon.jsii.NativeType.forClass(software.aws.pdk.type_safe_api.GeneratedCodeProjects.class));
    }

    /**
     * A fluent builder for {@link software.aws.pdk.type_safe_api.TypeSafeApiProject}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.aws.pdk.type_safe_api.TypeSafeApiProject> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.aws.pdk.type_safe_api.TypeSafeApiProjectOptions.Builder options;

        private Builder() {
            this.options = new software.aws.pdk.type_safe_api.TypeSafeApiProjectOptions.Builder();
        }

        /**
         * (experimental) This is the name of your project.
         * <p>
         * Default: $BASEDIR
         * <p>
         * @return {@code this}
         * @param name This is the name of your project. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder name(final java.lang.String name) {
            this.options.name(name);
            return this;
        }

        /**
         * (experimental) Whether to commit the managed files by default.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param commitGenerated Whether to commit the managed files by default. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder commitGenerated(final java.lang.Boolean commitGenerated) {
            this.options.commitGenerated(commitGenerated);
            return this;
        }

        /**
         * (experimental) Configuration options for .gitignore file.
         * <p>
         * @return {@code this}
         * @param gitIgnoreOptions Configuration options for .gitignore file. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder gitIgnoreOptions(final io.github.cdklabs.projen.IgnoreFileOptions gitIgnoreOptions) {
            this.options.gitIgnoreOptions(gitIgnoreOptions);
            return this;
        }

        /**
         * (experimental) Configuration options for git.
         * <p>
         * @return {@code this}
         * @param gitOptions Configuration options for git. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder gitOptions(final io.github.cdklabs.projen.GitOptions gitOptions) {
            this.options.gitOptions(gitOptions);
            return this;
        }

        /**
         * (experimental) Configure logging options such as verbosity.
         * <p>
         * Default: {}
         * <p>
         * @return {@code this}
         * @param logging Configure logging options such as verbosity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder logging(final io.github.cdklabs.projen.LoggerOptions logging) {
            this.options.logging(logging);
            return this;
        }

        /**
         * (experimental) The root directory of the project.
         * <p>
         * Relative to this directory, all files are synthesized.
         * <p>
         * If this project has a parent, this directory is relative to the parent
         * directory and it cannot be the same as the parent or any of it's other
         * subprojects.
         * <p>
         * Default: "."
         * <p>
         * @return {@code this}
         * @param outdir The root directory of the project. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder outdir(final java.lang.String outdir) {
            this.options.outdir(outdir);
            return this;
        }

        /**
         * (experimental) The parent project, if this project is part of a bigger project.
         * <p>
         * @return {@code this}
         * @param parent The parent project, if this project is part of a bigger project. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder parent(final io.github.cdklabs.projen.Project parent) {
            this.options.parent(parent);
            return this;
        }

        /**
         * (experimental) The shell command to use in order to run the projen CLI.
         * <p>
         * Can be used to customize in special environments.
         * <p>
         * Default: "npx projen"
         * <p>
         * @return {@code this}
         * @param projenCommand The shell command to use in order to run the projen CLI. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder projenCommand(final java.lang.String projenCommand) {
            this.options.projenCommand(projenCommand);
            return this;
        }

        /**
         * (experimental) Generate (once) .projenrc.json (in JSON). Set to <code>false</code> in order to disable .projenrc.json generation.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param projenrcJson Generate (once) .projenrc.json (in JSON). Set to <code>false</code> in order to disable .projenrc.json generation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder projenrcJson(final java.lang.Boolean projenrcJson) {
            this.options.projenrcJson(projenrcJson);
            return this;
        }

        /**
         * (experimental) Options for .projenrc.json.
         * <p>
         * Default: - default options
         * <p>
         * @return {@code this}
         * @param projenrcJsonOptions Options for .projenrc.json. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder projenrcJsonOptions(final io.github.cdklabs.projen.ProjenrcJsonOptions projenrcJsonOptions) {
            this.options.projenrcJsonOptions(projenrcJsonOptions);
            return this;
        }

        /**
         * (experimental) Use renovatebot to handle dependency upgrades.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param renovatebot Use renovatebot to handle dependency upgrades. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder renovatebot(final java.lang.Boolean renovatebot) {
            this.options.renovatebot(renovatebot);
            return this;
        }

        /**
         * (experimental) Options for renovatebot.
         * <p>
         * Default: - default options
         * <p>
         * @return {@code this}
         * @param renovatebotOptions Options for renovatebot. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder renovatebotOptions(final io.github.cdklabs.projen.RenovatebotOptions renovatebotOptions) {
            this.options.renovatebotOptions(renovatebotOptions);
            return this;
        }

        /**
         * Configuration for generated infrastructure.
         * <p>
         * @return {@code this}
         * @param infrastructure Configuration for generated infrastructure. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder infrastructure(final software.aws.pdk.type_safe_api.InfrastructureConfiguration infrastructure) {
            this.options.infrastructure(infrastructure);
            return this;
        }

        /**
         * Configuration for the API model.
         * <p>
         * @return {@code this}
         * @param model Configuration for the API model. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder model(final software.aws.pdk.type_safe_api.ModelConfiguration model) {
            this.options.model(model);
            return this;
        }

        /**
         * Configuration for generated documentation.
         * <p>
         * @return {@code this}
         * @param documentation Configuration for generated documentation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder documentation(final software.aws.pdk.type_safe_api.DocumentationConfiguration documentation) {
            this.options.documentation(documentation);
            return this;
        }

        /**
         * Configuration for lambda handlers for implementing the API.
         * <p>
         * @return {@code this}
         * @param handlers Configuration for lambda handlers for implementing the API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder handlers(final software.aws.pdk.type_safe_api.HandlersConfiguration handlers) {
            this.options.handlers(handlers);
            return this;
        }

        /**
         * Configuration for generated libraries.
         * <p>
         * Libraries are projects which are generated from your model, but are not
         * fully-fledged runtimes, for example react hooks or clients in languages that aren't supported as runtimes.
         * <p>
         * @return {@code this}
         * @param library Configuration for generated libraries. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder library(final software.aws.pdk.type_safe_api.LibraryConfiguration library) {
            this.options.library(library);
            return this;
        }

        /**
         * Configuration for generated runtime projects (containing types, clients and server code).
         * <p>
         * @return {@code this}
         * @param runtime Configuration for generated runtime projects (containing types, clients and server code). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtime(final software.aws.pdk.type_safe_api.RuntimeConfiguration runtime) {
            this.options.runtime(runtime);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.aws.pdk.type_safe_api.TypeSafeApiProject}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.aws.pdk.type_safe_api.TypeSafeApiProject build() {
            return new software.aws.pdk.type_safe_api.TypeSafeApiProject(
                this.options.build()
            );
        }
    }
}
