/*
 * Decompiled with CFR 0.152.
 */
package software.aws.pdk.type_safe_api;

import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.RemovalPolicy;
import software.amazon.awscdk.Size;
import software.amazon.awscdk.services.apigateway.CorsOptions;
import software.amazon.awscdk.services.apigateway.DomainNameOptions;
import software.amazon.awscdk.services.apigateway.EndpointType;
import software.amazon.awscdk.services.apigateway.RestApiBaseProps;
import software.amazon.awscdk.services.apigateway.StageOptions;
import software.amazon.awscdk.services.iam.PolicyDocument;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;
import software.aws.pdk.$Module;
import software.aws.pdk.type_safe_api.ApiKeyOptions;
import software.aws.pdk.type_safe_api.Authorizer;
import software.aws.pdk.type_safe_api.OperationDetails;
import software.aws.pdk.type_safe_api.TypeSafeApiIntegration;
import software.aws.pdk.type_safe_api.TypeSafeApiOptions;
import software.aws.pdk.type_safe_api.TypeSafeApiWebAclOptions;
import software.aws.pdk.type_safe_api.TypeSafeRestApiProps;

@Jsii(module=$Module.class, fqn="@aws/pdk.type_safe_api.TypeSafeRestApiProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface TypeSafeRestApiProps
extends JsiiSerializable,
RestApiBaseProps,
TypeSafeApiOptions {
    @NotNull
    public String getSpecPath();

    @Nullable
    default public Size getMinCompressionSize() {
        return null;
    }

    @Nullable
    default public TypeSafeApiWebAclOptions getWebAclOptions() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<TypeSafeRestApiProps> {
        String specPath;
        Size minCompressionSize;
        TypeSafeApiWebAclOptions webAclOptions;
        Boolean cloudWatchRole;
        RemovalPolicy cloudWatchRoleRemovalPolicy;
        Boolean deploy;
        StageOptions deployOptions;
        String description;
        Boolean disableExecuteApiEndpoint;
        DomainNameOptions domainName;
        String endpointExportName;
        List<EndpointType> endpointTypes;
        Boolean failOnWarnings;
        Map<String, String> parameters;
        PolicyDocument policy;
        String restApiName;
        Boolean retainDeployments;
        Map<String, TypeSafeApiIntegration> integrations;
        Map<String, OperationDetails> operationLookup;
        ApiKeyOptions apiKeyOptions;
        CorsOptions corsOptions;
        Authorizer defaultAuthorizer;

        public Builder specPath(String specPath) {
            this.specPath = specPath;
            return this;
        }

        public Builder minCompressionSize(Size minCompressionSize) {
            this.minCompressionSize = minCompressionSize;
            return this;
        }

        public Builder webAclOptions(TypeSafeApiWebAclOptions webAclOptions) {
            this.webAclOptions = webAclOptions;
            return this;
        }

        public Builder cloudWatchRole(Boolean cloudWatchRole) {
            this.cloudWatchRole = cloudWatchRole;
            return this;
        }

        public Builder cloudWatchRoleRemovalPolicy(RemovalPolicy cloudWatchRoleRemovalPolicy) {
            this.cloudWatchRoleRemovalPolicy = cloudWatchRoleRemovalPolicy;
            return this;
        }

        public Builder deploy(Boolean deploy) {
            this.deploy = deploy;
            return this;
        }

        public Builder deployOptions(StageOptions deployOptions) {
            this.deployOptions = deployOptions;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder disableExecuteApiEndpoint(Boolean disableExecuteApiEndpoint) {
            this.disableExecuteApiEndpoint = disableExecuteApiEndpoint;
            return this;
        }

        public Builder domainName(DomainNameOptions domainName) {
            this.domainName = domainName;
            return this;
        }

        public Builder endpointExportName(String endpointExportName) {
            this.endpointExportName = endpointExportName;
            return this;
        }

        public Builder endpointTypes(List<? extends EndpointType> endpointTypes) {
            this.endpointTypes = endpointTypes;
            return this;
        }

        public Builder failOnWarnings(Boolean failOnWarnings) {
            this.failOnWarnings = failOnWarnings;
            return this;
        }

        public Builder parameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder policy(PolicyDocument policy) {
            this.policy = policy;
            return this;
        }

        public Builder restApiName(String restApiName) {
            this.restApiName = restApiName;
            return this;
        }

        public Builder retainDeployments(Boolean retainDeployments) {
            this.retainDeployments = retainDeployments;
            return this;
        }

        public Builder integrations(Map<String, ? extends TypeSafeApiIntegration> integrations) {
            this.integrations = integrations;
            return this;
        }

        public Builder operationLookup(Map<String, ? extends OperationDetails> operationLookup) {
            this.operationLookup = operationLookup;
            return this;
        }

        public Builder apiKeyOptions(ApiKeyOptions apiKeyOptions) {
            this.apiKeyOptions = apiKeyOptions;
            return this;
        }

        public Builder corsOptions(CorsOptions corsOptions) {
            this.corsOptions = corsOptions;
            return this;
        }

        public Builder defaultAuthorizer(Authorizer defaultAuthorizer) {
            this.defaultAuthorizer = defaultAuthorizer;
            return this;
        }

        public TypeSafeRestApiProps build() {
            return new Jsii.Proxy(this);
        }
    }
}

