package software.aws.pdk.aws_arch;

/**
 * AwsArchitecture provides an interface for retrieving the inferred normalization between <a href="https://github.com/aws/aws-cdk/blob/main/packages/%40aws-cdk/cfnspec">&#64;aws-cdk/cfnspec</a> and <a href="https://aws.amazon.com/architecture/icons/">AWS Architecture Icons</a> systems for all CloudFormation "services" and "resources".
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.88.0 (build eaabd08)", date = "2023-09-20T01:23:03.012Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.aws.pdk.$Module.class, fqn = "@aws/pdk.aws_arch.AwsArchitecture")
public class AwsArchitecture extends software.amazon.jsii.JsiiObject {

    protected AwsArchitecture(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AwsArchitecture(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Gets formatted asset path including extension and theme.
     * <p>
     * @return Relative asset file path
     * @param qualifiedAssetKey The qualified asset key (eg: compute/ec2/service_icon, storage/s3/bucket). This parameter is required.
     * @param format The format to return (eg: png, svg). This parameter is required.
     * @param theme <ul><li>(Optional) The theme to use, if not specific or now matching asset for the them, the default theme is used.</li></ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String formatAssetPath(final @org.jetbrains.annotations.NotNull java.lang.String qualifiedAssetKey, final @org.jetbrains.annotations.NotNull java.lang.String format, final @org.jetbrains.annotations.Nullable java.lang.String theme) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.aws.pdk.aws_arch.AwsArchitecture.class, "formatAssetPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(qualifiedAssetKey, "qualifiedAssetKey is required"), java.util.Objects.requireNonNull(format, "format is required"), theme });
    }

    /**
     * Gets formatted asset path including extension and theme.
     * <p>
     * @return Relative asset file path
     * @param qualifiedAssetKey The qualified asset key (eg: compute/ec2/service_icon, storage/s3/bucket). This parameter is required.
     * @param format The format to return (eg: png, svg). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String formatAssetPath(final @org.jetbrains.annotations.NotNull java.lang.String qualifiedAssetKey, final @org.jetbrains.annotations.NotNull java.lang.String format) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.aws.pdk.aws_arch.AwsArchitecture.class, "formatAssetPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(qualifiedAssetKey, "qualifiedAssetKey is required"), java.util.Objects.requireNonNull(format, "format is required") });
    }

    /**
     * Get specific category based on id.
     * <p>
     * @see <a href="{@link AwsCategory.getCategory }">{@link AwsCategory.getCategory }</a>
     * @param category This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.aws.pdk.aws_arch.AwsCategory getCategory(final @org.jetbrains.annotations.NotNull java.lang.String category) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.aws.pdk.aws_arch.AwsArchitecture.class, "getCategory", software.amazon.jsii.NativeType.forClass(software.aws.pdk.aws_arch.AwsCategory.class), new Object[] { java.util.Objects.requireNonNull(category, "category is required") });
    }

    /**
     * Get icon for EC2 instance type.
     * <p>
     * @return Returns relative asset icon path
     * @param instanceType - The {@link AwsAsset.InstanceType} to get icon for. This parameter is required.
     * @param format <ul><li>The format of icon.</li></ul>
     * @param theme <ul><li>Optional theme.</li></ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String getInstanceTypeIcon(final @org.jetbrains.annotations.NotNull java.lang.String instanceType, final @org.jetbrains.annotations.Nullable java.lang.String format, final @org.jetbrains.annotations.Nullable java.lang.String theme) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.aws.pdk.aws_arch.AwsArchitecture.class, "getInstanceTypeIcon", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(instanceType, "instanceType is required"), format, theme });
    }

    /**
     * Get icon for EC2 instance type.
     * <p>
     * @return Returns relative asset icon path
     * @param instanceType - The {@link AwsAsset.InstanceType} to get icon for. This parameter is required.
     * @param format <ul><li>The format of icon.</li></ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String getInstanceTypeIcon(final @org.jetbrains.annotations.NotNull java.lang.String instanceType, final @org.jetbrains.annotations.Nullable java.lang.String format) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.aws.pdk.aws_arch.AwsArchitecture.class, "getInstanceTypeIcon", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(instanceType, "instanceType is required"), format });
    }

    /**
     * Get icon for EC2 instance type.
     * <p>
     * @return Returns relative asset icon path
     * @param instanceType - The {@link AwsAsset.InstanceType} to get icon for. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String getInstanceTypeIcon(final @org.jetbrains.annotations.NotNull java.lang.String instanceType) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.aws.pdk.aws_arch.AwsArchitecture.class, "getInstanceTypeIcon", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(instanceType, "instanceType is required") });
    }

    /**
     * Get icon for RDS instance type.
     * <p>
     * @return Returns relative asset icon path
     * @param instanceType - The {@link AwsAsset.RdsInstanceType} to get icon for. This parameter is required.
     * @param format <ul><li>The format of icon.</li></ul>
     * @param theme <ul><li>Optional theme.</li></ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String getRdsInstanceTypeIcon(final @org.jetbrains.annotations.NotNull java.lang.String instanceType, final @org.jetbrains.annotations.Nullable java.lang.String format, final @org.jetbrains.annotations.Nullable java.lang.String theme) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.aws.pdk.aws_arch.AwsArchitecture.class, "getRdsInstanceTypeIcon", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(instanceType, "instanceType is required"), format, theme });
    }

    /**
     * Get icon for RDS instance type.
     * <p>
     * @return Returns relative asset icon path
     * @param instanceType - The {@link AwsAsset.RdsInstanceType} to get icon for. This parameter is required.
     * @param format <ul><li>The format of icon.</li></ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String getRdsInstanceTypeIcon(final @org.jetbrains.annotations.NotNull java.lang.String instanceType, final @org.jetbrains.annotations.Nullable java.lang.String format) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.aws.pdk.aws_arch.AwsArchitecture.class, "getRdsInstanceTypeIcon", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(instanceType, "instanceType is required"), format });
    }

    /**
     * Get icon for RDS instance type.
     * <p>
     * @return Returns relative asset icon path
     * @param instanceType - The {@link AwsAsset.RdsInstanceType} to get icon for. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String getRdsInstanceTypeIcon(final @org.jetbrains.annotations.NotNull java.lang.String instanceType) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.aws.pdk.aws_arch.AwsArchitecture.class, "getRdsInstanceTypeIcon", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(instanceType, "instanceType is required") });
    }

    /**
     * Get resource based on Cfn Resource Type (eg: AWS::S3::Bucket).
     * <p>
     * @see <a href="{@link AwsResource.getResource }">{@link AwsResource.getResource }</a>
     * @param cfnType This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.aws.pdk.aws_arch.AwsResource getResource(final @org.jetbrains.annotations.NotNull java.lang.String cfnType) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.aws.pdk.aws_arch.AwsArchitecture.class, "getResource", software.amazon.jsii.NativeType.forClass(software.aws.pdk.aws_arch.AwsResource.class), new Object[] { java.util.Objects.requireNonNull(cfnType, "cfnType is required") });
    }

    /**
     * Get specific service based on identifier (eg: S3, AWS::S3, AWS::S3::Bucket).
     * <p>
     * @see <a href="{@link AwsSerfice.getService }">{@link AwsSerfice.getService }</a>
     * @param identifier This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.aws.pdk.aws_arch.AwsService getService(final @org.jetbrains.annotations.NotNull java.lang.String identifier) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.aws.pdk.aws_arch.AwsArchitecture.class, "getService", software.amazon.jsii.NativeType.forClass(software.aws.pdk.aws_arch.AwsService.class), new Object[] { java.util.Objects.requireNonNull(identifier, "identifier is required") });
    }

    /**
     * Parse assets path into part descriptor.
     * <p>
     * @param assetPath <ul><li>Absolute or relative asset file path to parse.</li></ul> This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.aws.pdk.aws_arch.aws_arch.ParsedAssetKey parseAssetPath(final @org.jetbrains.annotations.NotNull java.lang.String assetPath) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.aws.pdk.aws_arch.AwsArchitecture.class, "parseAssetPath", software.amazon.jsii.NativeType.forClass(software.aws.pdk.aws_arch.aws_arch.ParsedAssetKey.class), new Object[] { java.util.Objects.requireNonNull(assetPath, "assetPath is required") });
    }

    /**
     * Resolve relative asset path to absolute asset path.
     * <p>
     * @return Absolute asset path
     * @param assetPath <ul><li>The relative asset path to resolve.</li></ul> This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String resolveAssetPath(final @org.jetbrains.annotations.NotNull java.lang.String assetPath) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.aws.pdk.aws_arch.AwsArchitecture.class, "resolveAssetPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(assetPath, "assetPath is required") });
    }

    /**
     * Resolve relative asset path as SVG <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Basics_of_HTTP/Data_URLs">Data URL</a>.
     * <p>
     * <code>data:image/svg+xml;base64,...</code>
     * <p>
     * @return SVG <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Basics_of_HTTP/Data_URLs">Data URL</a>
     * @param svgAssetPath <ul><li>The relative path of svg asset to resolve.</li></ul> This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String resolveAssetSvgDataUrl(final @org.jetbrains.annotations.NotNull java.lang.String svgAssetPath) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.aws.pdk.aws_arch.AwsArchitecture.class, "resolveAssetSvgDataUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(svgAssetPath, "svgAssetPath is required") });
    }

    /**
     * The absolute directory where <a href="https://aws.amazon.com/architecture/icons/">AWS Architecture Icons</a> are stored and retrieved.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String getAssetDirectory() {
        return software.amazon.jsii.JsiiObject.jsiiStaticGet(software.aws.pdk.aws_arch.AwsArchitecture.class, "assetDirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Get all categories.
     * <p>
     * @see <a href="{@link AwsCategory.categories }">{@link AwsCategory.categories }</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, software.aws.pdk.aws_arch.AwsCategory> getCategories() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.JsiiObject.jsiiStaticGet(software.aws.pdk.aws_arch.AwsArchitecture.class, "categories", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.aws.pdk.aws_arch.AwsCategory.class))));
    }

    /**
     * Get all resources.
     * <p>
     * @see <a href="{@link AwsResource.resources }">{@link AwsResource.resources }</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, software.aws.pdk.aws_arch.AwsResource> getResources() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.JsiiObject.jsiiStaticGet(software.aws.pdk.aws_arch.AwsArchitecture.class, "resources", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.aws.pdk.aws_arch.AwsResource.class))));
    }

    /**
     * Get all services.
     * <p>
     * @see <a href="{@link AwsService.services }">{@link AwsService.services }</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, software.aws.pdk.aws_arch.AwsService> getServices() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.JsiiObject.jsiiStaticGet(software.aws.pdk.aws_arch.AwsArchitecture.class, "services", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.aws.pdk.aws_arch.AwsService.class))));
    }
}
