package software.aws.pdk.aws_arch;

/**
 * AwsCategory class provides an interface for normalizing category metadata between mapped systems.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.88.0 (build eaabd08)", date = "2023-09-20T01:23:03.021Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.aws.pdk.$Module.class, fqn = "@aws/pdk.aws_arch.AwsCategory")
public class AwsCategory extends software.amazon.jsii.JsiiObject {

    protected AwsCategory(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AwsCategory(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Get {@link AwsCategory} based on {@link AwsCategoryId}.
     * <p>
     * @return Returns the category with the id
     * @param id The id of the category to retrieve. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.aws.pdk.aws_arch.AwsCategory getCategory(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.aws.pdk.aws_arch.AwsCategory.class, "getCategory", software.amazon.jsii.NativeType.forClass(software.aws.pdk.aws_arch.AwsCategory.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Gets a list of all services within this category.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.aws.pdk.aws_arch.AwsService> categoryServices() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "categoryServices", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.aws.pdk.aws_arch.AwsService.class))));
    }

    /**
     * Retrieves a well-formatted relative path to the icon for this given category in the specified format.
     * <p>
     * @param format This parameter is required.
     * @param theme
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String icon(final @org.jetbrains.annotations.NotNull java.lang.String format, final @org.jetbrains.annotations.Nullable java.lang.String theme) {
        return software.amazon.jsii.Kernel.call(this, "icon", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(format, "format is required"), theme });
    }

    /**
     * Retrieves a well-formatted relative path to the icon for this given category in the specified format.
     * <p>
     * @param format This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String icon(final @org.jetbrains.annotations.NotNull java.lang.String format) {
        return software.amazon.jsii.Kernel.call(this, "icon", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(format, "format is required") });
    }

    /**
     * Get record of all categories keyed by category id.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, software.aws.pdk.aws_arch.AwsCategory> getCategories() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.JsiiObject.jsiiStaticGet(software.aws.pdk.aws_arch.AwsCategory.class, "categories", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.aws.pdk.aws_arch.AwsCategory.class))));
    }

    /**
     * Fill color for the category.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFillColor() {
        return software.amazon.jsii.Kernel.get(this, "fillColor", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Font color for the category.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFontColor() {
        return software.amazon.jsii.Kernel.get(this, "fontColor", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Gradien color for the category.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getGradientColor() {
        return software.amazon.jsii.Kernel.get(this, "gradientColor", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique id of the category.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * "security_identity_compliance"
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getId() {
        return software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The proper name of the category.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * "Security, Identity, &amp; Compliance"
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Alternative names used to identity this category.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getVariants() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "variants", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * Drawio style definition for this category.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.aws.pdk.aws_arch.AwsCategoryDrawioStyles getDrawioStyles() {
        return software.amazon.jsii.Kernel.get(this, "drawioStyles", software.amazon.jsii.NativeType.forClass(software.aws.pdk.aws_arch.AwsCategoryDrawioStyles.class));
    }
}
