package software.aws.pdk.cdk_graph;

/**
 * Graph filter.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.88.0 (build eaabd08)", date = "2023-09-20T01:23:03.098Z")
@software.amazon.jsii.Jsii(module = software.aws.pdk.$Module.class, fqn = "@aws/pdk.cdk_graph.IGraphFilter")
@software.amazon.jsii.Jsii.Proxy(IGraphFilter.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IGraphFilter extends software.amazon.jsii.JsiiSerializable {

    /**
     * Indicates that all nodes will be filtered, rather than just Resource and CfnResource nodes.
     * <p>
     * By enabling this, all Stages, Stacks, and structural construct boundaries will be filtered as well.
     * In general, most users intent is to operate against resources and desire to preserve structural groupings,
     * which is common in most Cfn/Cdk based filtering where inputs are "include" lists.
     * Defaults to value of containing {@link IGraphFilterPlan.allNodes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAllNodes() {
        return null;
    }

    /**
     * Predicate to match edges.
     * <p>
     * Edges are evaluated after nodes are filtered.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.aws.pdk.cdk_graph.IEdgePredicate getEdge() {
        return null;
    }

    /**
     * Indicates that matches will be filtered, as opposed to non-matches.
     * <p>
     * The default follows common <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/filter">Javascript Array.filter</a>
     * precedence of preserving matches during filtering, while pruning non-matches.
     * <p>
     * Default: false - Preserve matches, and filter out non-matches.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getInverse() {
        return null;
    }

    /**
     * Predicate to match nodes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.aws.pdk.cdk_graph.INodePredicate getNode() {
        return null;
    }

    /**
     * Filter strategy to apply to matching nodes.
     * <p>
     * Edges do not have a strategy, they are always pruned.
     * <p>
     * Default: {FilterStrategy.PRUNE}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.aws.pdk.cdk_graph.FilterStrategy getStrategy() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link IGraphFilter}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link IGraphFilter}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<IGraphFilter> {
        java.lang.Boolean allNodes;
        software.aws.pdk.cdk_graph.IEdgePredicate edge;
        java.lang.Boolean inverse;
        software.aws.pdk.cdk_graph.INodePredicate node;
        software.aws.pdk.cdk_graph.FilterStrategy strategy;

        /**
         * Sets the value of {@link IGraphFilter#getAllNodes}
         * @param allNodes Indicates that all nodes will be filtered, rather than just Resource and CfnResource nodes.
         *                 By enabling this, all Stages, Stacks, and structural construct boundaries will be filtered as well.
         *                 In general, most users intent is to operate against resources and desire to preserve structural groupings,
         *                 which is common in most Cfn/Cdk based filtering where inputs are "include" lists.
         *                 
         *                 Defaults to value of containing {@link IGraphFilterPlan.allNodes}
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allNodes(java.lang.Boolean allNodes) {
            this.allNodes = allNodes;
            return this;
        }

        /**
         * Sets the value of {@link IGraphFilter#getEdge}
         * @param edge Predicate to match edges.
         *             Edges are evaluated after nodes are filtered.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder edge(software.aws.pdk.cdk_graph.IEdgePredicate edge) {
            this.edge = edge;
            return this;
        }

        /**
         * Sets the value of {@link IGraphFilter#getInverse}
         * @param inverse Indicates that matches will be filtered, as opposed to non-matches.
         *                The default follows common <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/filter">Javascript Array.filter</a>
         *                precedence of preserving matches during filtering, while pruning non-matches.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inverse(java.lang.Boolean inverse) {
            this.inverse = inverse;
            return this;
        }

        /**
         * Sets the value of {@link IGraphFilter#getNode}
         * @param node Predicate to match nodes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder node(software.aws.pdk.cdk_graph.INodePredicate node) {
            this.node = node;
            return this;
        }

        /**
         * Sets the value of {@link IGraphFilter#getStrategy}
         * @param strategy Filter strategy to apply to matching nodes.
         *                 Edges do not have a strategy, they are always pruned.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder strategy(software.aws.pdk.cdk_graph.FilterStrategy strategy) {
            this.strategy = strategy;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link IGraphFilter}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public IGraphFilter build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link IGraphFilter}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IGraphFilter {
        private final java.lang.Boolean allNodes;
        private final software.aws.pdk.cdk_graph.IEdgePredicate edge;
        private final java.lang.Boolean inverse;
        private final software.aws.pdk.cdk_graph.INodePredicate node;
        private final software.aws.pdk.cdk_graph.FilterStrategy strategy;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.allNodes = software.amazon.jsii.Kernel.get(this, "allNodes", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.edge = software.amazon.jsii.Kernel.get(this, "edge", software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.IEdgePredicate.class));
            this.inverse = software.amazon.jsii.Kernel.get(this, "inverse", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.node = software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.INodePredicate.class));
            this.strategy = software.amazon.jsii.Kernel.get(this, "strategy", software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.FilterStrategy.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.allNodes = builder.allNodes;
            this.edge = builder.edge;
            this.inverse = builder.inverse;
            this.node = builder.node;
            this.strategy = builder.strategy;
        }

        @Override
        public final java.lang.Boolean getAllNodes() {
            return this.allNodes;
        }

        @Override
        public final software.aws.pdk.cdk_graph.IEdgePredicate getEdge() {
            return this.edge;
        }

        @Override
        public final java.lang.Boolean getInverse() {
            return this.inverse;
        }

        @Override
        public final software.aws.pdk.cdk_graph.INodePredicate getNode() {
            return this.node;
        }

        @Override
        public final software.aws.pdk.cdk_graph.FilterStrategy getStrategy() {
            return this.strategy;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAllNodes() != null) {
                data.set("allNodes", om.valueToTree(this.getAllNodes()));
            }
            if (this.getEdge() != null) {
                data.set("edge", om.valueToTree(this.getEdge()));
            }
            if (this.getInverse() != null) {
                data.set("inverse", om.valueToTree(this.getInverse()));
            }
            if (this.getNode() != null) {
                data.set("node", om.valueToTree(this.getNode()));
            }
            if (this.getStrategy() != null) {
                data.set("strategy", om.valueToTree(this.getStrategy()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws/pdk.cdk_graph.IGraphFilter"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            IGraphFilter.Jsii$Proxy that = (IGraphFilter.Jsii$Proxy) o;

            if (this.allNodes != null ? !this.allNodes.equals(that.allNodes) : that.allNodes != null) return false;
            if (this.edge != null ? !this.edge.equals(that.edge) : that.edge != null) return false;
            if (this.inverse != null ? !this.inverse.equals(that.inverse) : that.inverse != null) return false;
            if (this.node != null ? !this.node.equals(that.node) : that.node != null) return false;
            return this.strategy != null ? this.strategy.equals(that.strategy) : that.strategy == null;
        }

        @Override
        public final int hashCode() {
            int result = this.allNodes != null ? this.allNodes.hashCode() : 0;
            result = 31 * result + (this.edge != null ? this.edge.hashCode() : 0);
            result = 31 * result + (this.inverse != null ? this.inverse.hashCode() : 0);
            result = 31 * result + (this.node != null ? this.node.hashCode() : 0);
            result = 31 * result + (this.strategy != null ? this.strategy.hashCode() : 0);
            return result;
        }
    }
}
