package software.aws.pdk.cdk_graph;

/**
 * Graph filter plan.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.88.0 (build eaabd08)", date = "2023-09-20T01:23:03.100Z")
@software.amazon.jsii.Jsii(module = software.aws.pdk.$Module.class, fqn = "@aws/pdk.cdk_graph.IGraphFilterPlan")
@software.amazon.jsii.Jsii.Proxy(IGraphFilterPlan.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IGraphFilterPlan extends software.amazon.jsii.JsiiSerializable {

    /**
     * Indicates that all nodes will be filtered, rather than just Resource and CfnResource nodes.
     * <p>
     * By enabling this, all Stages, Stacks, and structural construct boundaries will be filtered as well.
     * In general, most users intent is to operate against resources and desire to preserve structural groupings,
     * which is common in most Cfn/Cdk based filtering where inputs are "include" lists.
     * <p>
     * Default: false By default only Resource and CfnResource nodes are filtered.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAllNodes() {
        return null;
    }

    /**
     * Ordered list of {@link IGraphFilter} and {@link IGraphStoreFilter} filters to apply to the store.
     * <p>
     * <ul>
     * <li>Filters are applied <em>after</em> the preset filtering is applied if present.</li>
     * <li>Filters are applied sequentially against all nodes, as opposed to IAspect.visitor pattern
     * which are sequentially applied per node.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.aws.pdk.cdk_graph.IFilter> getFilters() {
        return null;
    }

    /**
     * Config to focus the graph on specific node.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.aws.pdk.cdk_graph.IGraphFilterPlanFocusConfig getFocus() {
        return null;
    }

    /**
     * The order to visit nodes and edges during filtering.
     * <p>
     * Default: {ConstructOrder.PREORDER}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.constructs.ConstructOrder getOrder() {
        return null;
    }

    /**
     * Optional preset filter to apply before other filters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.aws.pdk.cdk_graph.FilterPreset getPreset() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link IGraphFilterPlan}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link IGraphFilterPlan}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<IGraphFilterPlan> {
        java.lang.Boolean allNodes;
        java.util.List<software.aws.pdk.cdk_graph.IFilter> filters;
        software.aws.pdk.cdk_graph.IGraphFilterPlanFocusConfig focus;
        software.constructs.ConstructOrder order;
        software.aws.pdk.cdk_graph.FilterPreset preset;

        /**
         * Sets the value of {@link IGraphFilterPlan#getAllNodes}
         * @param allNodes Indicates that all nodes will be filtered, rather than just Resource and CfnResource nodes.
         *                 By enabling this, all Stages, Stacks, and structural construct boundaries will be filtered as well.
         *                 In general, most users intent is to operate against resources and desire to preserve structural groupings,
         *                 which is common in most Cfn/Cdk based filtering where inputs are "include" lists.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allNodes(java.lang.Boolean allNodes) {
            this.allNodes = allNodes;
            return this;
        }

        /**
         * Sets the value of {@link IGraphFilterPlan#getFilters}
         * @param filters Ordered list of {@link IGraphFilter} and {@link IGraphStoreFilter} filters to apply to the store.
         *                <ul>
         *                <li>Filters are applied <em>after</em> the preset filtering is applied if present.</li>
         *                <li>Filters are applied sequentially against all nodes, as opposed to IAspect.visitor pattern
         *                which are sequentially applied per node.</li>
         *                </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder filters(java.util.List<? extends software.aws.pdk.cdk_graph.IFilter> filters) {
            this.filters = (java.util.List<software.aws.pdk.cdk_graph.IFilter>)filters;
            return this;
        }

        /**
         * Sets the value of {@link IGraphFilterPlan#getFocus}
         * @param focus Config to focus the graph on specific node.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder focus(software.aws.pdk.cdk_graph.IGraphFilterPlanFocusConfig focus) {
            this.focus = focus;
            return this;
        }

        /**
         * Sets the value of {@link IGraphFilterPlan#getOrder}
         * @param order The order to visit nodes and edges during filtering.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder order(software.constructs.ConstructOrder order) {
            this.order = order;
            return this;
        }

        /**
         * Sets the value of {@link IGraphFilterPlan#getPreset}
         * @param preset Optional preset filter to apply before other filters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preset(software.aws.pdk.cdk_graph.FilterPreset preset) {
            this.preset = preset;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link IGraphFilterPlan}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public IGraphFilterPlan build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link IGraphFilterPlan}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IGraphFilterPlan {
        private final java.lang.Boolean allNodes;
        private final java.util.List<software.aws.pdk.cdk_graph.IFilter> filters;
        private final software.aws.pdk.cdk_graph.IGraphFilterPlanFocusConfig focus;
        private final software.constructs.ConstructOrder order;
        private final software.aws.pdk.cdk_graph.FilterPreset preset;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.allNodes = software.amazon.jsii.Kernel.get(this, "allNodes", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.filters = software.amazon.jsii.Kernel.get(this, "filters", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.IFilter.class)));
            this.focus = software.amazon.jsii.Kernel.get(this, "focus", software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.IGraphFilterPlanFocusConfig.class));
            this.order = software.amazon.jsii.Kernel.get(this, "order", software.amazon.jsii.NativeType.forClass(software.constructs.ConstructOrder.class));
            this.preset = software.amazon.jsii.Kernel.get(this, "preset", software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.FilterPreset.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.allNodes = builder.allNodes;
            this.filters = (java.util.List<software.aws.pdk.cdk_graph.IFilter>)builder.filters;
            this.focus = builder.focus;
            this.order = builder.order;
            this.preset = builder.preset;
        }

        @Override
        public final java.lang.Boolean getAllNodes() {
            return this.allNodes;
        }

        @Override
        public final java.util.List<software.aws.pdk.cdk_graph.IFilter> getFilters() {
            return this.filters;
        }

        @Override
        public final software.aws.pdk.cdk_graph.IGraphFilterPlanFocusConfig getFocus() {
            return this.focus;
        }

        @Override
        public final software.constructs.ConstructOrder getOrder() {
            return this.order;
        }

        @Override
        public final software.aws.pdk.cdk_graph.FilterPreset getPreset() {
            return this.preset;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAllNodes() != null) {
                data.set("allNodes", om.valueToTree(this.getAllNodes()));
            }
            if (this.getFilters() != null) {
                data.set("filters", om.valueToTree(this.getFilters()));
            }
            if (this.getFocus() != null) {
                data.set("focus", om.valueToTree(this.getFocus()));
            }
            if (this.getOrder() != null) {
                data.set("order", om.valueToTree(this.getOrder()));
            }
            if (this.getPreset() != null) {
                data.set("preset", om.valueToTree(this.getPreset()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws/pdk.cdk_graph.IGraphFilterPlan"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            IGraphFilterPlan.Jsii$Proxy that = (IGraphFilterPlan.Jsii$Proxy) o;

            if (this.allNodes != null ? !this.allNodes.equals(that.allNodes) : that.allNodes != null) return false;
            if (this.filters != null ? !this.filters.equals(that.filters) : that.filters != null) return false;
            if (this.focus != null ? !this.focus.equals(that.focus) : that.focus != null) return false;
            if (this.order != null ? !this.order.equals(that.order) : that.order != null) return false;
            return this.preset != null ? this.preset.equals(that.preset) : that.preset == null;
        }

        @Override
        public final int hashCode() {
            int result = this.allNodes != null ? this.allNodes.hashCode() : 0;
            result = 31 * result + (this.filters != null ? this.filters.hashCode() : 0);
            result = 31 * result + (this.focus != null ? this.focus.hashCode() : 0);
            result = 31 * result + (this.order != null ? this.order.hashCode() : 0);
            result = 31 * result + (this.preset != null ? this.preset.hashCode() : 0);
            return result;
        }
    }
}
