package software.aws.pdk.cdk_graph;

/**
 * Node class is the base definition of <strong>node</strong> entities in the graph, as in standard <a href="https://en.wikipedia.org/wiki/Graph_theory">graph theory</a>.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.88.0 (build eaabd08)", date = "2023-09-20T01:23:03.126Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.aws.pdk.$Module.class, fqn = "@aws/pdk.cdk_graph.Node")
public class Node extends software.aws.pdk.cdk_graph.BaseEntity implements software.aws.pdk.cdk_graph.ISerializableNode {

    protected Node(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Node(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Node(final @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.INodeProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Add <em>child</em> node.
     * <p>
     * @param node This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addChild(final @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.Node node) {
        software.amazon.jsii.Kernel.call(this, "addChild", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(node, "node is required") });
    }

    /**
     * Add <em>link</em> to another node.
     * <p>
     * @param edge This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addLink(final @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.Edge edge) {
        software.amazon.jsii.Kernel.call(this, "addLink", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(edge, "edge is required") });
    }

    /**
     * Add <em>link</em> from another node.
     * <p>
     * @param edge This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addReverseLink(final @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.Edge edge) {
        software.amazon.jsii.Kernel.call(this, "addReverseLink", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(edge, "edge is required") });
    }

    /**
     * Indicates if <em>this node</em> depends on <em>another node</em>.
     * <p>
     * @param node This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean doesDependOn(final @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.Node node) {
        return software.amazon.jsii.Kernel.call(this, "doesDependOn", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { java.util.Objects.requireNonNull(node, "node is required") });
    }

    /**
     * Indicates if <em>this node</em> references <em>another node</em>.
     * <p>
     * @param node This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean doesReference(final @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.Node node) {
        return software.amazon.jsii.Kernel.call(this, "doesReference", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { java.util.Objects.requireNonNull(node, "node is required") });
    }

    /**
     * Recursively find the nearest sub-node matching predicate.
     * <p>
     * @param predicate This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.aws.pdk.cdk_graph.Node find(final @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.INodePredicate predicate) {
        return software.amazon.jsii.Kernel.call(this, "find", software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.Node.class), new Object[] { java.util.Objects.requireNonNull(predicate, "predicate is required") });
    }

    /**
     * Return this construct and all of its sub-nodes in the given order.
     * <p>
     * Optionally filter nodes based on predicate.
     * <p>
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.aws.pdk.cdk_graph.Node> findAll(final @org.jetbrains.annotations.Nullable software.aws.pdk.cdk_graph.IFindNodeOptions options) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "findAll", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.Node.class)), new Object[] { options }));
    }

    /**
     * Return this construct and all of its sub-nodes in the given order.
     * <p>
     * Optionally filter nodes based on predicate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.aws.pdk.cdk_graph.Node> findAll() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "findAll", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.Node.class))));
    }

    /**
     * Return all direct links of this node and that of all sub-nodes.
     * <p>
     * Optionally filter links based on predicate.
     * <p>
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.aws.pdk.cdk_graph.Edge> findAllLinks(final @org.jetbrains.annotations.Nullable software.aws.pdk.cdk_graph.IFindEdgeOptions options) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "findAllLinks", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.Edge.class)), new Object[] { options }));
    }

    /**
     * Return all direct links of this node and that of all sub-nodes.
     * <p>
     * Optionally filter links based on predicate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.aws.pdk.cdk_graph.Edge> findAllLinks() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "findAllLinks", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.Edge.class))));
    }

    /**
     * Find nearest <em>ancestor</em> of <em>this node</em> matching given predicate.
     * <p>
     * @param predicate <ul><li>Predicate to match ancestor.</li></ul> This parameter is required.
     * @param max
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.aws.pdk.cdk_graph.Node findAncestor(final @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.INodePredicate predicate, final @org.jetbrains.annotations.Nullable java.lang.Number max) {
        return software.amazon.jsii.Kernel.call(this, "findAncestor", software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.Node.class), new Object[] { java.util.Objects.requireNonNull(predicate, "predicate is required"), max });
    }

    /**
     * Find nearest <em>ancestor</em> of <em>this node</em> matching given predicate.
     * <p>
     * @param predicate <ul><li>Predicate to match ancestor.</li></ul> This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.aws.pdk.cdk_graph.Node findAncestor(final @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.INodePredicate predicate) {
        return software.amazon.jsii.Kernel.call(this, "findAncestor", software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.Node.class), new Object[] { java.util.Objects.requireNonNull(predicate, "predicate is required") });
    }

    /**
     * Find child with given <em>id</em>.
     * <p>
     * Similar to <code>find</code> but does not throw error if no child found.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.aws.pdk.cdk_graph.Node findChild(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "findChild", software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.Node.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Find link of this node based on predicate.
     * <p>
     * By default this will follow link
     * chains to evaluate the predicate against and return the matching direct link
     * of this node.
     * <p>
     * @param predicate Edge predicate function to match edge. This parameter is required.
     * @param reverse Indicates if links are search in reverse order.
     * @param follow Indicates if link chain is followed.
     * @param direct Indicates that only <em>direct</em> links should be searched.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.aws.pdk.cdk_graph.Edge findLink(final @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.IEdgePredicate predicate, final @org.jetbrains.annotations.Nullable java.lang.Boolean reverse, final @org.jetbrains.annotations.Nullable java.lang.Boolean follow, final @org.jetbrains.annotations.Nullable java.lang.Boolean direct) {
        return software.amazon.jsii.Kernel.call(this, "findLink", software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.Edge.class), new Object[] { java.util.Objects.requireNonNull(predicate, "predicate is required"), reverse, follow, direct });
    }

    /**
     * Find link of this node based on predicate.
     * <p>
     * By default this will follow link
     * chains to evaluate the predicate against and return the matching direct link
     * of this node.
     * <p>
     * @param predicate Edge predicate function to match edge. This parameter is required.
     * @param reverse Indicates if links are search in reverse order.
     * @param follow Indicates if link chain is followed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.aws.pdk.cdk_graph.Edge findLink(final @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.IEdgePredicate predicate, final @org.jetbrains.annotations.Nullable java.lang.Boolean reverse, final @org.jetbrains.annotations.Nullable java.lang.Boolean follow) {
        return software.amazon.jsii.Kernel.call(this, "findLink", software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.Edge.class), new Object[] { java.util.Objects.requireNonNull(predicate, "predicate is required"), reverse, follow });
    }

    /**
     * Find link of this node based on predicate.
     * <p>
     * By default this will follow link
     * chains to evaluate the predicate against and return the matching direct link
     * of this node.
     * <p>
     * @param predicate Edge predicate function to match edge. This parameter is required.
     * @param reverse Indicates if links are search in reverse order.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.aws.pdk.cdk_graph.Edge findLink(final @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.IEdgePredicate predicate, final @org.jetbrains.annotations.Nullable java.lang.Boolean reverse) {
        return software.amazon.jsii.Kernel.call(this, "findLink", software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.Edge.class), new Object[] { java.util.Objects.requireNonNull(predicate, "predicate is required"), reverse });
    }

    /**
     * Find link of this node based on predicate.
     * <p>
     * By default this will follow link
     * chains to evaluate the predicate against and return the matching direct link
     * of this node.
     * <p>
     * @param predicate Edge predicate function to match edge. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.aws.pdk.cdk_graph.Edge findLink(final @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.IEdgePredicate predicate) {
        return software.amazon.jsii.Kernel.call(this, "findLink", software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.Edge.class), new Object[] { java.util.Objects.requireNonNull(predicate, "predicate is required") });
    }

    /**
     * Find all links of this node based on predicate.
     * <p>
     * By default this will follow link
     * chains to evaluate the predicate against and return the matching direct links
     * of this node.
     * <p>
     * @param predicate Edge predicate function to match edge. This parameter is required.
     * @param reverse Indicates if links are search in reverse order.
     * @param follow Indicates if link chain is followed.
     * @param direct Indicates that only <em>direct</em> links should be searched.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.aws.pdk.cdk_graph.Edge> findLinks(final @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.IEdgePredicate predicate, final @org.jetbrains.annotations.Nullable java.lang.Boolean reverse, final @org.jetbrains.annotations.Nullable java.lang.Boolean follow, final @org.jetbrains.annotations.Nullable java.lang.Boolean direct) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "findLinks", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.Edge.class)), new Object[] { java.util.Objects.requireNonNull(predicate, "predicate is required"), reverse, follow, direct }));
    }

    /**
     * Find all links of this node based on predicate.
     * <p>
     * By default this will follow link
     * chains to evaluate the predicate against and return the matching direct links
     * of this node.
     * <p>
     * @param predicate Edge predicate function to match edge. This parameter is required.
     * @param reverse Indicates if links are search in reverse order.
     * @param follow Indicates if link chain is followed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.aws.pdk.cdk_graph.Edge> findLinks(final @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.IEdgePredicate predicate, final @org.jetbrains.annotations.Nullable java.lang.Boolean reverse, final @org.jetbrains.annotations.Nullable java.lang.Boolean follow) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "findLinks", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.Edge.class)), new Object[] { java.util.Objects.requireNonNull(predicate, "predicate is required"), reverse, follow }));
    }

    /**
     * Find all links of this node based on predicate.
     * <p>
     * By default this will follow link
     * chains to evaluate the predicate against and return the matching direct links
     * of this node.
     * <p>
     * @param predicate Edge predicate function to match edge. This parameter is required.
     * @param reverse Indicates if links are search in reverse order.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.aws.pdk.cdk_graph.Edge> findLinks(final @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.IEdgePredicate predicate, final @org.jetbrains.annotations.Nullable java.lang.Boolean reverse) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "findLinks", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.Edge.class)), new Object[] { java.util.Objects.requireNonNull(predicate, "predicate is required"), reverse }));
    }

    /**
     * Find all links of this node based on predicate.
     * <p>
     * By default this will follow link
     * chains to evaluate the predicate against and return the matching direct links
     * of this node.
     * <p>
     * @param predicate Edge predicate function to match edge. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.aws.pdk.cdk_graph.Edge> findLinks(final @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.IEdgePredicate predicate) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "findLinks", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.Edge.class)), new Object[] { java.util.Objects.requireNonNull(predicate, "predicate is required") }));
    }

    /**
     * Get specific CloudFormation property.
     * <p>
     * @param key This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCfnProp(final @org.jetbrains.annotations.NotNull java.lang.String key) {
        return software.amazon.jsii.Kernel.call(this, "getCfnProp", software.amazon.jsii.NativeType.forClass(java.lang.Object.class), new Object[] { java.util.Objects.requireNonNull(key, "key is required") });
    }

    /**
     * Get <em>child</em> node with given <em>id</em>.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.Node getChild(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "getChild", software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.Node.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Resolve all link chains.
     * <p>
     * @see <a href="{@link EdgeChain }">{@link EdgeChain }</a>
     * @param reverse
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.util.List<java.lang.Object>> getLinkChains(final @org.jetbrains.annotations.Nullable java.lang.Boolean reverse) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "getLinkChains", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))), new Object[] { reverse }));
    }

    /**
     * Resolve all link chains.
     * <p>
     * @see <a href="{@link EdgeChain }">{@link EdgeChain }</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.util.List<java.lang.Object>> getLinkChains() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "getLinkChains", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)))));
    }

    /**
     * Gets the nearest <strong>common</strong> <em>ancestor</em> shared between <em>this node</em> and another <em>node</em>.
     * <p>
     * @param node This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.Node getNearestAncestor(final @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.Node node) {
        return software.amazon.jsii.Kernel.call(this, "getNearestAncestor", software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.Node.class), new Object[] { java.util.Objects.requireNonNull(node, "node is required") });
    }

    /**
     * Indicates if a specific <em>node</em> is an <em>ancestor</em> of <em>this node</em>.
     * <p>
     * @param ancestor This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean isAncestor(final @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.Node ancestor) {
        return software.amazon.jsii.Kernel.call(this, "isAncestor", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { java.util.Objects.requireNonNull(ancestor, "ancestor is required") });
    }

    /**
     * Indicates if specific <em>node</em> is a <em>child</em> of <em>this node</em>.
     * <p>
     * @param node This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean isChild(final @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.Node node) {
        return software.amazon.jsii.Kernel.call(this, "isChild", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { java.util.Objects.requireNonNull(node, "node is required") });
    }

    /**
     * Collapses all sub-nodes of <em>this node</em> into <em>this node</em>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void mutateCollapse() {
        software.amazon.jsii.Kernel.call(this, "mutateCollapse", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * Collapses <em>this node</em> into <em>an ancestor</em>.
     * <p>
     * @param ancestor This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.Node mutateCollapseTo(final @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.Node ancestor) {
        return software.amazon.jsii.Kernel.call(this, "mutateCollapseTo", software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.Node.class), new Object[] { java.util.Objects.requireNonNull(ancestor, "ancestor is required") });
    }

    /**
     * Collapses <em>this node</em> into <em>it's parent node</em>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.Node mutateCollapseToParent() {
        return software.amazon.jsii.Kernel.call(this, "mutateCollapseToParent", software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.Node.class));
    }

    /**
     * Destroys this node by removing all references and removing this node from the store.
     * <p>
     * @param strict <ul><li>Indicates that this node must not have references.</li></ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void mutateDestroy(final @org.jetbrains.annotations.Nullable java.lang.Boolean strict) {
        software.amazon.jsii.Kernel.call(this, "mutateDestroy", software.amazon.jsii.NativeType.VOID, new Object[] { strict });
    }

    /**
     * Destroys this node by removing all references and removing this node from the store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void mutateDestroy() {
        software.amazon.jsii.Kernel.call(this, "mutateDestroy", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * Hoist <em>this node</em> to an <em>ancestor</em> by removing it from its current parent node and in turn moving it to the ancestor.
     * <p>
     * @param newParent This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void mutateHoist(final @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.Node newParent) {
        software.amazon.jsii.Kernel.call(this, "mutateHoist", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(newParent, "newParent is required") });
    }

    /**
     * Move this node into a new parent node.
     * <p>
     * @param newParent <ul><li>The parent to move this node to.</li></ul> This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void mutateMove(final @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.Node newParent) {
        software.amazon.jsii.Kernel.call(this, "mutateMove", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(newParent, "newParent is required") });
    }

    /**
     * Remove a <em>child</em> node from <em>this node</em>.
     * <p>
     * @param node This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean mutateRemoveChild(final @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.Node node) {
        return software.amazon.jsii.Kernel.call(this, "mutateRemoveChild", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { java.util.Objects.requireNonNull(node, "node is required") });
    }

    /**
     * Remove a <em>link</em> from <em>this node</em>.
     * <p>
     * @param link This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean mutateRemoveLink(final @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.Edge link) {
        return software.amazon.jsii.Kernel.call(this, "mutateRemoveLink", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { java.util.Objects.requireNonNull(link, "link is required") });
    }

    /**
     * Remove a <em>link</em> to <em>this node</em>.
     * <p>
     * @param link This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean mutateRemoveReverseLink(final @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.Edge link) {
        return software.amazon.jsii.Kernel.call(this, "mutateRemoveReverseLink", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { java.util.Objects.requireNonNull(link, "link is required") });
    }

    /**
     * Hoist all children to parent and collapse node to parent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void mutateUncluster() {
        software.amazon.jsii.Kernel.call(this, "mutateUncluster", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * Get string representation of this node.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Indicates if this node allows destructive mutations.
     * <p>
     * @see <a href="{@link Store.allowDestructiveMutations }">{@link Store.allowDestructiveMutations }</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getAllowDestructiveMutations() {
        return software.amazon.jsii.Kernel.get(this, "allowDestructiveMutations", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * Get all direct child nodes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.aws.pdk.cdk_graph.Node> getChildren() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "children", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.Node.class))));
    }

    /**
     * Get list of <strong>Nodes</strong> that <em>depend on this node</em>.
     * <p>
     * @see <a href="{@link Node.reverseDependencyLinks }">{@link Node.reverseDependencyLinks }</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.aws.pdk.cdk_graph.Node> getDependedOnBy() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "dependedOnBy", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.Node.class))));
    }

    /**
     * Get list of <strong>Nodes</strong> that <em>this node depends on</em>.
     * <p>
     * @see <a href="{@link Node.dependencyLinks }">{@link Node.dependencyLinks }</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.aws.pdk.cdk_graph.Node> getDependencies() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "dependencies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.Node.class))));
    }

    /**
     * Gets list of {@link Dependency} links (edges) where this node is the **source**.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.aws.pdk.cdk_graph.Dependency> getDependencyLinks() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "dependencyLinks", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.Dependency.class))));
    }

    /**
     * Indicates the depth of the node relative to root (0).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getDepth() {
        return software.amazon.jsii.Kernel.get(this, "depth", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Node id, which is only unique within parent scope.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getId() {
        return software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Indicates if this node is considered a {@link FlagEnum.ASSET}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getIsAsset() {
        return software.amazon.jsii.Kernel.get(this, "isAsset", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * Indicates if node ConstructInfoFqn denotes a <code>aws-cdk-lib.*.Cfn*</code> construct.
     * <p>
     * @see <a href="{@link FlagEnum.CFN_FQN }">{@link FlagEnum.CFN_FQN }</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getIsCfnFqn() {
        return software.amazon.jsii.Kernel.get(this, "isCfnFqn", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * Indicates if this node is considered a {@link FlagEnum.CLUSTER}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getIsCluster() {
        return software.amazon.jsii.Kernel.get(this, "isCluster", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * Indicates if node is a <em>Custom Resource</em>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getIsCustomResource() {
        return software.amazon.jsii.Kernel.get(this, "isCustomResource", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * Indicates if this node is considered a {@link FlagEnum.EXTRANEOUS} node or determined to be extraneous: - Clusters that contain no children.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getIsExtraneous() {
        return software.amazon.jsii.Kernel.get(this, "isExtraneous", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * Indicates if this node is considered a {@link FlagEnum.GRAPH_CONTAINER}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getIsGraphContainer() {
        return software.amazon.jsii.Kernel.get(this, "isGraphContainer", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * Indicates if this node is a <em>leaf</em> node, which means it does not have children.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getIsLeaf() {
        return software.amazon.jsii.Kernel.get(this, "isLeaf", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * Indicates if node is direct child of the graph root node.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getIsTopLevel() {
        return software.amazon.jsii.Kernel.get(this, "isTopLevel", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * Gets all links (edges) in which this node is the <strong>source</strong>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.aws.pdk.cdk_graph.Edge> getLinks() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "links", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.Edge.class))));
    }

    /**
     * Type of node.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.NodeTypeEnum getNodeType() {
        return software.amazon.jsii.Kernel.get(this, "nodeType", software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.NodeTypeEnum.class));
    }

    /**
     * Path of the node.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPath() {
        return software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Get list of <strong>Nodes</strong> that <em>reference this node</em>.
     * <p>
     * @see <a href="{@link Node.reverseReferenceLinks }">{@link Node.reverseReferenceLinks }</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.aws.pdk.cdk_graph.Node> getReferencedBy() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "referencedBy", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.Node.class))));
    }

    /**
     * Gets list of {@link Reference} links (edges) where this node is the **source**.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.aws.pdk.cdk_graph.Reference> getReferenceLinks() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "referenceLinks", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.Reference.class))));
    }

    /**
     * Get list of <strong>Nodes</strong> that <em>this node references</em>.
     * <p>
     * @see <a href="{@link Node.referenceLinks }">{@link Node.referenceLinks }</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.aws.pdk.cdk_graph.Node> getReferences() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "references", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.Node.class))));
    }

    /**
     * Gets list of {@link Dependency} links (edges) where this node is the **target**.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.aws.pdk.cdk_graph.Dependency> getReverseDependencyLinks() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "reverseDependencyLinks", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.Dependency.class))));
    }

    /**
     * Gets all links (edges) in which this node is the <strong>target</strong>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.aws.pdk.cdk_graph.Edge> getReverseLinks() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "reverseLinks", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.Edge.class))));
    }

    /**
     * Gets list of {@link Reference} links (edges) where this node is the **target**.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.aws.pdk.cdk_graph.Reference> getReverseReferenceLinks() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "reverseReferenceLinks", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.Reference.class))));
    }

    /**
     * Gets descending ordered list of ancestors from the root.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.aws.pdk.cdk_graph.Node> getScopes() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "scopes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.Node.class))));
    }

    /**
     * Get list of <em>siblings</em> of this node.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.aws.pdk.cdk_graph.Node> getSiblings() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "siblings", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.Node.class))));
    }

    /**
     * Gets CloudFormation properties for this node.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.aws.pdk.cdk_graph.PlainObject getCfnProps() {
        return software.amazon.jsii.Kernel.get(this, "cfnProps", software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.PlainObject.class));
    }

    /**
     * Get the CloudFormation resource type for this node.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCfnType() {
        return software.amazon.jsii.Kernel.get(this, "cfnType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Synthesized construct information defining jii resolution data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.aws.pdk.cdk_graph.ConstructInfo getConstructInfo() {
        return software.amazon.jsii.Kernel.get(this, "constructInfo", software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.ConstructInfo.class));
    }

    /**
     * Synthesized construct information defining jii resolution data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getConstructInfoFqn() {
        return software.amazon.jsii.Kernel.get(this, "constructInfoFqn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Logical id of the node, which is only unique within containing stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLogicalId() {
        return software.amazon.jsii.Kernel.get(this, "logicalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Parent node.
     * <p>
     * Only the root node should not have parent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.aws.pdk.cdk_graph.Node getParent() {
        return software.amazon.jsii.Kernel.get(this, "parent", software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.Node.class));
    }

    /**
     * Get <strong>root</strong> stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.aws.pdk.cdk_graph.StackNode getRootStack() {
        return software.amazon.jsii.Kernel.get(this, "rootStack", software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.StackNode.class));
    }

    /**
     * Stack the node is contained in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.aws.pdk.cdk_graph.StackNode getStack() {
        return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.StackNode.class));
    }
}
