package software.aws.pdk.cdk_graph;

/**
 * Store class provides the in-memory database-like interface for managing all entities in the graph.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.88.0 (build eaabd08)", date = "2023-09-20T01:23:03.149Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.aws.pdk.$Module.class, fqn = "@aws/pdk.cdk_graph.Store")
public class Store extends software.amazon.jsii.JsiiObject implements software.aws.pdk.cdk_graph.ISerializableGraphStore {

    protected Store(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Store(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param allowDestructiveMutations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Store(final @org.jetbrains.annotations.Nullable java.lang.Boolean allowDestructiveMutations) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { allowDestructiveMutations });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Store() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Builds store from serialized store data.
     * <p>
     * @param serializedStore This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.Store fromSerializedStore(final @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.SGGraphStore serializedStore) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.aws.pdk.cdk_graph.Store.class, "fromSerializedStore", software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.Store.class), new Object[] { java.util.Objects.requireNonNull(serializedStore, "serializedStore is required") });
    }

    /**
     * Add <strong>edge</strong> to the store.
     * <p>
     * @param edge This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addEdge(final @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.Edge edge) {
        software.amazon.jsii.Kernel.call(this, "addEdge", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(edge, "edge is required") });
    }

    /**
     * Add <strong>node</strong> to the store.
     * <p>
     * @param node This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addNode(final @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.Node node) {
        software.amazon.jsii.Kernel.call(this, "addNode", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(node, "node is required") });
    }

    /**
     * Add <strong>stack</strong> node to the store.
     * <p>
     * @param stack This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addStack(final @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.StackNode stack) {
        software.amazon.jsii.Kernel.call(this, "addStack", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(stack, "stack is required") });
    }

    /**
     * Add <strong>stage</strong> to the store.
     * <p>
     * @param stage This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addStage(final @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.StageNode stage) {
        software.amazon.jsii.Kernel.call(this, "addStage", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(stage, "stage is required") });
    }

    /**
     * Clone the store to allow destructive mutations.
     * <p>
     * @return Returns a clone of the store that allows destructive mutations
     * @param allowDestructiveMutations Indicates if destructive mutations are allowed;.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.Store clone(final @org.jetbrains.annotations.Nullable java.lang.Boolean allowDestructiveMutations) {
        return software.amazon.jsii.Kernel.call(this, "clone", software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.Store.class), new Object[] { allowDestructiveMutations });
    }

    /**
     * Clone the store to allow destructive mutations.
     * <p>
     * @return Returns a clone of the store that allows destructive mutations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.Store clone() {
        return software.amazon.jsii.Kernel.call(this, "clone", software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.Store.class));
    }

    /**
     * Compute <strong>universal</strong> <em>logicalId</em> based on parent stack and construct <em>logicalId</em> (<code>&lt;stack&gt;:&lt;logicalId&gt;</code>).
     * <p>
     * Construct *logicalIds are only unique within their containing stack, so to use <em>logicalId</em>
     * lookups universally (like resolving references) we need a universal key.
     * <p>
     * @param stack This parameter is required.
     * @param logicalId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String computeLogicalUniversalId(final @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.StackNode stack, final @org.jetbrains.annotations.NotNull java.lang.String logicalId) {
        return software.amazon.jsii.Kernel.call(this, "computeLogicalUniversalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(stack, "stack is required"), java.util.Objects.requireNonNull(logicalId, "logicalId is required") });
    }

    /**
     * Attempts to lookup the {@link Node} associated with a given *import arn token*.
     * <p>
     * @return Returns matching {@link Node } if found, otherwise undefined.
     * @param value Import arn value, which is either object to tokenize or already tokenized string. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.aws.pdk.cdk_graph.Node findNodeByImportArn(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        return software.amazon.jsii.Kernel.call(this, "findNodeByImportArn", software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.Node.class), new Object[] { value });
    }

    /**
     * Find node within given <strong>stack</strong> with given <em>logicalId</em>.
     * <p>
     * @param stack This parameter is required.
     * @param logicalId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.Node findNodeByLogicalId(final @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.StackNode stack, final @org.jetbrains.annotations.NotNull java.lang.String logicalId) {
        return software.amazon.jsii.Kernel.call(this, "findNodeByLogicalId", software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.Node.class), new Object[] { java.util.Objects.requireNonNull(stack, "stack is required"), java.util.Objects.requireNonNull(logicalId, "logicalId is required") });
    }

    /**
     * Find node by <strong>universal</strong> <em>logicalId</em> (<code>&lt;stack&gt;:&lt;logicalId&gt;</code>).
     * <p>
     * @param uid This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.Node findNodeByLogicalUniversalId(final @org.jetbrains.annotations.NotNull java.lang.String uid) {
        return software.amazon.jsii.Kernel.call(this, "findNodeByLogicalUniversalId", software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.Node.class), new Object[] { java.util.Objects.requireNonNull(uid, "uid is required") });
    }

    /**
     * Get stored <strong>edge</strong> by UUID.
     * <p>
     * @param uuid This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.Edge getEdge(final @org.jetbrains.annotations.NotNull java.lang.String uuid) {
        return software.amazon.jsii.Kernel.call(this, "getEdge", software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.Edge.class), new Object[] { java.util.Objects.requireNonNull(uuid, "uuid is required") });
    }

    /**
     * Get stored <strong>node</strong> by UUID.
     * <p>
     * @param uuid This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.Node getNode(final @org.jetbrains.annotations.NotNull java.lang.String uuid) {
        return software.amazon.jsii.Kernel.call(this, "getNode", software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.Node.class), new Object[] { java.util.Objects.requireNonNull(uuid, "uuid is required") });
    }

    /**
     * Get stored <strong>stack</strong> node by UUID.
     * <p>
     * @param uuid This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.StackNode getStack(final @org.jetbrains.annotations.NotNull java.lang.String uuid) {
        return software.amazon.jsii.Kernel.call(this, "getStack", software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.StackNode.class), new Object[] { java.util.Objects.requireNonNull(uuid, "uuid is required") });
    }

    /**
     * Get stored <strong>stage</strong> node by UUID.
     * <p>
     * @param uuid This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.StageNode getStage(final @org.jetbrains.annotations.NotNull java.lang.String uuid) {
        return software.amazon.jsii.Kernel.call(this, "getStage", software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.StageNode.class), new Object[] { java.util.Objects.requireNonNull(uuid, "uuid is required") });
    }

    /**
     * Remove <strong>edge</strong> from the store.
     * <p>
     * @param edge This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean mutateRemoveEdge(final @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.Edge edge) {
        return software.amazon.jsii.Kernel.call(this, "mutateRemoveEdge", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { java.util.Objects.requireNonNull(edge, "edge is required") });
    }

    /**
     * Remove <strong>node</strong> from the store.
     * <p>
     * @param node This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean mutateRemoveNode(final @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.Node node) {
        return software.amazon.jsii.Kernel.call(this, "mutateRemoveNode", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { java.util.Objects.requireNonNull(node, "node is required") });
    }

    /**
     * Records arn tokens from imported resources (eg: <code>s3.Bucket.fromBucketArn()</code>) that are used for resolving references.
     * <p>
     * @param arnToken This parameter is required.
     * @param resource This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void recordImportArn(final @org.jetbrains.annotations.NotNull java.lang.String arnToken, final @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.Node resource) {
        software.amazon.jsii.Kernel.call(this, "recordImportArn", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(arnToken, "arnToken is required"), java.util.Objects.requireNonNull(resource, "resource is required") });
    }

    /**
     * Record a <strong>universal</strong> <em>logicalId</em> to node mapping in the store.
     * <p>
     * @param stack This parameter is required.
     * @param logicalId This parameter is required.
     * @param resource This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void recordLogicalId(final @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.StackNode stack, final @org.jetbrains.annotations.NotNull java.lang.String logicalId, final @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.Node resource) {
        software.amazon.jsii.Kernel.call(this, "recordLogicalId", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(stack, "stack is required"), java.util.Objects.requireNonNull(logicalId, "logicalId is required"), java.util.Objects.requireNonNull(resource, "resource is required") });
    }

    /**
     * Serialize the store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.SGGraphStore serialize() {
        return software.amazon.jsii.Kernel.call(this, "serialize", software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.SGGraphStore.class));
    }

    /**
     * Verifies that the store allows destructive mutations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void verifyDestructiveMutationAllowed() {
        software.amazon.jsii.Kernel.call(this, "verifyDestructiveMutationAllowed", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * Indicates if the store allows destructive mutations.
     * <p>
     * Destructive mutations are only allowed on clones of the store to prevent plugins and filters from
     * mutating the store for downstream plugins.
     * <p>
     * All <code>mutate*</code> methods are only allowed on stores that allow destructive mutations.
     * <p>
     * This behavior may change in the future if the need arises for plugins to pass mutated stores
     * to downstream plugins. But it will be done cautiously with ensuring the intent of
     * downstream plugin is to receive the mutated store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getAllowDestructiveMutations() {
        return software.amazon.jsii.Kernel.get(this, "allowDestructiveMutations", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * Get record of all store counters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.IStoreCounts getCounts() {
        return software.amazon.jsii.Kernel.get(this, "counts", software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.IStoreCounts.class));
    }

    /**
     * Gets all stored <strong>edges</strong>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.aws.pdk.cdk_graph.Edge> getEdges() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "edges", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.Edge.class))));
    }

    /**
     * Gets all stored <strong>nodes</strong>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.aws.pdk.cdk_graph.Node> getNodes() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "nodes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.Node.class))));
    }

    /**
     * Root node in the store.
     * <p>
     * The <strong>root</strong> node is not the computed root, but the graph root
     * which is auto-generated and can not be mutated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.aws.pdk.cdk_graph.RootNode getRoot() {
        return software.amazon.jsii.Kernel.get(this, "root", software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.RootNode.class));
    }

    /**
     * Gets all stored <strong>root stack</strong> nodes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.aws.pdk.cdk_graph.StackNode> getRootStacks() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "rootStacks", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.StackNode.class))));
    }

    /**
     * Gets all stored <strong>stack</strong> nodes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.aws.pdk.cdk_graph.StackNode> getStacks() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "stacks", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.StackNode.class))));
    }

    /**
     * Gets all stored <strong>stage</strong> nodes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.aws.pdk.cdk_graph.StageNode> getStages() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "stages", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.aws.pdk.cdk_graph.StageNode.class))));
    }

    /**
     * Current SemVer version of the store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getVersion() {
        return software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
