package software.aws.pdk.monorepo;

/**
 * Configues common NX related tasks and methods.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.88.0 (build eaabd08)", date = "2023-09-20T01:23:03.439Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.aws.pdk.$Module.class, fqn = "@aws/pdk.monorepo.NxConfigurator")
public class NxConfigurator extends io.github.cdklabs.projen.Component implements software.aws.pdk.monorepo.INxProjectCore {

    protected NxConfigurator(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected NxConfigurator(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param project This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public NxConfigurator(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.Project project, final @org.jetbrains.annotations.Nullable software.aws.pdk.monorepo.NxConfiguratorOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(project, "project is required"), options });
    }

    /**
     * @param project This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public NxConfigurator(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.Project project) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(project, "project is required") });
    }

    /**
     * Create an implicit dependency between two Projects.
     * <p>
     * This is typically
     * used in polygot repos where a Typescript project wants a build dependency
     * on a Python project as an example.
     * <p>
     * @param dependent project you want to have the dependency. This parameter is required.
     * @param dependee project you wish to depend on. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addImplicitDependency(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.Project dependent, final @org.jetbrains.annotations.NotNull java.lang.Object dependee) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            if (
                 !(dependee instanceof java.lang.String)
                && !(dependee instanceof io.github.cdklabs.projen.Project)
            ) {
                throw new IllegalArgumentException(
                    new java.lang.StringBuilder("Expected ")
                        .append("dependee")
                        .append(" to be one of: java.lang.String, io.github.cdklabs.projen.Project; received ")
                        .append(dependee.getClass()).toString());
            }
        }
        software.amazon.jsii.Kernel.call(this, "addImplicitDependency", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(dependent, "dependent is required"), java.util.Objects.requireNonNull(dependee, "dependee is required") });
    }

    /**
     * Adds a dependency between two Java Projects in the monorepo.
     * <p>
     * @param dependent project you want to have the dependency. This parameter is required.
     * @param dependee project you wish to depend on. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addJavaDependency(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.java.JavaProject dependent, final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.java.JavaProject dependee) {
        software.amazon.jsii.Kernel.call(this, "addJavaDependency", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(dependent, "dependent is required"), java.util.Objects.requireNonNull(dependee, "dependee is required") });
    }

    /**
     * Add project task that executes <code>npx nx run-many ...</code> style command.
     * <p>
     * @param name This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.Task addNxRunManyTask(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.NotNull software.aws.pdk.monorepo.nx.RunManyOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addNxRunManyTask", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.Task.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Adds a dependency between two Python Projects in the monorepo.
     * <p>
     * The dependent must have Poetry enabled.
     * <p>
     * @param dependent project you want to have the dependency (must be a Poetry Python Project). This parameter is required.
     * @param dependee project you wish to depend on. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addPythonPoetryDependency(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.python.PythonProject dependent, final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.python.PythonProject dependee) {
        software.amazon.jsii.Kernel.call(this, "addPythonPoetryDependency", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(dependent, "dependent is required"), java.util.Objects.requireNonNull(dependee, "dependee is required") });
    }

    /**
     * Helper to format <code>npx nx run-many ...</code> style command.
     * <p>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> composeNxRunManyCommand(final @org.jetbrains.annotations.NotNull software.aws.pdk.monorepo.nx.RunManyOptions options) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "composeNxRunManyCommand", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(options, "options is required") }));
    }

    /**
     * Returns the install task or creates one with nx installation command added.
     * <p>
     * Note: this should only be called from non-node projects
     * <p>
     * @return install task
     * @param nxPlugins additional plugins to install. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.Task ensureNxInstallTask(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.String> nxPlugins) {
        return software.amazon.jsii.Kernel.call(this, "ensureNxInstallTask", software.amazon.jsii.NativeType.forClass(io.github.cdklabs.projen.Task.class), new Object[] { java.util.Objects.requireNonNull(nxPlugins, "nxPlugins is required") });
    }

    /**
     * Helper to format <code>npx nx run-many ...</code> style command execution in package manager.
     * <p>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.String execNxRunManyCommand(final @org.jetbrains.annotations.NotNull software.aws.pdk.monorepo.nx.RunManyOptions options) {
        return software.amazon.jsii.Kernel.call(this, "execNxRunManyCommand", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * @param project This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void patchPoetryInstall(final @org.jetbrains.annotations.NotNull io.github.cdklabs.projen.python.PythonProject project) {
        software.amazon.jsii.Kernel.call(this, "patchPoetryInstall", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(project, "project is required") });
    }

    /**
     * @param projects This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void patchPythonProjects(final @org.jetbrains.annotations.NotNull java.util.List<io.github.cdklabs.projen.Project> projects) {
        software.amazon.jsii.Kernel.call(this, "patchPythonProjects", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(projects, "projects is required") });
    }

    /**
     * Called before synthesis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void preSynthesize() {
        software.amazon.jsii.Kernel.call(this, "preSynthesize", software.amazon.jsii.NativeType.VOID);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void synth() {
        software.amazon.jsii.Kernel.call(this, "synth", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * Return the NxWorkspace instance.
     * <p>
     * This should be implemented using a getter.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.aws.pdk.monorepo.NxWorkspace getNx() {
        return software.amazon.jsii.Kernel.get(this, "nx", software.amazon.jsii.NativeType.forClass(software.aws.pdk.monorepo.NxWorkspace.class));
    }

    /**
     * A fluent builder for {@link software.aws.pdk.monorepo.NxConfigurator}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.aws.pdk.monorepo.NxConfigurator> {
        /**
         * @return a new instance of {@link Builder}.
         * @param project This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final io.github.cdklabs.projen.Project project) {
            return new Builder(project);
        }

        private final io.github.cdklabs.projen.Project project;
        private software.aws.pdk.monorepo.NxConfiguratorOptions.Builder options;

        private Builder(final io.github.cdklabs.projen.Project project) {
            this.project = project;
        }

        /**
         * Branch that NX affected should run against.
         * <p>
         * @return {@code this}
         * @param defaultReleaseBranch Branch that NX affected should run against. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultReleaseBranch(final java.lang.String defaultReleaseBranch) {
            this.options().defaultReleaseBranch(defaultReleaseBranch);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.aws.pdk.monorepo.NxConfigurator}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.aws.pdk.monorepo.NxConfigurator build() {
            return new software.aws.pdk.monorepo.NxConfigurator(
                this.project,
                this.options != null ? this.options.build() : null
            );
        }

        private software.aws.pdk.monorepo.NxConfiguratorOptions.Builder options() {
            if (this.options == null) {
                this.options = new software.aws.pdk.monorepo.NxConfiguratorOptions.Builder();
            }
            return this.options;
        }
    }
}
