package software.aws.pdk.type_safe_api;

/**
 * Creates a project which transforms a Smithy model to OpenAPI.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.88.0 (build eaabd08)", date = "2023-09-20T01:23:03.583Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.aws.pdk.$Module.class, fqn = "@aws/pdk.type_safe_api.SmithyDefinition")
public class SmithyDefinition extends io.github.cdklabs.projen.Component {

    protected SmithyDefinition(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SmithyDefinition(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param project This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SmithyDefinition(final @org.jetbrains.annotations.NotNull software.aws.pdk.type_safe_api.TypeSafeApiModelProject project, final @org.jetbrains.annotations.NotNull software.aws.pdk.type_safe_api.SmithyDefinitionOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(project, "project is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Add maven-style or local file dependencies to the smithy model project.
     * <p>
     * @param deps dependencies to add, eg "software.amazon.smithy:smithy-validation-model:1.27.2" or "file://../some/path/build/lib/my-shapes.jar. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addDeps(final @org.jetbrains.annotations.NotNull java.lang.String... deps) {
        software.amazon.jsii.Kernel.call(this, "addDeps", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(deps).toArray(Object[]::new));
    }

    /**
     * Add dependencies on other smithy models, such that their shapes can be imported in this project.
     * <p>
     * @param deps smithy definitions to depend on. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addSmithyDeps(final @org.jetbrains.annotations.NotNull software.aws.pdk.type_safe_api.SmithyDefinition... deps) {
        software.amazon.jsii.Kernel.call(this, "addSmithyDeps", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(deps).toArray(Object[]::new));
    }

    /**
     * Add additional paths to model source files or directories.
     * <p>
     * Paths should be relative to the project outdir. Any absolute paths will be
     * resolved as relative paths.
     * <p>
     * @param sources This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addSources(final @org.jetbrains.annotations.NotNull java.lang.String... sources) {
        software.amazon.jsii.Kernel.call(this, "addSources", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(sources).toArray(Object[]::new));
    }

    /**
     * Name of the gradle project.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getGradleProjectName() {
        return software.amazon.jsii.Kernel.get(this, "gradleProjectName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Path to the generated OpenAPI specification, relative to the project outdir.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getOpenApiSpecificationPath() {
        return software.amazon.jsii.Kernel.get(this, "openApiSpecificationPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Path to the json Smithy model, relative to the project outdir.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSmithyJsonModelPath() {
        return software.amazon.jsii.Kernel.get(this, "smithyJsonModelPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.aws.pdk.type_safe_api.SmithyDefinition}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.aws.pdk.type_safe_api.SmithyDefinition> {
        /**
         * @return a new instance of {@link Builder}.
         * @param project This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.aws.pdk.type_safe_api.TypeSafeApiModelProject project) {
            return new Builder(project);
        }

        private final software.aws.pdk.type_safe_api.TypeSafeApiModelProject project;
        private final software.aws.pdk.type_safe_api.SmithyDefinitionOptions.Builder options;

        private Builder(final software.aws.pdk.type_safe_api.TypeSafeApiModelProject project) {
            this.project = project;
            this.options = new software.aws.pdk.type_safe_api.SmithyDefinitionOptions.Builder();
        }

        /**
         * Smithy engine options.
         * <p>
         * @return {@code this}
         * @param smithyOptions Smithy engine options. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder smithyOptions(final software.aws.pdk.type_safe_api.SmithyModelOptions smithyOptions) {
            this.options.smithyOptions(smithyOptions);
            return this;
        }

        /**
         * The languages users have specified for handler projects (if any).
         * <p>
         * @return {@code this}
         * @param handlerLanguages The languages users have specified for handler projects (if any). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder handlerLanguages(final java.util.List<? extends software.aws.pdk.type_safe_api.Language> handlerLanguages) {
            this.options.handlerLanguages(handlerLanguages);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.aws.pdk.type_safe_api.SmithyDefinition}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.aws.pdk.type_safe_api.SmithyDefinition build() {
            return new software.aws.pdk.type_safe_api.SmithyDefinition(
                this.project,
                this.options.build()
            );
        }
    }
}
